

  {extends file="main.tpl"}
    <!DOCTYPE head PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd"><head xmlns="http://www.w3.org/1999/xhtml">
  {block name=title}GPSBabel development:OpenStreetMap data files (osm){/block}
  {block name=body}{literal}
                       
  <div xmlns="http://www.w3.org/1999/xhtml" class="navheader"><table width="100%" summary="Navigation header"><tr><th colspan="3" align="center">OpenStreetMap data files (osm)</th></tr><tr><td width="20%" align="left"><a accesskey="p" href="fmt_lmx.html">Prev</a> </td><th width="60%" align="center">Chapter 3. The Formats</th><td width="20%" align="right"> <a accesskey="n" href="fmt_ozi.html">Next</a></td></tr></table><hr /></div><div xmlns="http://www.w3.org/1999/xhtml" class="section"><div class="titlepage"><div><div><h2 class="title" ><a id="fmt_osm"></a>OpenStreetMap data files (osm)</h2></div></div></div><p class="fmtcapshdr">
    This format can...
    </p><div class="itemizedlist"><ul class="itemizedlist" style="list-style-type: disc; "><li class="listitem"><p class="fmtcapsitem">
          read and write waypoints
        </p></li><li class="listitem"><p class="fmtcapsitem">
          write tracks
        </p></li><li class="listitem"><p class="fmtcapsitem">
          read and write routes
        </p></li></ul></div><p>This format has the following options: <a class="link" href="fmt_osm.html#fmt_osm_o_tag" title="tag option">tag</a>, <a class="link" href="fmt_osm.html#fmt_osm_o_tagnd" title="tagnd option">tagnd</a>, <a class="link" href="fmt_osm.html#fmt_osm_o_created_by" title="created_by option">created_by</a> .</p><p>
  This format is used to exchange data with the <a class="ulink" href="http://www.openstreetmap.org" target="_top">OpenStreetMap</a> project. 
  The main goal of this collaborative project is to create free editable maps.
</p><p>
  These data files are XML based. Every GPS element (way or node) described by the files has a unique
  number as identifier. When we write OSM data files and don't know something about the id's,
  negative numbers will be used as identifier. This has been tested with <a class="ulink" href="http://wiki.openstreetmap.org/index.php/JOSM" target="_top">JOSM</a>.
</p><p>
  Because the resulting timestamps of OSM ways differ from real GPS tracks, 
  we read OSM ways into routes. On the output side we write all available routes and tracks into the osm target file.
</p><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_osm_o_tag"></a><code class="option">tag</code> option</h3></div></div></div><p>
      Write additional way tag key/value pairs.
    </p><p>
  With this option you can preset OSM <a class="ulink" href="http://wiki.openstreetmap.org/index.php/Map_Features" target="_top">features</a> (tags) on all exported ways.
</p><p>
  <strong class="userinput"><code>gpsbabel -i gdb -f ways.gdb -o osm,tag="highway:motorway" -F ways.osm</code></strong>
</p></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_osm_o_tagnd"></a><code class="option">tagnd</code> option</h3></div></div></div><p>
      Write additional node tag key/value pairs.
    </p><p>
  With this option you can preset OSM <a class="ulink" href="http://wiki.openstreetmap.org/index.php/Map_Features" target="_top">features</a> (tags) on every written nodes.
</p><p>
  <strong class="userinput"><code>gpsbabel -i gdb -f nodes.gdb -o osm,tagnd="amenity:pub;building:yes" -F nodes.osm</code></strong>
</p></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_osm_o_created_by"></a><code class="option">created_by</code> option</h3></div></div></div><p>
      Use this value as custom created_by value.
    </p><p> Use this value as custom created_by value in an OSM file.</p><p>
With this option, the given string is added as the 'created_by' field in 
all the created nodes and ways.
</p><p>
<strong class="userinput"><code>
gpsbabel -i INTYPE -f INFILE -o osm,created_by=somestring -F out.osm
</code></strong>
</p><p>
  If an empty string is given, the 'created_by' tag is omitted altogether.
</p><p>
<strong class="userinput"><code>
gpsbabel -i INTYPE -f INFILE -o osm,created_by= -F out.osm
</code></strong>
</p></div></div><div xmlns="http://www.w3.org/1999/xhtml" class="navfooter"><hr /><table width="100%" summary="Navigation footer"><tr><td width="40%" align="left"><a accesskey="p" href="fmt_lmx.html">Prev</a> </td><td width="20%" align="center"><a accesskey="u" href="The_Formats.html">Up</a></td><td width="40%" align="right"> <a accesskey="n" href="fmt_ozi.html">Next</a></td></tr><tr><td width="40%" align="left" valign="top">Nokia Landmark Exchange (lmx) </td><td width="20%" align="center"><a accesskey="h" href="index.html">Home</a></td><td width="40%" align="right" valign="top"> OziExplorer (ozi)</td></tr></table></div>
  
      {/literal}{/block}
  