

  {extends file="main.tpl"}
    <!DOCTYPE head PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd"><head xmlns="http://www.w3.org/1999/xhtml">
  {block name=title}GPSBabel development:Defining Fields Within the File{/block}
  {block name=body}{literal}
                       
  <div xmlns="http://www.w3.org/1999/xhtml" class="navheader"><table width="100%" summary="Navigation header"><tr><th colspan="3" align="center">Defining Fields Within the File</th></tr><tr><td width="20%" align="left"><a accesskey="p" href="style_layout.html">Prev</a> </td><th width="60%" align="center">Appendix C. GPSBabel XCSV Style Files</th><td width="20%" align="right"> <a accesskey="n" href="style_examples.html">Next</a></td></tr></table><hr /></div><div xmlns="http://www.w3.org/1999/xhtml" class="section"><div class="titlepage"><div><div><h2 class="title" ><a id="style_define"></a>Defining Fields Within the File</h2></div></div></div><p>
A field defines data.  There are two different classifications of FIELDS,
IFIELD (file input) and OFIELD (file output).  In the absence of any OFIELDS,
IFIELDS are use as both input and output.  The existence of OFIELDS is 
primarily to allow more flexible mapping of GPSBabel data to output data 
(say, for instance, to map the internal GPSBabel "description" variable to 
two or more fields on output).  For all practical purposes, IFIELDS and 
OFIELDS are defined the same way in the style file.</p><p>The following per-field options are defined:
</p><div class="itemizedlist"><ul class="itemizedlist" style="list-style-type: disc; "><li class="listitem"><p>
   "no_delim_before" is supported on in OFIELD tags to specify that this
   field should be written without a field delimiter before it.  It's
   useful for limited field concatenation.
</p></li><li class="listitem"><p>
   "absolute" is supported on OFIELD tags for lat and lon to indicate
   that only absolute values (never negative) are to be printed.
</p></li><li class="listitem"><p>
   "optional" is supported only OFIELD tags and indicates that the
   field may or may not be available in the source data.  If the
   field is absent, no trailing field separator is written.
</p><p>
   This attribute is most useful when paired with "no_delim_before" as
   it allows you to concatenate fields without concern for whether those
   fields are actually populated or not.
</p></li></ul></div><p>
There are several different types of fields that may be defined.  Each field 
consists of three pieces of information: the FIELD TYPE, a DEFAULT VALUE, and 
a PRINTF CONVERSION (for output).  In many cases, not all pieces are used,
but all 3 pieces are required.   Additionally, an fourth field is supported
that modifies the behaviour of the field being described.
</p><p>
FIELDS should be defined in the style file in the logical order that they
appear in the data, from left to right.  This is the order in which they are
parsed from input and written to output.
</p><p>
The fields used by the XCSV parser are as follows:
</p><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="style_def_ignore"></a>IGNORE</h3></div></div></div><p>
   IGNORE fields are, guess what, ignored on input.   Internally, IGNORE 
   fields are treated as CHARACTER data, and as such, require a printf 
   conversion for a character array.  
</p><p>
examples:
</p><pre class="screen">   IFIELD IGNORE,"","%14.14s"   # (writes a 14 character blank field)
   IFIELD IGNORE,"","%s"        # (writes a blank field on output)
</pre></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="style_def_constant"></a>CONSTANT</h3></div></div></div><p>
   CONSTANT fields are, of course, constant.  They are ignored on input, 
   however they write CONSTANT data on output.  As such, they require a 
   DEFAULT VALUE and a printf conversion for a character array. 
</p><p>
examples:
</p><pre class="screen">   IFIELD CONSTANT,"FFFFFF","%s"   # (writes "FFFFFF" in the field)
   IFIELD CONSTANT,"01/01/70","%s" # (a constant date field)
</pre></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="style_def_index"></a>INDEX</h3></div></div></div><p>
   An INDEX field is used ONLY on output.  The INDEX constant defines a field 
   that, at output, contains the sequence number of the waypoint being 
   written, starting at 0.  An index is managed internally as an INTEGER 
   and requires an INTEGER printf conversion.  An INDEX has one special
   property.  The DEFAULT VALUE of the index is added to the index 
   on each iteration (to allow indexes starting at 1, 100, etc..).   
</p><p>
examples:
</p><pre class="screen">   IFIELD INDEX,"0","%04d"     # (Starts counting at zero)
   IFIELD INDEX,"","%04d"      # (Starts counting at zero)
   IFIELD INDEX,"1","%04d"     # (Starts counting at one)
</pre></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="style_def_shortname"></a>SHORTNAME</h3></div></div></div><p>
   A SHORTNAME is generally the waypoint name of the data being processed.  
   SHORTNAME maps directly to the GPSBabel variable -&gt;shortname.  A SHORTNAME 
   is CHARACTER data and requires a character array printf conversion.
</p><p>
example:
</p><pre class="screen">   IFIELD SHORTNAME,"","%s"
</pre></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="style_def_description"></a>DESCRIPTION</h3></div></div></div><p>
   A DESCRIPTION is generally a long description of the waypoint.  A 
   DESCRIPTION maps to the GPSBabel variable -&gt;description and is otherwise 
   handled exactly like a SHORTNAME.
</p><p>
examples:
</p><pre class="screen">   IFIELD DESCRIPTION,"","%s" 
</pre></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="style_def_notes"></a>NOTES</h3></div></div></div><p>
   NOTES are generally everything else about a waypoints. NOTES map to the 
   GPSBabel variable -&gt;notes and is otherwise handled exactly like a 
   SHORTNAME.
</p></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="style_def_url"></a>URL</h3></div></div></div><p>
   URL is a URL for the waypoint.  URL maps to the GPSBabel variable 
   -&gt;url and is otherwise handled exactly like a SHORTNAME.
</p><p>
example:
</p><pre class="screen">   IFIELD URL,"","%s"
</pre></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="style_def_urllinktext"></a>URL_LINK_TEXT</h3></div></div></div><p>
   URL_LINK_TEXT is a textual description of where a URL points.  
   URL_LINK_TEXT maps to the GPSBabel variable -&gt;url_link_text and 
   is otherwise handled exactly like a SHORTNAME.
</p><p>
example:
</p><pre class="screen">   IFIELD URL_LINK_TEXT,"","%s" 
</pre></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="style_def_icondescr"></a>ICON_DESCR</h3></div></div></div><p>
   ICON_DESCR is a textual description of an icon type for a waypoint.
   ICON_DESCR maps to the GPSBabel variable -&gt;icon_desc and is otherwise 
   handled exactly like a SHORTNAME.
</p><p>
example:
</p><pre class="screen">   IFIELD ICON_DESCR,"","%s" 
</pre></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="style_def_latdec"></a>LAT_DECIMAL</h3></div></div></div><p>
   LAT_DECIMAL defines LATITUDE in DECIMAL format.  Note that this is a PURE 
   signed decimal format (i.e. -91.0000).  This data is handled internally as 
   a DOUBLE PRECISION FLOAT and requires a FLOATING POINT printf conversion.
</p><p>
example:
</p><pre class="screen">   IFIELD LAT_DECIMAL,"","%f"
</pre></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="style_def_londec"></a>LON_DECIMAL</h3></div></div></div><p>
   See LAT_DECIMAL, except LON_DECIMAL defines LONGITUDE.
</p></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="style_def_latint32"></a>LAT_INT32DEG</h3></div></div></div><p>
   LAT_INT32DEG defines LATITUDE in what I call INT32DEGREES.  This value is 
   a signed LONG INTEGER and requires a LONG INTEGER printf conversion.
   (This format is only used by some DeLorme products.)
</p><p>
example:
</p><pre class="screen">   IFIELD LAT_INT32DEG,"","%ld"
</pre></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="style_def_lonint32"></a>LON_INT32DEG</h3></div></div></div><p>
   See LON_INT32DEG except LON_INT32DEG defines LONGITUDE.
</p></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="style_def_latdirdec"></a>LAT_DECIMALDIR / LAT_DIRDECIMAL</h3></div></div></div><p>
   LAT_DECIMALDIR and LAT_DIRDECIMAL  define LATITUDE in DECIMAL format 
   with the added bonus of a 'N/S' or 'E/W' direction character.  This data 
   is handled internally as a DOUBLE PRECISION FLOAT and a single 
   CHARACTER and requires a FLOATING POINT as well as a CHARACTER printf 
   conversion.  The only difference between the two is whether the directional
   character appears before (LAT_DIRDECIMAL) or after (LAT_DECIMALDIR) the
   decimal number.
</p><p>
examples:
</p><pre class="screen">   IFIELD LAT_DECIMALDIR,"","%f %c"     #  (writes 31.333 N)
   IFIELD LAT_DIRDECIMAL,"","%c %f"     #  (writes N 31.333)
</pre></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="style_def_londirdec"></a>LON_DECIMALDIR / LON_DIRDECIMAL</h3></div></div></div><p>
   Same as LAT_DECIMALDIR / LAT_DIRDECIMAL except LON_ defines LONGITUDE.
</p></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="style_def_latlondir"></a>LAT_DIR / LON_DIR</h3></div></div></div><p>
   LAT_DIR returns the single character 'N' or 'S' depending on the 
   hemisphere of the latitude.  LON_DIR returns 'E' or 'W' depending on
   the hemisphere of the longitude.
</p></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="style_def_lathuman"></a>LAT_HUMAN_READABLE</h3></div></div></div><p>
   LAT_HUMAN_READABLE defines LATITUDE in a human-readable format.  This 
   format is probably the most expressive format.  It is similar to 
   LAT_DECIMALDIR in that it requires multiple printf conversions, but it
   is far more flexible as to the contents of those conversions.  On read,
   the printf conversions are ignored and GPSBabel attempts to determine the
   latitude and longitude based on what is in the file.
</p><p>
examples:
</p><pre class="screen">
   #  (writes N 31 40.000)
   IFIELD LAT_HUMAN_READABLE,"","%c %d %f"   
   #  (writes "31 deg 40.000 min N")
   IFIELD LAT_HUMAN_READABLE,"","%d deg %f min %c"
   #  Note that this string will confuse the reading routine due 
   #  to the letter "n" in "min" and the letter "e" in "deg."
   # (writes 31 40 00.000N)
   IFIELD LAT_HUMAN_READABLE,"","%d %d %f%c" 
</pre></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="style_def_map_en_bng"></a>MAP_EN_BNG</h3></div></div></div><p>
   MAP_EN_BNG converts coordinates from/to British National Grid (BNG).
</p><p>
   The only supported order of the items is: Map,Easting,Northing.
   During output all coordinates have to be located within this limited area.
</p><p>
examples:
</p><pre class="screen">
   IFIELD MAP_EN_BNG,"","%s%5d %5d"   #  (writes i.e. "SJ00001 00001")
   IFIELD MAP_EN_BNG,"","%s %d %d"    #  (writes i.e. "TQ 888 999")
</pre></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="style_def_lonhuman"></a>LON_HUMAN_READABLE</h3></div></div></div><p>
   See LAT_HUMAN_READABLE except LON_HUMAN_READABLE defines LONGITUDE.
</p></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="style_def_latlonhuman"></a>LATLON_HUMAN_READABLE</h3></div></div></div><p>
   LATLON_HUMAN_READABLE is like LAT_HUMAN_READABLE and LON_HUMAN_READABLE
   except that it reads and writes both latitude and longitude as a single 
   field.  On write, the same format specifier is used for both coordinates.
   On read, GPSBabel does exactly the same thing it does for 
   LAT_HUMAN_READABLE or LON_HUMAN_READABLE.
</p><p>
example:
</p><pre class="screen">   IFIELD LATLON_HUMAN_READABLE,"","%c %d %f"
           # (writes "N 31 40.126 W 85 09.62" as a single field)
</pre></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="style_def_latnmea"></a>LAT_NMEA</h3></div></div></div><p>
   Defines the latitude in the format used by the NMEA standard which is
   degrees multiplied by 100 plus decimal minutes.
</p><p>
example:
</p><pre class="screen">   IFIELD  LAT_NMEA, "%f", "%08.3f"     # (writes  3558.322)
</pre></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="style_def_latddmmdir"></a>LAT_DDMMDIR</h3></div></div></div><p>
Derived from the LAT_NMEA latitude format, with degrees * 100 plus decimal 
minutes, but using an additional specifier to position the  'N' or 'S' instead of a leading minus sign (or 
absence thereof) to give direction from zero.
</p><p>
</p><pre class="screen"> IFIELD LAT_DDMMDIR, "%f", "%08.3f%c" # (writes "5334.192S" giving -53.56987 degrees latitude)
</pre><p>
</p></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="style_def_lonnmea"></a>LON_NMEA</h3></div></div></div><p>
   Defines the longitude in the format used by the NMEA standard which is
   degrees multiplied by 100 plus decimal minutes.
</p><p>
Example:
</p><pre class="screen">   IFIELD  LON_NMEA, "%f", "%010.3f"  # (writes -08708.082)
</pre></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="style_def_londdmmdir"></a>LON_DDMMDIR</h3></div></div></div><p>
Derived from the LON_NMEA longitude format, with degrees * 100 plus decimal minutes, but using an additional character format character to position the
'E' or 'W' instead of a leading minus sign (or absence thereof) to give direction from zero.
</p><p>
Example:
</p><pre class="screen"> IFIELD LON_DDMMDIR, "%f", "%010.3f%c" # (writes "01232.745W" giving -12.54575 degrees
longitude)
</pre></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="style_def_latlon_10ex"></a>LAT_10EX / LON_10EX</h3></div></div></div><p>
   Defines the latitude or longitude in the format used i.e. by TomTom Navigator
   itinerary files. It is degrees multiplied by 10 power X. X have to be replaced with
   a valid decimal value. A factor of 10000 would be generated by LAT_10E5 as shown
   in the examples below.
</p><p>
examples:
</p><pre class="screen">   IFIELD  LAT_10E5, "%f", "%.f"       # (writes  3558322)
</pre><pre class="screen">   IFIELD  LON_10E5, "%f", "%.f"       # (writes -8708082)
</pre></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="style_def_utm"></a>UTM</h3></div></div></div><p>A location in UTM has several components: a zone, a northing, and an easting.   The UTM format specifier is the most common representation of these.
</p><p>example: </p><pre class="screen">
IFIELD UTM, "", "%s" # writes 6S 519045 3984035  -the easting is first by convention.</pre></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="style_def_utm_easting"></a>UTM_EASTING</h3></div></div></div><p>This is the decimal component representing the easting
</p><p>example: </p><pre class="screen">
IFIELD UTM_EASTING, "", "%.0f"  # outputs 519045
</pre></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="style_def_utm_northing"></a>UTM_NORTHING</h3></div></div></div><p>
This is the decimal component representing the northing
</p><p>example: </p><pre class="screen">
IFIELD UTM_NORTHING "", "%.0f"  # outputs 3984035
</pre></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="style_def_utm_zone"></a>UTM_ZONE</h3></div></div></div><p>The UTM zone.
</p><p>example: </p><pre class="screen">
IFIELD UTM_ZONE "", "%d"  # outputs 6
</pre></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="style_def_utm_zonec"></a>UTM_ZONEC</h3></div></div></div><p>
The UTM Zone character.
</p><p>example: </p><pre class="screen">
IFIELD UTM_ZONEC "", "%c"  # outputs S
</pre></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="style_def_utm_zonef"></a></h3></div></div></div><p>
The full UTM zone and latitude band.
</p><p>example: </p><pre class="screen">
IFIELD UTM_ZONEF "", "%d%c"  # outputs 6S
</pre></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="style_def_altfeet"></a>ALT_FEET</h3></div></div></div><p>
   ALT_FEET is the position's ALTITUDE in FEET.  This value is treated as 
   a SIGNED DOUBLE PRECISION FLOAT and requires a FLOATING POINT printf 
   conversion.
</p><p>
example:
</p><pre class="screen">   IFIELD ALT_FEET,"","%.0f"
</pre></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="style_def_altmeters"></a>ALT_METERS</h3></div></div></div><p>
   ALT_METERS is identical to ALT_FEET with the exception that the altitude
   is in METERS.
</p></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="style_def_heartrate"></a>HEART_RATE</h3></div></div></div><p>
   Heart rate, measured in beats per minute.  Only valid for units with 
   heart rate monitor features (i.e. Garmin Forerunner 301).
</p><p>
example:
</p><pre class="screen">   IFIELD HEART_RATE,"","%d"
</pre></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="style_def_cadence"></a>CADENCE</h3></div></div></div><p>
   Cadence in revolutions per minute.  Only valid for units with 
   heart rate monitor features (i.e. Garmin Edge 305).
</p><p>
example:
</p><pre class="screen">   IFIELD CADENCE,"","%d"
</pre></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="style_def_power"></a>POWER</h3></div></div></div><p>
   Cycling power in Watts.  Only valid for units with power meter
   features (i.e. Garmin Edge 305).
</p><p>
example:
</p><pre class="screen">   IFIELD POWER,"","%.1f"
</pre></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="style_def_temperature"></a>TEMPERATURE</h3></div></div></div><p>
   Temperature in degrees Celsius.
</p><p>
example:
</p><pre class="screen">   IFIELD TEMPERATURE,"","%.1f"
</pre></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="style_def_temperaturef"></a>TEMPERATURE_F</h3></div></div></div><p>
   Temperature in degrees Fahrenheit.
</p><p>
example:
</p><pre class="screen">   IFIELD TEMPERATURE_F,"","%.1f"
</pre></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="style_def_exceltime"></a>EXCEL_TIME</h3></div></div></div><p>
   EXCEL_TIME is the waypoint's creation time, if any.  This is actually
   the decimal days since 1/1/1900 and is handled internally as a DOUBLE
   PRECISION FLOAT and requires a FLOATING POINT printf conversion.
</p><p>
example:
</p><pre class="screen">   IFIELD EXCEL_TIME,"","%11.5f"
</pre></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="style_def_timettime"></a>TIMET_TIME</h3></div></div></div><p>
   TIMET_TIME is the waypoint's creation time, if any.  This is actually
   the integer seconds since 1/1/1970 (let's not start the holy war) and
   is handled internally as a LONG INTEGER and requires a LONG INTEGER
   printf conversion.
</p><p>
example:
</p><pre class="screen">   IFIELD TIMET_TIME,"","%ld"
</pre></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="style_def_timettimems"></a>TIMET_TIME_MS</h3></div></div></div><p>
   TIMET_TIME_MS is the same as TIMET_TIME, but expressed in milliseconds.
   It too is handled internally as a LONG INTEGER and requires a LONG INTEGER
   printf conversion.
</p><p>
example:
</p><pre class="screen">   IFIELD TIMET_TIME_MS,"","%ld"
</pre></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="style_def_yyyymmdd"></a>YYYYMMDD_TIME</h3></div></div></div><p>
   YYYYMMDD_TIME is the waypoint's creation time, if any.  It's a single
   decimal field containing four digits of year, two digits of month, 
   and two digits of date.   Internally it is a LONG INTEGER and thus
   requires a LONG INTEGER printf conversion.
</p><p>
example:
</p><pre class="screen">   IFIELD YYYYMMDD_TIME,"","%ld"
</pre></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="style_def_gmttime"></a>GMT_TIME</h3></div></div></div><p>
   GMT_TIME is the waypoint's creation time, in UTC time zone.  It uses the
   strptime conversion format tags.  
</p><p>
example:
</p><pre class="screen">   IFIELD GMT_TIME,"","%m/%d/%Y %I:%M:%D %p"
</pre><p>
   Search the web for 'strptime man page' for details strptime, but one 
   such page can be found at
<a class="ulink" href="http://www.die.net/doc/linux/man/man3/strptime.3.html" target="_top">http://www.die.net/doc/linux/man/man3/strptime.3.html</a>
</p></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="style_def_localtime"></a>LOCAL_TIME</h3></div></div></div><p>
 LOCAL_TIME is the waypoint's creation time, in the local
 time zone.  It uses strptime conversion format tags.  See GMT_TIME for a
 reference.
</p><p>
example:
</p><pre class="screen">   IFIELD LOCAL_TIME,"","%y-%m-%d"
</pre></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="style_def_hmsgtime"></a>HMSG_TIME</h3></div></div></div><p>
   HMSG_TIME parses up to three time parts and am/pm string to add
   this value to the previously parsed *_TIME field that contains 
   only a date.  On output, will print the time in UTC.
</p><p>
example:
</p><pre class="screen">   IFIELD HMSG_TIME,"","%d:%d:%d %s"
</pre></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="style_def_hmsltime"></a>HMSL_TIME</h3></div></div></div><p>
   HMSG_TIME parses up to three time parts and am/pm string to add
   this value to the previously parsed *_TIME field that contains 
   only a date.  On output, will print the time in local time.
</p><p>
example:
</p><pre class="screen">   IFIELD HMSL_TIME,"","%dh%dm"
</pre></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="style_def_isotime"></a>ISO_TIME</h3></div></div></div><p>
   ISO_TIME is the waypoint's creation time, in ISO 8601 format, 
   which include time zone information. 
   It is expected to be in the format yyyy-mm-ddThh:mm:sszzzzz
   where zzzzzz is the local time offset or the character Z
   for UTC time.
   On output, UTC 'Z' time zone will always be used.
</p><p>
example:
</p><pre class="screen">   IFIELD ISO_TIME,"","%s"
</pre></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="style_def_isotimems"></a>ISO_TIME_MS</h3></div></div></div><p>
   ISO_TIME_MS is much like ISO_TIME, but expresses milliseconds at the
   end of the timestamp.
   It is thus in the format yyyy-mm-ddThh:mm:ss.SSSzzzzz
   where 'SSS' is milliseconds and zzzzzz is the local time offset 
   or the character Z for UTC time.
   On output, UTC 'Z' time zone will always be used.
</p><p>
example:
</p><pre class="screen">   IFIELD ISO_TIME_MS,"","%s"
</pre></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="style_def_nettime"></a>NET_TIME</h3></div></div></div><p>
  Microsoft dot net represents times in 100 nanoscond intervals since midnight
  Jan 1/0001 GMT, giving absurdly large numbers like 633943150010000000 for 
  mid-November, 2009.  NET_TIME is how to represent those in GPSBabel.
</p><p>
example:
</p><pre class="screen">   IFIELD NET_TIME,"","%f"
</pre></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="style_def_geodiff"></a>GEOCACHE_DIFF</h3></div></div></div><p>
   GEOCACHE_DIFF is valid only for geocaches and represents a DOUBLE 
   PRECISION FLOAT.  This is the geocache "difficulty" rating as defined by
   Groundspeak.  A "three and a half star" cache would therefore be "3.5"
</p><p>
example:
</p><pre class="screen">   IFIELD GEOCACHE_DIFF,"","%3.1f"
</pre></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="style_def_geoterr"></a>GEOCACHE_TERR</h3></div></div></div><p>
   GEOCACHE_TERR is valid only for geocaches and represents a DOUBLE 
   PRECISION FLOAT.  This is the geocache "terrain" rating as defined
   by Groundspeak.  A "three and a half star" cache would therefore be "3.5"
</p><p>
example:
</p><pre class="screen">   IFIELD GEOCACHE_TERR,"","%3.1f"
</pre></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="style_def_geocontainer"></a>GEOCACHE_CONTAINER</h3></div></div></div><p>
   GEOCACHE_CONTAINER is valid only for geocaches and is heavily influenced
   by the Groundspeak container types.   Examples would include "Micro" 
   and "Virtual".
</p><p>
example:
</p><pre class="screen">   GEOCACHE_CONTAINER,"","%s"
</pre></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="style_def_geotype"></a>GEOCACHE_TYPE</h3></div></div></div><p>
   GEOCACHE_TYPE is valid only for geocaches and is heavily influenced
   by the Groundspeak cache types.   Examples would include "Event cache" 
   and "Multi-Cache".
</p><p>
example:
</p><pre class="screen">   GEOCACHE_TYPE,"","%s"
</pre></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="style_def_geoplacer"></a>GEOCACHE_PLACER</h3></div></div></div><p>
   GEOCACHE_PLACER is a string containing the name of the placer of a 
   geocache.   
</p><p>
example:
</p><pre class="screen">   GEOCACHE_PLACER,"","%s"
</pre></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="style_def_isavailable"></a>GEOCACHE_ISAVAILABLE</h3></div></div></div><p>
   GEOCACHE_ISAVAILABLE is a string containing "True" or "False" 
   indicating whether a geocache is currently available or not.  
</p><p>
example:
</p><pre class="screen">   GEOCACHE_ISAVAILABLE,"","%s"
</pre></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="style_def_isarchived"></a>GEOCACHE_ISARCHIVED</h3></div></div></div><p>
   GEOCACHE_ISARCHIVED is a string containing "True" or "False" 
   indicating whether a geocache has been archived.   
</p><p>
example:
</p><pre class="screen">   GEOCACHE_ISARCHIVED,"","%s"
</pre></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="style_def_geofound"></a>GEOCACHE_LAST_FOUND</h3></div></div></div><p>
   A long integer in format YYYYMMDD containing the last time this geocache
   was found.
</p><p>
example:
</p><pre class="screen">   GEOCACHE_LAST_FOUND,"","%ld"
</pre></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="style_def_geohint"></a>GEOCACHE_HINT</h3></div></div></div><p>
   The hint for this geocache.   No additional transformation (such as rot13)
   will be performed on this string.
</p><p>
example:
</p><pre class="screen">   GEOCACHE_HINT,"","%s"
</pre></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="style_def_pathdistmi"></a>PATH_DISTANCE_MILES</h3></div></div></div><p>
   PATH_DISTANCE_MILES outputs the total length of the route or track from
   the start point to the current point, in miles.  This and the altitude
   could be used to create an elevation profile.  PATH_DISTANCE_MILES is
   a DOUBLE PRECISION FLOAT.
</p><p>
   PATH_DISTANCE_MILES is not valid as an input field.
</p><p>
   PATH_DISTANCE_MILES is only meaningful if the data comes from a track
   or a route; waypoint data will generate essentially meaningless output.
</p><p>
example:
</p><pre class="screen">   PATH_DISTANCE_MILES,"","%f"
</pre></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="style_def_pathdistkm"></a>PATH_DISTANCE_KM</h3></div></div></div><p>
   PATH_DISTANCE_KM is like PATH_DISTANCE_MILES except it outputs the 
   length in kilometers. 
</p></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="style_def_pathdistm"></a>PATH_DISTANCE_METERS</h3></div></div></div><p>
   PATH_DISTANCE_METERS is like PATH_DISTANCE_MILES except it outputs the 
   length in meters. 
</p></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="style_def_pathspeed"></a>PATH_SPEED</h3></div></div></div><p>
   Speed in meters per second. Gpsbabel does NOT calculate this data by 
   default; it is read from the input file if present.  (If not present,
   it may be calculated with the <a class="link" href="filter_track.html" title="Manipulate track lists (track)">track</a>
   filter.)
</p><p>
example:
</p><pre class="screen">   PATH_SPEED,"","%f"
</pre></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="style_def_pathspeed_kph"></a>PATH_SPEED_KPH</h3></div></div></div><p>
   Like PATH_SPEED but means kilometers per hour.
</p><p>
example:
</p><pre class="screen">   PATH_SPEED_KPH,"","%.1f"
</pre></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="style_def_pathspeed_mph"></a>PATH_SPEED_MPH</h3></div></div></div><p>
   Like PATH_SPEED but means miles per hour.
</p><p>
example:
</p><pre class="screen">   PATH_SPEED_MPH,"","%.1f"
</pre></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="style_def_pathspeed_knots"></a>PATH_SPEED_KNOTS</h3></div></div></div><p>
   Like PATH_SPEED but means knots (nautical).
</p><p>
example:
</p><pre class="screen">   PATH_SPEED_KNOTS,"","%.1f"
</pre></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="style_def_pathcourse"></a>PATH_COURSE</h3></div></div></div><p>
   Course in degrees.  Gpsbabel does not calculate this data by default; 
   it is read from the input file if present.  (If not present, it may be
   calculated with the <a class="link" href="filter_track.html" title="Manipulate track lists (track)">track</a> filter.)
</p><p>
example:
</p><pre class="screen">   PATH_COURSE,"","%f"
</pre></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="style_def_dop"></a>GPS_HDOP / GPS_VDOP / GPS_PDOP</h3></div></div></div><p>
   GPS horizontal / vertical / positional dilution of precision 
   parameters. Needs float conversion.
</p><p>
example:
</p><pre class="screen">   GPS_HDOP,"","%f"
</pre></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="style_def_gpssat"></a>GPS_SAT</h3></div></div></div><p>
   Number of satellites used for determination of the position. Needs
   integer conversion.
</p><p>
example:
</p><pre class="screen">   GPS_SAT,"","%d"
</pre></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="style_def_gpsfix"></a>GPS_FIX</h3></div></div></div><p>
   Type of fix (see GPX spec or <a class="link" href="filter_track.html" title="Manipulate track lists (track)">track</a>
filter). Needs string conversion.
</p><p>
example:
</p><pre class="screen">   GPS_FIX,"","%s"
</pre></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="style_track_new"></a>TRACK_NEW</h3></div></div></div><p>If '1', it indicates that this trackpoint is the first point of a new track.  Needs integer conversion.</p><p>example:</p><pre class="screen">IFIELD TRACK_NEW,"","%d"</pre></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="style_track_name"></a>TRACK_NAME</h3></div></div></div><p>The name of the track currently being operated on.  Needs string conversion.</p><p>example:</p><pre class="screen">TRACK_NAME, "", "%s"</pre></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="style_route_name"></a>ROUTE_NAME</h3></div></div></div><p>The name of the route currently being operated on.  Needs string conversion.</p><p>example:</p><pre class="screen">ROUTE_NAME, "", "%s"</pre></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="style_street_addr"></a>STREET_ADDR</h3></div></div></div><p>Street address including house number.  Notice that this is not used for any geocoding, it's merely textual description associated with a position.</p><p>example:</p><pre class="screen">STREET_ADDR, "", "%s"</pre></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="style_city"></a>CITY</h3></div></div></div><p>The name of a city. Sometimes part of "Points of Interest".   This is simple textual data associated with a position, no geocoding will be done..</p><p>example:</p><pre class="screen">CITY, "", "%s"</pre></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="style_country"></a>COUNTRY</h3></div></div></div><p>The name of a country associated with a position.</p><p>example:</p><pre class="screen">COUNTRY, "", "%s"</pre></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="style_facility"></a>FACILITY</h3></div></div></div><p>The name of a facility to associate with a position.</p><p>example:</p><pre class="screen">FACILITY, "", "%s"</pre></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="style_phone_nr"></a>PHONE_NR</h3></div></div></div><p>A phone number associated with a position.  This is just textual data attached for convenience.</p><p>example:</p><pre class="screen">PHONE_NR, "", "%s"</pre></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="style_postal_code"></a>POSTAL_CODE</h3></div></div></div><p>A postal code to associate with a position.  It is freeform text and is not used by GPSBabel for any geocoding or such.</p><p>example:</p><pre class="screen">POSTAL_CODE, "", "%s"</pre></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="style_filename"></a>FILENAME</h3></div></div></div><p>The name of the input file from where the points were loaded. This field is available only on output.</p><p>example:</p><pre class="screen">OFIELD FILENAME, "", "%s"</pre></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="style_format"></a>FORMAT</h3></div></div></div><p>The name of the input format from where format the points came. This field is available only on output.</p><p>example:</p><pre class="screen">OFIELD FORMAT, "", "%s"</pre></div></div><div xmlns="http://www.w3.org/1999/xhtml" class="navfooter"><hr /><table width="100%" summary="Navigation footer"><tr><td width="40%" align="left"><a accesskey="p" href="style_layout.html">Prev</a> </td><td width="20%" align="center"><a accesskey="u" href="Styles.html">Up</a></td><td width="40%" align="right"> <a accesskey="n" href="style_examples.html">Next</a></td></tr><tr><td width="40%" align="left" valign="top">Defining the Layout of the File </td><td width="20%" align="center"><a accesskey="h" href="index.html">Home</a></td><td width="40%" align="right" valign="top"> Examples</td></tr></table></div>
  
      {/literal}{/block}
  