/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.nativeplatform.tasks;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedSet;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.apache.commons.io.IOUtils;
import org.gradle.api.DefaultTask;
import org.gradle.api.Incubating;
import org.gradle.api.NonNullApi;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.internal.changedetection.changes.IncrementalTaskInputsInternal;
import org.gradle.api.internal.file.collections.DirectoryFileTreeFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.incremental.IncrementalTaskInputs;
import org.gradle.cache.PersistentStateCache;
import org.gradle.internal.hash.FileHasher;
import org.gradle.language.nativeplatform.internal.incremental.CompilationState;
import org.gradle.language.nativeplatform.internal.incremental.CompilationStateCacheFactory;
import org.gradle.language.nativeplatform.internal.incremental.DefaultHeaderDependenciesCollector;
import org.gradle.language.nativeplatform.internal.incremental.DefaultSourceIncludesParser;
import org.gradle.language.nativeplatform.internal.incremental.DefaultSourceIncludesResolver;
import org.gradle.language.nativeplatform.internal.incremental.HeaderDependenciesCollector;
import org.gradle.language.nativeplatform.internal.incremental.IncrementalCompilation;
import org.gradle.language.nativeplatform.internal.incremental.IncrementalCompileFilesFactory;
import org.gradle.language.nativeplatform.internal.incremental.IncrementalCompileProcessor;
import org.gradle.language.nativeplatform.internal.incremental.sourceparser.CSourceParser;
import org.gradle.language.nativeplatform.internal.incremental.sourceparser.RegexBackedCSourceParser;

@NonNullApi
@Incubating
public class Depend
extends DefaultTask {
    private final ConfigurableFileCollection includes;
    private final ConfigurableFileCollection source;
    private final HeaderDependenciesCollector headerDependenciesCollector;
    private ImmutableList<String> includePaths;
    private Property<Boolean> importsAreIncludes;
    private final RegularFileProperty headerDependenciesFile;
    private CSourceParser sourceParser;
    private final FileHasher hasher;
    private final CompilationStateCacheFactory compilationStateCacheFactory;

    @Inject
    public Depend(FileHasher hasher, CompilationStateCacheFactory compilationStateCacheFactory, DirectoryFileTreeFactory directoryFileTreeFactory) {
        this.hasher = hasher;
        this.compilationStateCacheFactory = compilationStateCacheFactory;
        this.includes = this.getProject().files(new Object[0]);
        this.source = this.getProject().files(new Object[0]);
        this.sourceParser = new RegexBackedCSourceParser();
        this.headerDependenciesFile = this.newOutputFile();
        this.importsAreIncludes = this.getProject().getObjects().property(Boolean.class);
        this.headerDependenciesCollector = new DefaultHeaderDependenciesCollector(directoryFileTreeFactory);
        this.dependsOn(new Object[]{this.includes});
    }

    @TaskAction
    public void detectHeaders(IncrementalTaskInputs incrementalTaskInputs) throws IOException {
        IncrementalTaskInputsInternal inputs = (IncrementalTaskInputsInternal)incrementalTaskInputs;
        ImmutableList includeRoots = ImmutableList.copyOf((Iterable)this.includes);
        IncrementalCompileProcessor incrementalCompileProcessor = this.createIncrementalCompileProcessor((List<File>)includeRoots);
        IncrementalCompilation incrementalCompilation = incrementalCompileProcessor.processSourceFiles(this.source.getFiles());
        ImmutableSortedSet<File> headerDependencies = this.headerDependenciesCollector.collectHeaderDependencies(this.getName(), (List<File>)includeRoots, incrementalCompilation);
        inputs.newInputs(headerDependencies);
        this.writeHeaderDependenciesFile(headerDependencies);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeHeaderDependenciesFile(ImmutableSortedSet<File> headerDependencies) throws IOException {
        File outputFile = (File)this.getHeaderDependenciesFile().getAsFile().get();
        BufferedWriter outputStreamWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), Charsets.UTF_8));
        try {
            for (File header : headerDependencies) {
                outputStreamWriter.write(header.getAbsolutePath());
                outputStreamWriter.newLine();
            }
        }
        finally {
            IOUtils.closeQuietly((Writer)outputStreamWriter);
        }
    }

    private IncrementalCompileProcessor createIncrementalCompileProcessor(List<File> includeRoots) {
        PersistentStateCache<CompilationState> compileStateCache = this.compilationStateCacheFactory.create(this.getPath());
        DefaultSourceIncludesParser sourceIncludesParser = new DefaultSourceIncludesParser(this.sourceParser, (Boolean)this.importsAreIncludes.getOrElse((Object)false));
        DefaultSourceIncludesResolver dependencyParser = new DefaultSourceIncludesResolver(includeRoots);
        IncrementalCompileFilesFactory incrementalCompileFilesFactory = new IncrementalCompileFilesFactory(sourceIncludesParser, dependencyParser, this.hasher);
        return new IncrementalCompileProcessor(compileStateCache, incrementalCompileFilesFactory);
    }

    @Input
    protected Collection<String> getIncludePaths() {
        if (this.includePaths == null) {
            Set roots = this.includes.getFiles();
            ImmutableList.Builder builder = ImmutableList.builder();
            for (File root : roots) {
                builder.add((Object)root.getAbsolutePath());
            }
            this.includePaths = builder.build();
        }
        return this.includePaths;
    }

    public void includes(Object includeRoots) {
        this.includes.from(new Object[]{includeRoots});
    }

    @InputFiles
    @SkipWhenEmpty
    public ConfigurableFileCollection getSource() {
        return this.source;
    }

    public void source(Object sourceFiles) {
        this.source.from(new Object[]{sourceFiles});
    }

    @OutputFile
    public RegularFileProperty getHeaderDependenciesFile() {
        return this.headerDependenciesFile;
    }

    @Input
    public Property<Boolean> getImportsAreIncludes() {
        return this.importsAreIncludes;
    }
}

