/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.TreeMap;
import java.util.TreeSet;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.AttributeValue;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.internal.Cast;
import org.gradle.internal.component.model.AttributeMatcher;
import org.gradle.internal.component.model.ComponentResolveMetadata;
import org.gradle.internal.component.model.ConfigurationMetadata;
import org.gradle.internal.text.TreeFormatter;

public class AmbiguousConfigurationSelectionException
extends RuntimeException {
    private static final Function<ConfigurationMetadata, String> CONFIG_NAME = new Function<ConfigurationMetadata, String>(){

        public String apply(ConfigurationMetadata input) {
            return input.getName();
        }
    };

    public AmbiguousConfigurationSelectionException(AttributeContainerInternal fromConfigurationAttributes, AttributeMatcher attributeMatcher, List<? extends ConfigurationMetadata> matches, ComponentResolveMetadata targetComponent) {
        super(AmbiguousConfigurationSelectionException.generateMessage(fromConfigurationAttributes, attributeMatcher, matches, targetComponent));
    }

    private static String generateMessage(AttributeContainerInternal fromConfigurationAttributes, AttributeMatcher attributeMatcher, List<? extends ConfigurationMetadata> matches, ComponentResolveMetadata targetComponent) {
        TreeSet ambiguousConfigurations = Sets.newTreeSet((Iterable)Lists.transform(matches, CONFIG_NAME));
        TreeFormatter formatter = new TreeFormatter();
        formatter.node("Cannot choose between the following configurations of ");
        formatter.append((CharSequence)targetComponent.getComponentId().getDisplayName());
        formatter.startChildren();
        for (String configuration : ambiguousConfigurations) {
            formatter.node(configuration);
        }
        formatter.endChildren();
        formatter.node("All of them match the consumer attributes");
        formatter.startChildren();
        for (String ambiguousConf : ambiguousConfigurations) {
            AmbiguousConfigurationSelectionException.formatConfiguration(formatter, fromConfigurationAttributes, attributeMatcher, matches, ambiguousConf);
        }
        formatter.endChildren();
        return formatter.toString();
    }

    static void formatConfiguration(TreeFormatter formatter, AttributeContainerInternal consumerAttributes, AttributeMatcher attributeMatcher, List<? extends ConfigurationMetadata> matches, final String conf) {
        Optional match = Iterables.tryFind(matches, (Predicate)new Predicate<ConfigurationMetadata>(){

            public boolean apply(ConfigurationMetadata input) {
                return conf.equals(input.getName());
            }
        });
        if (match.isPresent()) {
            AttributeContainerInternal producerAttributes = ((ConfigurationMetadata)match.get()).getAttributes();
            formatter.node("Configuration '");
            formatter.append((CharSequence)conf);
            formatter.append((CharSequence)"'");
            AmbiguousConfigurationSelectionException.formatAttributeMatches(formatter, consumerAttributes, attributeMatcher, producerAttributes);
        }
    }

    public static void formatAttributeMatches(TreeFormatter formatter, AttributeContainerInternal consumerAttributes, AttributeMatcher attributeMatcher, AttributeContainerInternal producerAttributes) {
        TreeMap<String, Attribute> allAttributes = new TreeMap<String, Attribute>();
        for (Attribute attribute : producerAttributes.keySet()) {
            allAttributes.put(attribute.getName(), attribute);
        }
        for (Attribute attribute : consumerAttributes.keySet()) {
            allAttributes.put(attribute.getName(), attribute);
        }
        ImmutableAttributes immmutableConsumer = consumerAttributes.asImmutable();
        ImmutableAttributes immutableProducer = producerAttributes.asImmutable();
        formatter.startChildren();
        for (Attribute attribute : allAttributes.values()) {
            Attribute untyped = (Attribute)Cast.uncheckedCast((Object)attribute);
            String attributeName = attribute.getName();
            AttributeValue consumerValue = immmutableConsumer.findEntry(untyped);
            AttributeValue producerValue = immutableProducer.findEntry(attribute.getName());
            if (consumerValue.isPresent() && producerValue.isPresent()) {
                if (attributeMatcher.isMatching(untyped, producerValue.get(), consumerValue.get())) {
                    formatter.node("Required " + attributeName + " '" + consumerValue.get() + "' and found compatible value '" + producerValue.get() + "'.");
                    continue;
                }
                formatter.node("Required " + attributeName + " '" + consumerValue.get() + "' and found incompatible value '" + producerValue.get() + "'.");
                continue;
            }
            if (consumerValue.isPresent()) {
                formatter.node("Required " + attributeName + " '" + consumerValue.get() + "' but no value provided.");
                continue;
            }
            formatter.node("Found " + attributeName + " '" + producerValue.get() + "' but wasn't required.");
        }
        formatter.endChildren();
    }
}

