/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.actor.internal;

import java.util.IdentityHashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import org.gradle.internal.actor.Actor;
import org.gradle.internal.actor.ActorFactory;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.concurrent.ExecutorFactory;
import org.gradle.internal.concurrent.ManagedExecutor;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.concurrent.ThreadSafe;
import org.gradle.internal.dispatch.AsyncDispatch;
import org.gradle.internal.dispatch.Dispatch;
import org.gradle.internal.dispatch.DispatchException;
import org.gradle.internal.dispatch.ExceptionTrackingFailureHandler;
import org.gradle.internal.dispatch.FailureHandlingDispatch;
import org.gradle.internal.dispatch.MethodInvocation;
import org.gradle.internal.dispatch.ProxyDispatchAdapter;
import org.gradle.internal.dispatch.ReflectionDispatch;
import org.slf4j.LoggerFactory;

public class DefaultActorFactory
implements ActorFactory,
Stoppable {
    private final Map<Object, NonBlockingActor> nonBlockingActors = new IdentityHashMap<Object, NonBlockingActor>();
    private final Map<Object, BlockingActor> blockingActors = new IdentityHashMap<Object, BlockingActor>();
    private final Object lock = new Object();
    private final ExecutorFactory executorFactory;

    public DefaultActorFactory(ExecutorFactory executorFactory) {
        this.executorFactory = executorFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.lock;
        synchronized (object) {
            try {
                CompositeStoppable.stoppable(this.nonBlockingActors.values()).add(this.blockingActors.values()).stop();
            }
            finally {
                this.nonBlockingActors.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Actor createActor(Object target) {
        if (target instanceof NonBlockingActor) {
            return (NonBlockingActor)target;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.blockingActors.containsKey(target)) {
                throw new UnsupportedOperationException("Cannot create a non-blocking and blocking actor for the same object. This is not implemented yet.");
            }
            NonBlockingActor actor = this.nonBlockingActors.get(target);
            if (actor == null) {
                actor = new NonBlockingActor(target);
                this.nonBlockingActors.put(target, actor);
            }
            return actor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Actor createBlockingActor(Object target) {
        Object object = this.lock;
        synchronized (object) {
            if (this.nonBlockingActors.containsKey(target)) {
                throw new UnsupportedOperationException("Cannot create a non-blocking and blocking actor for the same object. This is not implemented yet.");
            }
            BlockingActor actor = this.blockingActors.get(target);
            if (actor == null) {
                actor = new BlockingActor(target);
                this.blockingActors.put(target, actor);
            }
            return actor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopped(NonBlockingActor actor) {
        Object object = this.lock;
        synchronized (object) {
            this.nonBlockingActors.values().remove(actor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopped(BlockingActor actor) {
        Object object = this.lock;
        synchronized (object) {
            this.blockingActors.values().remove(actor);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class NonBlockingActor
    implements Actor {
        private final Dispatch<MethodInvocation> dispatch;
        private final ManagedExecutor executor;
        private final ExceptionTrackingFailureHandler failureHandler;

        public NonBlockingActor(Object targetObject) {
            this.executor = DefaultActorFactory.this.executorFactory.create("Dispatch " + targetObject);
            this.failureHandler = new ExceptionTrackingFailureHandler(LoggerFactory.getLogger(NonBlockingActor.class));
            this.dispatch = new AsyncDispatch<Object>((Executor)this.executor, new FailureHandlingDispatch<Object>(new ReflectionDispatch(targetObject), this.failureHandler), Integer.MAX_VALUE);
        }

        @Override
        public <T> T getProxy(Class<T> type) {
            return new ProxyDispatchAdapter<T>(this, type, ThreadSafe.class).getSource();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void stop() {
            try {
                CompositeStoppable.stoppable((Object[])new Object[]{this.dispatch, this.executor, this.failureHandler}).stop();
            }
            finally {
                DefaultActorFactory.this.stopped(this);
            }
        }

        @Override
        public void dispatch(MethodInvocation message) {
            this.dispatch.dispatch(message);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BlockingActor
    implements Actor {
        private final Dispatch<MethodInvocation> dispatch;
        private final Object lock = new Object();
        private boolean stopped;

        public BlockingActor(Object target) {
            this.dispatch = new ReflectionDispatch(target);
        }

        @Override
        public <T> T getProxy(Class<T> type) {
            return new ProxyDispatchAdapter<T>(this, type, ThreadSafe.class).getSource();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void stop() throws DispatchException {
            Object object = this.lock;
            synchronized (object) {
                this.stopped = true;
            }
            DefaultActorFactory.this.stopped(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dispatch(MethodInvocation message) {
            Object object = this.lock;
            synchronized (object) {
                if (this.stopped) {
                    throw new IllegalStateException("This actor has been stopped.");
                }
                this.dispatch.dispatch(message);
            }
        }
    }
}

