/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.buildoption;

import java.util.Map;
import org.gradle.cli.CommandLineParser;
import org.gradle.cli.ParsedCommandLine;
import org.gradle.internal.buildoption.AbstractBuildOption;
import org.gradle.internal.buildoption.CommandLineOptionConfiguration;
import org.gradle.internal.buildoption.Origin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BooleanBuildOption<T>
extends AbstractBuildOption<T> {
    public BooleanBuildOption(String gradleProperty) {
        super(gradleProperty);
    }

    public BooleanBuildOption(String gradleProperty, CommandLineOptionConfiguration ... commandLineOptionConfigurations) {
        super(gradleProperty, commandLineOptionConfigurations);
    }

    @Override
    public void applyFromProperty(Map<String, String> properties, T settings) {
        String value = properties.get(this.gradleProperty);
        if (value != null) {
            this.applyTo(this.isTrue(properties.get(this.gradleProperty)), settings, Origin.forGradleProperty(this.gradleProperty));
        }
    }

    @Override
    public void configure(CommandLineParser parser) {
        for (CommandLineOptionConfiguration config : this.commandLineOptionConfigurations) {
            this.configureCommandLineOption(parser, new String[]{config.getLongOption()}, config.getDescription(), config.getDeprecationWarning(), config.isIncubating());
            String disabledOption = this.getDisabledCommandLineOption(config);
            this.configureCommandLineOption(parser, new String[]{disabledOption}, config.getDescription(), config.getDeprecationWarning(), config.isIncubating());
            parser.allowOneOf(new String[]{config.getLongOption(), disabledOption});
        }
    }

    @Override
    public void applyFromCommandLine(ParsedCommandLine options, T settings) {
        for (CommandLineOptionConfiguration config : this.commandLineOptionConfigurations) {
            if (options.hasOption(config.getLongOption())) {
                this.applyTo(true, settings, Origin.forCommandLine(config.getLongOption()));
            }
            if (!options.hasOption(this.getDisabledCommandLineOption(config))) continue;
            this.applyTo(false, settings, Origin.forCommandLine(this.getDisabledCommandLineOption(config)));
        }
    }

    private String getDisabledCommandLineOption(CommandLineOptionConfiguration config) {
        return "no-" + config.getLongOption();
    }

    private String getDisabledCommandLineDescription(CommandLineOptionConfiguration config) {
        return "Disables option --" + config.getLongOption() + ".";
    }

    public abstract void applyTo(boolean var1, T var2, Origin var3);
}

