/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.util;

import org.apache.xerces.xni.QName;

public class SymbolHash {
    protected int fTableSize = 101;
    protected Entry[] fBuckets;

    public SymbolHash() {
        this.fBuckets = new Entry[this.fTableSize];
    }

    public SymbolHash(int n) {
        this.fTableSize = n;
        this.fBuckets = new Entry[this.fTableSize];
    }

    public String put(String string, Object object) {
        int n = this.hash(string) % this.fTableSize;
        Entry entry = this.search(string, n);
        if (entry != null) {
            return entry.key;
        }
        this.fBuckets[n] = entry = new Entry(string, object, this.fBuckets[n]);
        return string;
    }

    public String put(QName qName, Object object) {
        int n;
        String string = qName.uri == null ? qName.localpart : qName.uri.concat(qName.localpart);
        Entry entry = this.search(string, n = this.hash(string) % this.fTableSize);
        if (entry != null) {
            return entry.key;
        }
        this.fBuckets[n] = entry = new Entry(string, object, this.fBuckets[n]);
        return entry.key;
    }

    public Object get(String string) {
        int n = this.hash(string) % this.fTableSize;
        Entry entry = this.search(string, n);
        if (entry != null) {
            return entry.value;
        }
        return null;
    }

    public void clear() {
        int n = 0;
        while (n < this.fTableSize) {
            this.fBuckets[n] = new Entry();
            ++n;
        }
    }

    public Object get(QName qName) {
        int n;
        String string = qName.uri.concat(qName.localpart);
        Entry entry = this.search(string, n = this.hash(string) % this.fTableSize);
        if (entry != null) {
            return entry.value;
        }
        return null;
    }

    protected Entry search(String string, int n) {
        int n2 = string.length();
        Entry entry = this.fBuckets[n];
        while (entry != null) {
            block4: {
                if (entry.characters != null && n2 == entry.characters.length) {
                    int n3 = 0;
                    while (n3 < n2) {
                        if (string.charAt(n3) == entry.characters[n3]) {
                            ++n3;
                            continue;
                        }
                        break block4;
                    }
                    return entry;
                }
            }
            entry = entry.next;
        }
        return null;
    }

    public int hash(String string) {
        int n = 0;
        int n2 = string.length();
        int n3 = 0;
        while (n3 < n2) {
            n = n * 37 + string.charAt(n3);
            ++n3;
        }
        return n & 0x7FFFFFF;
    }

    protected static final class Entry {
        public String key;
        public Object value;
        public char[] characters;
        public Entry next;

        public Entry() {
            this.key = null;
            this.value = null;
            this.characters = null;
            this.next = null;
        }

        public Entry(String string, Object object, Entry entry) {
            this.key = string;
            this.value = object;
            this.next = entry;
            this.characters = new char[string.length()];
            string.getChars(0, this.characters.length, this.characters, 0);
        }
    }
}

