/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.embed.variable;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.embed.internal.BiVariableMap;
import org.jruby.embed.variable.AbstractVariable;
import org.jruby.embed.variable.BiVariable;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.builtin.IRubyObject;

public class Constant
extends AbstractVariable {
    private static final String VALID_NAME = "[A-Z]([a-zA-Z]|_)([a-zA-Z]|_|\\d)*";

    public static BiVariable getInstance(RubyObject receiver2, String name2, Object ... javaObject) {
        if (name2.matches(VALID_NAME)) {
            return new Constant(receiver2, name2, javaObject);
        }
        return null;
    }

    private Constant(RubyObject receiver2, String name2, Object ... javaObjects) {
        super(receiver2, name2, false);
        this.updateByJavaObject(receiver2.getRuntime(), javaObjects);
    }

    Constant(RubyObject receiver2, String name2, IRubyObject irubyObject) {
        super(receiver2, name2, true, irubyObject);
    }

    public static void retrieve(RubyObject receiver2, BiVariableMap vars) {
        if (vars.isLazy()) {
            return;
        }
        Constant.updateConstantsOfSuperClass(receiver2, vars);
        Constant.updateConstants(receiver2, vars);
        Constant.updateConstants(Constant.getTopSelf(receiver2), vars);
    }

    private static void updateConstantsOfSuperClass(RubyObject receiver2, BiVariableMap vars) {
        Map<String, RubyModule.ConstantEntry> constantMap = Constant.getTopSelf(receiver2).getMetaClass().getSuperClass().getConstantMap();
        List<BiVariable> variables = vars.getVariables();
        for (BiVariable variable : variables) {
            if (variable.getType() != BiVariable.Type.Constant || !constantMap.containsKey(variable.getName())) continue;
            IRubyObject value2 = constantMap.get((Object)variable.getName()).value;
            variable.setRubyObject(value2);
        }
    }

    private static void updateConstants(RubyObject receiver2, BiVariableMap vars) {
        RubyClass klazz = receiver2.getMetaClass();
        Collection<String> constantNames = klazz.getConstantNames();
        for (String name2 : constantNames) {
            IRubyObject value2 = klazz.getConstant(name2);
            BiVariable var = vars.getVariable(receiver2, name2);
            if (var == null) {
                vars.update(name2, new Constant(receiver2, name2, value2));
                continue;
            }
            var.setRubyObject(value2);
        }
    }

    public static void retrieveByKey(RubyObject receiver2, BiVariableMap vars, String key2) {
        IRubyObject value2 = null;
        RubyClass klazz = receiver2.getMetaClass();
        if (klazz.getConstantNames().contains(key2)) {
            value2 = klazz.getConstant(key2);
        } else if (Constant.getTopSelf(receiver2).getMetaClass().getConstantNames().contains(key2)) {
            value2 = Constant.getTopSelf(receiver2).getMetaClass().getConstant(key2);
        } else if (Constant.getTopSelf(receiver2).getMetaClass().getSuperClass().getConstantNames().contains(key2)) {
            value2 = Constant.getTopSelf(receiver2).getMetaClass().getSuperClass().getConstant(key2);
        }
        if (value2 == null) {
            return;
        }
        BiVariable var = vars.getVariable(receiver2, key2);
        if (var != null) {
            var.setRubyObject(value2);
        } else {
            var = new Constant(receiver2, key2, value2);
            vars.update(key2, var);
        }
    }

    @Override
    public BiVariable.Type getType() {
        return BiVariable.Type.Constant;
    }

    public static boolean isValidName(Object name2) {
        return Constant.isValidName(VALID_NAME, name2);
    }

    @Override
    public void inject() {
        Ruby runtime = this.getRuntime();
        if (this.receiver == runtime.getTopSelf()) {
            RubyModule rubyModule = Constant.getRubyClass(runtime);
            if (rubyModule == null) {
                rubyModule = null;
            }
            if (rubyModule == null) {
                return;
            }
            rubyModule.storeConstant(this.name, this.irubyObject);
        } else {
            this.receiver.getMetaClass().storeConstant(this.name, this.irubyObject);
        }
        runtime.getConstantInvalidator(this.name).invalidate();
    }

    @Override
    public void remove() {
        Ruby runtime = this.getRuntime();
        IRubyObject rubyName = JavaUtil.convertJavaToRuby(runtime, this.name);
        RubyClass metaClass = this.receiver.getMetaClass();
        if (metaClass.getConstantNames().contains(this.name)) {
            metaClass.remove_const(runtime.getCurrentContext(), rubyName);
        } else if (this.getTopSelf().getMetaClass().getConstantNames().contains(this.name)) {
            this.getTopSelf().getMetaClass().remove_const(runtime.getCurrentContext(), rubyName);
        } else if (this.getTopSelf().getMetaClass().getSuperClass().getConstantNames().contains(this.name)) {
            this.getTopSelf().getMetaClass().getSuperClass().remove_const(runtime.getCurrentContext(), rubyName);
        }
    }
}

