'use strict';

exports.__esModule = true;
exports['default'] = createMemoryHistory;

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

var _historyLibUseQueries = require('history/lib/useQueries');

var _historyLibUseQueries2 = _interopRequireDefault(_historyLibUseQueries);

var _historyLibUseBasename = require('history/lib/useBasename');

var _historyLibUseBasename2 = _interopRequireDefault(_historyLibUseBasename);

var _historyLibCreateMemoryHistory = require('history/lib/createMemoryHistory');

var _historyLibCreateMemoryHistory2 = _interopRequireDefault(_historyLibCreateMemoryHistory);

function createMemoryHistory(options) {
  // signatures and type checking differ between `useRoutes` and
  // `createMemoryHistory`, have to create `memoryHistory` first because
  // `useQueries` doesn't understand the signature
  var memoryHistory = _historyLibCreateMemoryHistory2['default'](options);
  var createHistory = function createHistory() {
    return memoryHistory;
  };
  var history = _historyLibUseQueries2['default'](_historyLibUseBasename2['default'](createHistory))(options);
  history.__v2_compatible__ = true;
  return history;
}

module.exports = exports['default'];