/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.bridges;

import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.bridges.Bridge;
import org.jetbrains.kotlin.backend.common.bridges.BridgesKt;
import org.jetbrains.kotlin.backend.common.bridges.DescriptorBasedFunctionHandle;
import org.jetbrains.kotlin.backend.common.bridges.FunctionHandle;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.OverridingUtil;
import org.jetbrains.kotlin.resolve.calls.callResolverUtil.CallResolverUtilKt;

@Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=2, d1={"\u0000*\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\u001a\u0010\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0001\u001a\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0001\u001a\u0018\u0010\u0004\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0001\u001aH\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\t0\b0\u0007\"\u0004\b\u0000\u0010\t2\u0006\u0010\u0002\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u0002H\t0\f2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\f\u00a8\u0006\u0010"}, d2={"findImplementationFromInterface", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "descriptor", "findInterfaceImplementation", "firstSuperMethodFromKotlin", "implementation", "generateBridgesForFunctionDescriptor", "", "Lorg/jetbrains/kotlin/backend/common/bridges/Bridge;", "Signature", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "signature", "Lkotlin/Function1;", "isBodyOwner", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "", "backend-common"})
public final class ImplKt {
    @NotNull
    public static final <Signature> Set<Bridge<Signature>> generateBridgesForFunctionDescriptor(@NotNull FunctionDescriptor descriptor2, @NotNull Function1<? super FunctionDescriptor, ? extends Signature> signature, @NotNull Function1<? super DeclarationDescriptor, Boolean> isBodyOwner) {
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        Intrinsics.checkParameterIsNotNull(signature, "signature");
        Intrinsics.checkParameterIsNotNull(isBodyOwner, "isBodyOwner");
        return BridgesKt.generateBridges((FunctionHandle)new DescriptorBasedFunctionHandle(descriptor2, isBodyOwner), new Function1<DescriptorBasedFunctionHandle, Signature>(signature){
            final /* synthetic */ Function1 $signature;

            public final Signature invoke(@NotNull DescriptorBasedFunctionHandle it) {
                Intrinsics.checkParameterIsNotNull(it, "it");
                return (Signature)this.$signature.invoke(it.getDescriptor());
            }
            {
                this.$signature = function1;
                super(1);
            }
        });
    }

    @Nullable
    public static final CallableMemberDescriptor findInterfaceImplementation(@NotNull CallableMemberDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        if (descriptor2.getKind().isReal()) {
            return null;
        }
        if (CallResolverUtilKt.isOrOverridesSynthesized(descriptor2)) {
            return null;
        }
        CallableMemberDescriptor callableMemberDescriptor = ImplKt.findImplementationFromInterface(descriptor2);
        if (callableMemberDescriptor == null) {
            return null;
        }
        CallableMemberDescriptor implementation = callableMemberDescriptor;
        CallableMemberDescriptor callableMemberDescriptor2 = ImplKt.firstSuperMethodFromKotlin(descriptor2, implementation);
        if (callableMemberDescriptor2 == null) {
            return null;
        }
        CallableMemberDescriptor immediateConcreteSuper = callableMemberDescriptor2;
        if (!DescriptorUtils.isInterface(immediateConcreteSuper.getContainingDeclaration())) {
            return null;
        }
        return immediateConcreteSuper;
    }

    @Nullable
    public static final CallableMemberDescriptor findImplementationFromInterface(@NotNull CallableMemberDescriptor descriptor2) {
        Object v0;
        block3: {
            Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
            Set<CallableMemberDescriptor> overridden = OverridingUtil.getOverriddenDeclarations(descriptor2);
            Set<CallableMemberDescriptor> filtered = OverridingUtil.filterOutOverridden(overridden);
            Iterable $receiver$iv = filtered;
            for (Object element$iv : $receiver$iv) {
                CallableMemberDescriptor it = (CallableMemberDescriptor)element$iv;
                if (!(Intrinsics.areEqual((Object)it.getModality(), (Object)Modality.ABSTRACT) ^ true)) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        CallableMemberDescriptor callableMemberDescriptor = v0;
        if (callableMemberDescriptor == null) {
            return null;
        }
        CallableMemberDescriptor result2 = callableMemberDescriptor;
        if (DescriptorUtils.isClassOrEnumClass(result2.getContainingDeclaration())) {
            return null;
        }
        return result2;
    }

    @Nullable
    public static final CallableMemberDescriptor firstSuperMethodFromKotlin(@NotNull CallableMemberDescriptor descriptor2, @NotNull CallableMemberDescriptor implementation) {
        Object v0;
        block1: {
            Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
            Intrinsics.checkParameterIsNotNull(implementation, "implementation");
            Iterable $receiver$iv = descriptor2.getOverriddenDescriptors();
            for (Object element$iv : $receiver$iv) {
                CallableMemberDescriptor overridden = (CallableMemberDescriptor)element$iv;
                if (!(Intrinsics.areEqual((Object)overridden.getModality(), (Object)Modality.ABSTRACT) ^ true && (Intrinsics.areEqual(overridden, implementation) || OverridingUtil.overrides((CallableDescriptor)overridden, (CallableDescriptor)implementation)))) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }
}

