/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm.compiler;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.PsiModificationTrackerImpl;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiModificationTracker;
import java.io.File;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analyzer.AnalysisResult;
import org.jetbrains.kotlin.asJava.FilteredJvmDiagnostics;
import org.jetbrains.kotlin.backend.common.output.OutputFile;
import org.jetbrains.kotlin.backend.common.output.OutputFileCollection;
import org.jetbrains.kotlin.backend.common.output.SimpleOutputFileCollection;
import org.jetbrains.kotlin.backend.jvm.JvmIrCodegenFactory;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeys;
import org.jetbrains.kotlin.cli.common.ExitCode;
import org.jetbrains.kotlin.cli.common.UtilsKt;
import org.jetbrains.kotlin.cli.common.messages.AnalyzerWithCompilerReport;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.messages.OutputMessageUtil;
import org.jetbrains.kotlin.cli.common.output.outputUtils.OutputUtilsKt;
import org.jetbrains.kotlin.cli.jvm.K2JVMCompiler;
import org.jetbrains.kotlin.cli.jvm.compiler.CliLightClassGenerationSupport;
import org.jetbrains.kotlin.cli.jvm.compiler.CompileEnvironmentUtil;
import org.jetbrains.kotlin.cli.jvm.compiler.JvmPackagePartProvider;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinToJVMBytecodeCompiler;
import org.jetbrains.kotlin.cli.jvm.compiler.TopDownAnalyzerFacadeForJVM;
import org.jetbrains.kotlin.cli.jvm.config.JavaSourceRoot;
import org.jetbrains.kotlin.cli.jvm.config.JvmClasspathRoot;
import org.jetbrains.kotlin.cli.jvm.config.JvmContentRoot;
import org.jetbrains.kotlin.cli.jvm.config.JvmContentRootsKt;
import org.jetbrains.kotlin.cli.jvm.config.JvmModulePathRoot;
import org.jetbrains.kotlin.cli.jvm.config.Kapt2EnabledKeyKt;
import org.jetbrains.kotlin.codegen.ClassBuilderFactories;
import org.jetbrains.kotlin.codegen.ClassBuilderFactory;
import org.jetbrains.kotlin.codegen.ClassFileFactory;
import org.jetbrains.kotlin.codegen.CodegenFactory;
import org.jetbrains.kotlin.codegen.CompilationErrorHandler;
import org.jetbrains.kotlin.codegen.DefaultCodegenFactory;
import org.jetbrains.kotlin.codegen.GeneratedClassLoader;
import org.jetbrains.kotlin.codegen.KotlinCodegenFacade;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.codegen.state.GenerationStateEventCallback;
import org.jetbrains.kotlin.codegen.state.GenerationStateKt;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.ContentRoot;
import org.jetbrains.kotlin.config.ContentRootsKt;
import org.jetbrains.kotlin.config.JVMConfigurationKeys;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtil;
import org.jetbrains.kotlin.idea.MainFunctionDetector;
import org.jetbrains.kotlin.javac.JavacWrapper;
import org.jetbrains.kotlin.load.kotlin.ModuleVisibilityManager;
import org.jetbrains.kotlin.modules.JavaRootPath;
import org.jetbrains.kotlin.modules.Module;
import org.jetbrains.kotlin.modules.TargetId;
import org.jetbrains.kotlin.modules.TargetIdKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.progress.ProgressIndicatorAndCompilationCanceledStatus;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtScript;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.diagnostics.Diagnostics;
import org.jetbrains.kotlin.script.ReflectionUtilKt;
import org.jetbrains.kotlin.util.PerformanceCounter;

@Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u00017B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u00052\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002J\u0010\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\n\u001a\u00020\u0005J#\u0010\u000f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u00052\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u0012H\u0000\u00a2\u0006\u0002\b\u0013J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\n\u001a\u00020\u0005J\u0016\u0010\u0016\u001a\u00020\u00152\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0018J \u0010\u0019\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001a2\u0006\u0010\n\u001a\u00020\u00052\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\u001cJ$\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u00122\u0006\u0010\u0017\u001a\u00020\u0018J\u0010\u0010#\u001a\u00020$2\u0006\u0010\u001f\u001a\u00020 H\u0002J \u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010'\u001a\u00020\u000e2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020)0\u0012H\u0002J8\u0010*\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010+\u001a\u00020\t2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020)0\u00122\b\u0010-\u001a\u0004\u0018\u00010\"H\u0002J\u001e\u0010.\u001a\b\u0012\u0004\u0012\u00020\f0\u00122\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010-\u001a\u00020\"H\u0002J&\u0010/\u001a\u0004\u0018\u00010\t2\b\u0010+\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u00052\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002J\u0010\u00100\u001a\u00020\u001e2\u0006\u00101\u001a\u000202H\u0002J\"\u00103\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u00104\u001a\u0002052\b\u00106\u001a\u0004\u0018\u00010&H\u0002R\u0018\u0010\u0003\u001a\u00020\u0004*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u00068"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinToJVMBytecodeCompiler;", "", "()V", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreEnvironment;", "getMessageCollector", "(Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreEnvironment;)Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "analyze", "Lorg/jetbrains/kotlin/analyzer/AnalysisResult;", "environment", "targetDescription", "", "analyzeAndGenerate", "Lorg/jetbrains/kotlin/codegen/state/GenerationState;", "compileAndExecuteScript", "Lorg/jetbrains/kotlin/cli/common/ExitCode;", "scriptArgs", "", "compileAndExecuteScript$cli", "compileBunchOfSources", "", "compileModules", "directory", "Ljava/io/File;", "compileScript", "Ljava/lang/Class;", "parentClassLoader", "Ljava/lang/ClassLoader;", "configureSourceRoots", "", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "chunk", "Lorg/jetbrains/kotlin/modules/Module;", "createOutputFilesFlushingCallbackIfPossible", "Lorg/jetbrains/kotlin/codegen/state/GenerationStateEventCallback;", "findMainClass", "Lorg/jetbrains/kotlin/name/FqName;", "generationState", "files", "Lorg/jetbrains/kotlin/psi/KtFile;", "generate", "result", "sourceFiles", "module", "getAbsolutePaths", "repeatAnalysisIfNeeded", "reportExceptionFromScript", "exception", "", "writeOutput", "outputFiles", "Lorg/jetbrains/kotlin/backend/common/output/OutputFileCollection;", "mainClass", "DirectoriesScope", "cli"})
public final class KotlinToJVMBytecodeCompiler {
    public static final KotlinToJVMBytecodeCompiler INSTANCE;

    /*
     * WARNING - void declaration
     */
    private final List<String> getAbsolutePaths(File directory, Module module2) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Iterable iterable = $receiver$iv = (Iterable)module2.getSourceFiles();
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void sourceFile;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            File source = new File((String)sourceFile);
            if (!source.isAbsolute()) {
                source = new File(directory, (String)sourceFile);
            }
            String string2 = source.getAbsolutePath();
            collection.add(string2);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final void writeOutput(CompilerConfiguration configuration, OutputFileCollection outputFiles, FqName mainClass) {
        File outputDir2;
        boolean reportOutputFiles = configuration.getBoolean(CommonConfigurationKeys.REPORT_OUTPUT_FILES);
        File jarPath = configuration.get(JVMConfigurationKeys.OUTPUT_JAR);
        MessageCollector messageCollector2 = configuration.get(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY, MessageCollector.Companion.getNONE());
        if (jarPath != null) {
            Boolean includeRuntime;
            Boolean bl = includeRuntime = configuration.get(JVMConfigurationKeys.INCLUDE_RUNTIME, false);
            Intrinsics.checkExpressionValueIsNotNull(bl, "includeRuntime");
            CompileEnvironmentUtil.writeToJar(jarPath, bl, mainClass, outputFiles);
            if (reportOutputFiles) {
                String message;
                void $receiver$iv$iv;
                Iterable $receiver$iv;
                Iterable iterable = $receiver$iv = (Iterable)outputFiles.asList();
                Collection destination$iv$iv = new ArrayList();
                for (Object element$iv$iv : $receiver$iv$iv) {
                    OutputFile it = (OutputFile)element$iv$iv;
                    Iterable list$iv$iv = it.getSourceFiles();
                    CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
                }
                String string = message = OutputMessageUtil.formatOutputMessage(CollectionsKt.distinct((List)destination$iv$iv), jarPath);
                Intrinsics.checkExpressionValueIsNotNull(string, "message");
                MessageCollector.DefaultImpls.report$default(messageCollector2, CompilerMessageSeverity.OUTPUT, string, null, 4, null);
            }
            return;
        }
        File file = configuration.get(JVMConfigurationKeys.OUTPUT_DIRECTORY);
        if (file == null) {
            file = new File(".");
        }
        File file2 = outputDir2 = file;
        Intrinsics.checkExpressionValueIsNotNull(file2, "outputDir");
        MessageCollector messageCollector3 = messageCollector2;
        Intrinsics.checkExpressionValueIsNotNull(messageCollector3, "messageCollector");
        OutputUtilsKt.writeAll(outputFiles, file2, messageCollector3, reportOutputFiles);
    }

    private final GenerationStateEventCallback createOutputFilesFlushingCallbackIfPossible(CompilerConfiguration configuration) {
        if (configuration.get(JVMConfigurationKeys.OUTPUT_DIRECTORY) == null) {
            return GenerationStateEventCallback.Companion.getDO_NOTHING();
        }
        return GenerationStateKt.GenerationStateEventCallback((Function1<? super GenerationState, Unit>)new Function1<GenerationState, Unit>(configuration){
            final /* synthetic */ CompilerConfiguration $configuration;

            public final void invoke(@NotNull GenerationState state2) {
                Intrinsics.checkParameterIsNotNull(state2, "state");
                List<OutputFile> list2 = state2.getFactory().getCurrentOutput();
                Intrinsics.checkExpressionValueIsNotNull(list2, "state.factory.currentOutput");
                SimpleOutputFileCollection currentOutput = new SimpleOutputFileCollection(list2);
                KotlinToJVMBytecodeCompiler.access$writeOutput(KotlinToJVMBytecodeCompiler.INSTANCE, this.$configuration, currentOutput, null);
                if (!this.$configuration.get(JVMConfigurationKeys.RETAIN_OUTPUT_IN_MEMORY, false).booleanValue()) {
                    state2.getFactory().releaseGeneratedOutput();
                }
            }
            {
                this.$configuration = compilerConfiguration;
                super(1);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean compileModules(@NotNull KotlinCoreEnvironment environment2, @NotNull File directory) {
        Object moduleConfiguration;
        Object ktFiles2;
        Intrinsics.checkParameterIsNotNull(environment2, "environment");
        Intrinsics.checkParameterIsNotNull(directory, "directory");
        ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
        ModuleVisibilityManager moduleVisibilityManager = ModuleVisibilityManager.SERVICE.getInstance(environment2.getProject());
        CompilerConfiguration projectConfiguration = environment2.getConfiguration();
        List<Module> chunk = projectConfiguration.getNotNull(JVMConfigurationKeys.MODULES);
        Iterator<Module> iterator2 = chunk.iterator();
        while (iterator2.hasNext()) {
            Module module2;
            Module module3 = module2 = iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull(module3, "module");
            moduleVisibilityManager.addModule(module3);
        }
        List friendPaths = environment2.getConfiguration().getList(JVMConfigurationKeys.FRIEND_PATHS);
        Iterator iterator3 = friendPaths.iterator();
        while (iterator3.hasNext()) {
            String path2;
            String string = path2 = (String)iterator3.next();
            Intrinsics.checkExpressionValueIsNotNull(string, "path");
            moduleVisibilityManager.addFriendPath(string);
        }
        String targetDescription2 = "in targets [" + CollectionsKt.joinToString$default(chunk, null, null, null, 0, null, compileModules.targetDescription.1.INSTANCE, 31, null) + "]";
        AnalysisResult result2 = this.repeatAnalysisIfNeeded(this.analyze(environment2, targetDescription2), environment2, targetDescription2);
        if (result2 == null || !result2.getShouldGenerateCode()) {
            return false;
        }
        ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
        result2.throwIfError();
        LinkedHashMap outputs = org.jetbrains.kotlin.utils.CollectionsKt.newLinkedHashMapWithExpectedSize(chunk.size());
        for (Module module4 : chunk) {
            Object object;
            ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
            Project project = environment2.getProject();
            Module module5 = module4;
            Intrinsics.checkExpressionValueIsNotNull(module5, "module");
            Object object2 = ktFiles2 = CompileEnvironmentUtil.getKtFiles(project, (Collection<String>)this.getAbsolutePaths(directory, module5), projectConfiguration, compileModules.ktFiles.1.INSTANCE);
            Intrinsics.checkExpressionValueIsNotNull(object2, "ktFiles");
            if (!UtilsKt.checkKotlinPackageUsage(environment2, (Collection)object2)) {
                return false;
            }
            Object $receiver = object = projectConfiguration.copy();
            ((CompilerConfiguration)$receiver).put(JVMConfigurationKeys.OUTPUT_DIRECTORY, new File(module4.getOutputDirectory()));
            moduleConfiguration = object;
            object = outputs;
            $receiver = module4;
            Object object3 = moduleConfiguration;
            Intrinsics.checkExpressionValueIsNotNull(object3, "moduleConfiguration");
            GenerationState $i$a$1$apply = this.generate(environment2, (CompilerConfiguration)object3, result2, (List<? extends KtFile>)ktFiles2, module4);
            object.put($receiver, $i$a$1$apply);
        }
        try {
            block21: {
                Object object;
                block22: {
                    Object object4;
                    boolean it22322;
                    ktFiles2 = outputs;
                    for (Map.Entry entry : ktFiles2.entrySet()) {
                        moduleConfiguration = entry;
                        GenerationState state2 = (GenerationState)moduleConfiguration.getValue();
                        ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
                        this.writeOutput(state2.getConfiguration(), state2.getFactory(), null);
                    }
                    if (!projectConfiguration.getBoolean(JVMConfigurationKeys.COMPILE_JAVA)) break block21;
                    Module module6 = CollectionsKt.singleOrNull(chunk);
                    if (module6 == null) break block22;
                    object = JavacWrapper.Companion.getInstance(environment2.getProject());
                    boolean state2 = false;
                    try {
                        JavacWrapper it22322 = (JavacWrapper)object;
                        it22322 = it22322.compile(new File(module6.getOutputDirectory()));
                        object4 = object;
                    }
                    catch (Exception it22322) {
                        try {
                            state2 = true;
                            try {
                                Object object5 = object;
                                if (object5 != null) {
                                    object5.close();
                                }
                            }
                            catch (Exception $i$a$1$use) {
                                // empty catch block
                            }
                            throw (Throwable)it22322;
                        }
                        catch (Throwable it22322) {
                            if (!state2) {
                                Object object6 = object;
                                if (object6 != null) {
                                    object6.close();
                                }
                            }
                            throw it22322;
                        }
                    }
                    if (object4 != null) {
                        object4.close();
                    }
                    boolean bl = it22322;
                    return bl;
                }
                object = projectConfiguration.getNotNull(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY);
                MessageCollector it = (MessageCollector)object;
                MessageCollector.DefaultImpls.report$default(it, CompilerMessageSeverity.WARNING, "A chunk contains multiple modules (" + CollectionsKt.joinToString$default(chunk, null, null, null, 0, null, compileModules.2.1.INSTANCE, 31, null) + "). -Xuse-javac option couldn't be used to compile java files", null, 4, null);
                JavacWrapper.Companion.getInstance(environment2.getProject()).close();
            }
            boolean bl = true;
            return bl;
        }
        finally {
            Iterable $receiver$iv = outputs.values();
            for (Object element$iv : $receiver$iv) {
                GenerationState p1 = (GenerationState)element$iv;
                p1.destroy();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void configureSourceRoots(@NotNull CompilerConfiguration configuration, @NotNull List<? extends Module> chunk, @NotNull File directory) {
        boolean bl;
        block18: {
            boolean bl2;
            Iterable iterable;
            block20: {
                Intrinsics.checkParameterIsNotNull(configuration, "configuration");
                Intrinsics.checkParameterIsNotNull(chunk, "chunk");
                Intrinsics.checkParameterIsNotNull(directory, "directory");
                for (Module module2 : chunk) {
                    ContentRootsKt.addKotlinSourceRoots(configuration, this.getAbsolutePaths(directory, module2));
                }
                for (Module module3 : chunk) {
                    for (JavaRootPath javaRootPath : module3.getJavaSourceRoots()) {
                        String path2 = javaRootPath.component1();
                        String packagePrefix = javaRootPath.component2();
                        JvmContentRootsKt.addJavaSourceRoot(configuration, new File(path2), packagePrefix);
                    }
                }
                iterable = chunk;
                if (!(iterable instanceof Collection) || !((Collection)iterable).isEmpty()) break block20;
                bl = false;
                break block18;
            }
            Iterator iterator2 = iterable.iterator();
            block3: do {
                boolean bl3;
                Iterable $receiver$iv;
                if (iterator2.hasNext()) {
                    Object element$iv = iterator2.next();
                    Module module4 = (Module)element$iv;
                    $receiver$iv = module4.getJavaSourceRoots();
                    if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                        bl2 = false;
                        continue;
                    }
                } else {
                    bl = false;
                    break block18;
                }
                Iterator iterator3 = $receiver$iv.iterator();
                do {
                    block22: {
                        block23: {
                            boolean bl4;
                            block19: {
                                Object[] $receiver$iv2;
                                block24: {
                                    block21: {
                                        if (!iterator3.hasNext()) break block21;
                                        Object element$iv = iterator3.next();
                                        JavaRootPath $path_packagePrefix = (JavaRootPath)element$iv;
                                        String path3 = $path_packagePrefix.component1();
                                        String packagePrefix = $path_packagePrefix.component2();
                                        File file = new File(path3);
                                        if (packagePrefix != null) break block22;
                                        if (Intrinsics.areEqual(file.getName(), "module-info.java")) break block23;
                                        if (!file.isDirectory()) break block22;
                                        $receiver$iv2 = file.listFiles();
                                        break block24;
                                    }
                                    bl2 = false;
                                    continue block3;
                                }
                                for (int i = 0; i < $receiver$iv2.length; ++i) {
                                    Object element$iv = $receiver$iv2[i];
                                    File it = (File)element$iv;
                                    if (!Intrinsics.areEqual(it.getName(), "module-info.java")) continue;
                                    bl4 = true;
                                    break block19;
                                }
                                bl4 = false;
                            }
                            if (!bl4) break block22;
                        }
                        bl3 = true;
                        continue;
                    }
                    bl3 = false;
                } while (!bl3);
                bl2 = true;
            } while (!bl2);
            bl = true;
        }
        boolean bl5 = bl;
        Iterator<? extends Module> iterator4 = chunk.iterator();
        block6: while (true) {
            if (!iterator4.hasNext()) {
                for (Module module5 : chunk) {
                    String modularJdkRoot = module5.getModularJdkRoot();
                    if (modularJdkRoot == null) continue;
                    configuration.put(JVMConfigurationKeys.JDK_HOME, new File(modularJdkRoot));
                    break;
                }
                configuration.addAll(JVMConfigurationKeys.MODULES, (Collection)chunk);
                return;
            }
            Module module6 = iterator4.next();
            Iterator<String> iterator5 = module6.getClasspathRoots().iterator();
            while (true) {
                if (!iterator5.hasNext()) continue block6;
                String classpathRoot = iterator5.next();
                configuration.add(JVMConfigurationKeys.CONTENT_ROOTS, bl5 ? (JvmContentRoot)new JvmModulePathRoot(new File(classpathRoot)) : (JvmContentRoot)new JvmClasspathRoot(new File(classpathRoot)));
            }
            break;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final FqName findMainClass(GenerationState generationState, List<? extends KtFile> files2) {
        Object v0;
        block2: {
            void $receiver$iv;
            MainFunctionDetector mainFunctionDetector = new MainFunctionDetector(generationState.getBindingContext());
            Sequence sequence2 = SequencesKt.map(CollectionsKt.asSequence((Iterable)files2), (Function1)new Function1<KtFile, FqName>(mainFunctionDetector){
                final /* synthetic */ MainFunctionDetector $mainFunctionDetector;

                @Nullable
                public final FqName invoke(@NotNull KtFile file) {
                    Intrinsics.checkParameterIsNotNull(file, "file");
                    return this.$mainFunctionDetector.hasMain(file.getDeclarations()) ? JvmFileClassUtil.getFileClassInfoNoResolve(file).getFacadeClassFqName() : null;
                }
                {
                    this.$mainFunctionDetector = mainFunctionDetector;
                    super(1);
                }
            });
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $receiver$iv) {
                FqName it = (FqName)element$iv;
                if (!(it != null)) continue;
                if (found$iv) {
                    v0 = null;
                    break block2;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            v0 = !found$iv ? null : single$iv;
        }
        return v0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean compileBunchOfSources(@NotNull KotlinCoreEnvironment environment2) {
        Intrinsics.checkParameterIsNotNull(environment2, "environment");
        ModuleVisibilityManager moduleVisibilityManager = ModuleVisibilityManager.SERVICE.getInstance(environment2.getProject());
        List friendPaths = environment2.getConfiguration().getList(JVMConfigurationKeys.FRIEND_PATHS);
        Iterator iterator2 = friendPaths.iterator();
        while (iterator2.hasNext()) {
            String path2;
            String string = path2 = (String)iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull(string, "path");
            moduleVisibilityManager.addFriendPath(string);
        }
        if (!UtilsKt.checkKotlinPackageUsage(environment2, (Collection<? extends KtFile>)environment2.getSourceFiles())) {
            return false;
        }
        GenerationState generationState = this.analyzeAndGenerate(environment2);
        if (generationState == null) {
            return false;
        }
        GenerationState generationState2 = generationState;
        FqName mainClass = this.findMainClass(generationState2, environment2.getSourceFiles());
        try {
            this.writeOutput(environment2.getConfiguration(), generationState2.getFactory(), mainClass);
            boolean bl = true;
            return bl;
        }
        finally {
            generationState2.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final ExitCode compileAndExecuteScript$cli(@NotNull KotlinCoreEnvironment environment2, @NotNull List<String> scriptArgs) {
        Intrinsics.checkParameterIsNotNull(environment2, "environment");
        Intrinsics.checkParameterIsNotNull(scriptArgs, "scriptArgs");
        Class clazz = KotlinToJVMBytecodeCompiler.compileScript$default(this, environment2, null, 2, null);
        if (clazz == null) {
            return ExitCode.COMPILATION_ERROR;
        }
        Class scriptClass = clazz;
        try {
            try {
                if (ReflectionUtilKt.tryConstructClassFromStringArgs(scriptClass, scriptArgs) == null) {
                    throw (Throwable)new RuntimeException("unable to find appropriate constructor for class " + scriptClass.getName() + " accepting arguments " + scriptArgs + '\n');
                }
            }
            finally {
                System.out.flush();
                System.err.flush();
            }
        }
        catch (Throwable e) {
            this.reportExceptionFromScript(e);
            return ExitCode.SCRIPT_EXECUTION_ERROR;
        }
        return ExitCode.OK;
    }

    /*
     * WARNING - void declaration
     */
    private final AnalysisResult repeatAnalysisIfNeeded(AnalysisResult result2, KotlinCoreEnvironment environment2, String targetDescription2) {
        if (result2 instanceof AnalysisResult.RetryWithAdditionalJavaRoots) {
            CompilerConfiguration configuration = environment2.getConfiguration();
            boolean oldReadOnlyValue = configuration.isReadOnly();
            configuration.setReadOnly(false);
            JvmContentRootsKt.addJavaSourceRoots$default(configuration, ((AnalysisResult.RetryWithAdditionalJavaRoots)result2).getAdditionalJavaRoots(), null, 2, null);
            configuration.setReadOnly(oldReadOnlyValue);
            if (((AnalysisResult.RetryWithAdditionalJavaRoots)result2).getAddToEnvironment()) {
                Collection<JavaSourceRoot> collection;
                void $receiver$iv$iv;
                void $receiver$iv;
                Iterable iterable = ((AnalysisResult.RetryWithAdditionalJavaRoots)result2).getAdditionalJavaRoots();
                KotlinCoreEnvironment kotlinCoreEnvironment = environment2;
                void var7_8 = $receiver$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
                for (Object item$iv$iv : $receiver$iv$iv) {
                    void it;
                    File file = (File)item$iv$iv;
                    collection = destination$iv$iv;
                    JavaSourceRoot javaSourceRoot = new JavaSourceRoot((File)it, null);
                    collection.add(javaSourceRoot);
                }
                collection = (List)destination$iv$iv;
                kotlinCoreEnvironment.updateClasspath((List<? extends ContentRoot>)collection);
            }
            ApplicationManager.getApplication().runWriteAction(new Runnable(environment2){
                final /* synthetic */ KotlinCoreEnvironment $environment;

                public final void run() {
                    block1: {
                        PsiModificationTracker psiModificationTracker = PsiManager.getInstance(this.$environment.getProject()).getModificationTracker();
                        if (!(psiModificationTracker instanceof PsiModificationTrackerImpl)) {
                            psiModificationTracker = null;
                        }
                        PsiModificationTrackerImpl psiModificationTrackerImpl = (PsiModificationTrackerImpl)psiModificationTracker;
                        if (psiModificationTrackerImpl == null) break block1;
                        psiModificationTrackerImpl.incCounter();
                    }
                }
                {
                    this.$environment = kotlinCoreEnvironment;
                }
            });
            MessageCollector messageCollector2 = configuration.get(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY);
            if (messageCollector2 != null) {
                messageCollector2.clear();
            }
            return this.analyze(environment2, targetDescription2);
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    private final void reportExceptionFromScript(Throwable exception) {
        PrintStream stream2 = System.err;
        Throwable cause = exception.getCause();
        if (!(exception instanceof InvocationTargetException) || cause == null) {
            exception.printStackTrace(stream2);
            return;
        }
        stream2.println(cause);
        StackTraceElement[] fullTrace = cause.getStackTrace();
        int n = 0;
        int n2 = ((Object[])fullTrace).length - ((Object[])((InvocationTargetException)exception).getStackTrace()).length;
        while (n < n2) {
            void i;
            stream2.println("\tat " + fullTrace[i]);
            ++i;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Class<?> compileScript(@NotNull KotlinCoreEnvironment environment2, @Nullable ClassLoader parentClassLoader) {
        Intrinsics.checkParameterIsNotNull(environment2, "environment");
        GenerationState generationState = this.analyzeAndGenerate(environment2);
        if (generationState == null) {
            return null;
        }
        GenerationState state2 = generationState;
        try {
            Object element$iv$iv$iv;
            Iterable $receiver$iv$iv;
            Iterable $receiver$iv;
            Iterable iterable = $receiver$iv = (Iterable)environment2.getConfiguration().getList(JVMConfigurationKeys.CONTENT_ROOTS);
            Collection destination$iv$iv = new ArrayList();
            Iterator $receiver$iv$iv$iv = $receiver$iv$iv;
            Iterator iterator2 = $receiver$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                File file;
                element$iv$iv$iv = iterator2.next();
                Object element$iv$iv = element$iv$iv$iv;
                ContentRoot root2 = (ContentRoot)element$iv$iv;
                ContentRoot contentRoot = root2;
                File file2 = contentRoot instanceof JvmModulePathRoot ? ((JvmModulePathRoot)root2).getFile() : (contentRoot instanceof JvmClasspathRoot ? ((JvmClasspathRoot)root2).getFile() : null);
                if (file2 == null) continue;
                File it$iv$iv = file = file2;
                destination$iv$iv.add(it$iv$iv);
            }
            $receiver$iv = (List)destination$iv$iv;
            $receiver$iv$iv = $receiver$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                element$iv$iv$iv = (File)item$iv$iv;
                Collection collection = destination$iv$iv;
                URL uRL = it.toURI().toURL();
                collection.add(uRL);
            }
            List urls = (List)destination$iv$iv;
            ClassFileFactory classFileFactory = state2.getFactory();
            ClassLoader classLoader = parentClassLoader;
            if (classLoader == null) {
                void $receiver$iv2;
                $receiver$iv$iv = urls;
                ClassFileFactory classFileFactory2 = classFileFactory;
                void thisCollection$iv = $receiver$iv2;
                URL[] uRLArray = thisCollection$iv.toArray(new URL[thisCollection$iv.size()]);
                if (uRLArray == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                URL[] uRLArray2 = uRLArray;
                classFileFactory = classFileFactory2;
                ClassLoader classLoader2 = null;
                URL[] uRLArray3 = uRLArray2;
                classLoader = new URLClassLoader(uRLArray3, classLoader2);
            }
            URL[] uRLArray = new URL[]{};
            ClassLoader classLoader3 = classLoader;
            ClassFileFactory classFileFactory3 = classFileFactory;
            GeneratedClassLoader classLoader4 = new GeneratedClassLoader(classFileFactory3, classLoader3, uRLArray);
            KtScript ktScript = environment2.getSourceFiles().get(0).getScript();
            if (ktScript == null) {
                String string = "Script must be parsed";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            KtScript script = ktScript;
            return classLoader4.loadClass(script.getFqName().asString());
        }
        catch (Exception e) {
            throw (Throwable)new RuntimeException("Failed to evaluate script: " + e, e);
        }
    }

    @Nullable
    public static /* bridge */ /* synthetic */ Class compileScript$default(KotlinToJVMBytecodeCompiler kotlinToJVMBytecodeCompiler, KotlinCoreEnvironment kotlinCoreEnvironment, ClassLoader classLoader, int n, Object object) {
        if ((n & 2) != 0) {
            classLoader = null;
        }
        return kotlinToJVMBytecodeCompiler.compileScript(kotlinCoreEnvironment, classLoader);
    }

    @Nullable
    public final GenerationState analyzeAndGenerate(@NotNull KotlinCoreEnvironment environment2) {
        Intrinsics.checkParameterIsNotNull(environment2, "environment");
        AnalysisResult analysisResult2 = this.repeatAnalysisIfNeeded(this.analyze(environment2, null), environment2, null);
        if (analysisResult2 == null) {
            return null;
        }
        AnalysisResult result2 = analysisResult2;
        if (!result2.getShouldGenerateCode()) {
            return null;
        }
        result2.throwIfError();
        return this.generate(environment2, environment2.getConfiguration(), result2, environment2.getSourceFiles(), null);
    }

    private final AnalysisResult analyze(KotlinCoreEnvironment environment2, String targetDescription2) {
        List<KtFile> sourceFiles2 = environment2.getSourceFiles();
        MessageCollector collector2 = this.getMessageCollector(environment2);
        long analysisStart = PerformanceCounter.Companion.currentTime();
        AnalyzerWithCompilerReport analyzerWithCompilerReport = new AnalyzerWithCompilerReport(collector2);
        analyzerWithCompilerReport.analyzeAndReport((Collection<? extends KtFile>)sourceFiles2, (Function0<? extends AnalysisResult>)new Function0<AnalysisResult>(environment2, sourceFiles2){
            final /* synthetic */ KotlinCoreEnvironment $environment;
            final /* synthetic */ List $sourceFiles;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final AnalysisResult invoke() {
                GlobalSearchScope globalSearchScope;
                Set<T> set;
                HashSet hashSet;
                Set<T> $receiver$iv;
                Project project = this.$environment.getProject();
                List<Module> list2 = this.$environment.getConfiguration().get(JVMConfigurationKeys.MODULES);
                if (list2 != null) {
                    void destination$iv;
                    Iterable iterable = list2;
                    Collection collection = new HashSet<E>();
                    Set<T> $receiver$iv$iv = $receiver$iv;
                    for (T element$iv$iv : $receiver$iv$iv) {
                        VirtualFile virtualFile2;
                        T element$iv = element$iv$iv;
                        Module module2 = (Module)element$iv;
                        if (this.$environment.findLocalFile$cli(module2.getOutputDirectory()) == null) continue;
                        VirtualFile it$iv = virtualFile2;
                        destination$iv.add(it$iv);
                    }
                    hashSet = (HashSet)destination$iv;
                } else {
                    hashSet = null;
                }
                if ((set = ($receiver$iv = (Set<T>)hashSet)) == null) {
                    set = SetsKt.emptySet();
                }
                Set<T> moduleOutputs = set;
                GlobalSearchScope sourcesOnly = TopDownAnalyzerFacadeForJVM.INSTANCE.newModuleSearchScope(project, this.$sourceFiles);
                if (moduleOutputs.isEmpty()) {
                    globalSearchScope = sourcesOnly;
                } else {
                    GlobalSearchScope globalSearchScope2 = sourcesOnly.uniteWith(new DirectoriesScope(project, moduleOutputs));
                    globalSearchScope = globalSearchScope2;
                    Intrinsics.checkExpressionValueIsNotNull(globalSearchScope2, "sourcesOnly.uniteWith(Di\u2026(project, moduleOutputs))");
                }
                GlobalSearchScope scope = globalSearchScope;
                return TopDownAnalyzerFacadeForJVM.analyzeFilesWithJavaIntegration$default(project, this.$sourceFiles, new CliLightClassGenerationSupport.NoScopeRecordCliBindingTrace(), this.$environment.getConfiguration(), new Function1<GlobalSearchScope, JvmPackagePartProvider>(this.$environment){

                    @NotNull
                    public final JvmPackagePartProvider invoke(@NotNull GlobalSearchScope p1) {
                        Intrinsics.checkParameterIsNotNull(p1, "p1");
                        return ((KotlinCoreEnvironment)this.receiver).createPackagePartProvider(p1);
                    }

                    public final KDeclarationContainer getOwner() {
                        return Reflection.getOrCreateKotlinClass(KotlinCoreEnvironment.class);
                    }

                    public final String getName() {
                        return "createPackagePartProvider";
                    }

                    public final String getSignature() {
                        return "createPackagePartProvider(Lcom/intellij/psi/search/GlobalSearchScope;)Lorg/jetbrains/kotlin/cli/jvm/compiler/JvmPackagePartProvider;";
                    }
                }, null, scope, 32, null);
            }
            {
                this.$environment = kotlinCoreEnvironment;
                this.$sourceFiles = list2;
                super(0);
            }
        });
        long analysisNanos = PerformanceCounter.Companion.currentTime() - analysisStart;
        int sourceLinesOfCode = environment2.countLinesOfCode$cli(sourceFiles2);
        long time = TimeUnit.NANOSECONDS.toMillis(analysisNanos);
        float speed = (float)sourceLinesOfCode * (float)1000 / (float)time;
        StringBuilder stringBuilder = new StringBuilder().append("ANALYZE: ").append(sourceFiles2.size()).append(" files (").append(sourceLinesOfCode).append(" lines) ");
        String string = targetDescription2;
        if (string == null) {
            string = "";
        }
        String string2 = "%.3f";
        Object[] objectArray = new Object[]{Float.valueOf(speed)};
        StringBuilder stringBuilder2 = stringBuilder.append(string).append("in ").append(time).append(" ms - ");
        String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull(string3, "java.lang.String.format(this, *args)");
        String string4 = string3;
        String message = stringBuilder2.append(string4).append(" loc/s").toString();
        K2JVMCompiler.Companion.reportPerf(environment2.getConfiguration(), message);
        AnalysisResult analysisResult2 = analyzerWithCompilerReport.getAnalysisResult();
        return !analyzerWithCompilerReport.hasErrors() || analysisResult2 instanceof AnalysisResult.RetryWithAdditionalJavaRoots ? analysisResult2 : null;
    }

    private final GenerationState generate(KotlinCoreEnvironment environment2, CompilerConfiguration configuration, AnalysisResult result2, List<? extends KtFile> sourceFiles2, Module module2) {
        File file;
        String string;
        String string2;
        TargetId targetId;
        TargetId targetId2;
        Module p1;
        Project project;
        ClassBuilderFactory classBuilderFactory;
        ModuleDescriptor moduleDescriptor;
        BindingContext bindingContext;
        List<? extends KtFile> list2;
        CompilerConfiguration compilerConfiguration;
        GenerationState.GenerateClassFilter generateClassFilter;
        CodegenFactory codegenFactory;
        Module module3;
        Boolean bl = environment2.getProject().getUserData(Kapt2EnabledKeyKt.getIS_KAPT2_ENABLED_KEY());
        if (bl == null) {
            bl = false;
        }
        Boolean isKapt2Enabled = bl;
        Project project2 = environment2.getProject();
        Boolean bl2 = isKapt2Enabled;
        Intrinsics.checkExpressionValueIsNotNull(bl2, "isKapt2Enabled");
        ClassBuilderFactory classBuilderFactory2 = ClassBuilderFactories.binaries(bl2);
        ClassBuilderFactory classBuilderFactory3 = classBuilderFactory2;
        Intrinsics.checkExpressionValueIsNotNull(classBuilderFactory2, "ClassBuilderFactories.binaries(isKapt2Enabled)");
        ModuleDescriptor moduleDescriptor2 = result2.getModuleDescriptor();
        BindingContext bindingContext2 = result2.getBindingContext();
        List<? extends KtFile> list3 = sourceFiles2;
        CompilerConfiguration compilerConfiguration2 = configuration;
        GenerationState.GenerateClassFilter generateClassFilter2 = GenerationState.GenerateClassFilter.GENERATE_ALL;
        CodegenFactory codegenFactory2 = configuration.getBoolean(JVMConfigurationKeys.IR) ? (CodegenFactory)JvmIrCodegenFactory.INSTANCE : (CodegenFactory)DefaultCodegenFactory.INSTANCE;
        Module module4 = module2;
        if (module4 != null) {
            module3 = module4;
            codegenFactory = codegenFactory2;
            generateClassFilter = generateClassFilter2;
            compilerConfiguration = compilerConfiguration2;
            list2 = list3;
            bindingContext = bindingContext2;
            moduleDescriptor = moduleDescriptor2;
            classBuilderFactory = classBuilderFactory3;
            project = project2;
            p1 = module3;
            targetId2 = TargetIdKt.TargetId(p1);
            project2 = project;
            classBuilderFactory3 = classBuilderFactory;
            moduleDescriptor2 = moduleDescriptor;
            bindingContext2 = bindingContext;
            list3 = list2;
            compilerConfiguration2 = compilerConfiguration;
            generateClassFilter2 = generateClassFilter;
            codegenFactory2 = codegenFactory;
            targetId = targetId2;
        } else {
            targetId = null;
        }
        Module module5 = module2;
        if (module5 != null) {
            module3 = module5;
            targetId2 = targetId;
            codegenFactory = codegenFactory2;
            generateClassFilter = generateClassFilter2;
            compilerConfiguration = compilerConfiguration2;
            list2 = list3;
            bindingContext = bindingContext2;
            moduleDescriptor = moduleDescriptor2;
            classBuilderFactory = classBuilderFactory3;
            project = project2;
            p1 = module3;
            string2 = p1.getModuleName();
            project2 = project;
            classBuilderFactory3 = classBuilderFactory;
            moduleDescriptor2 = moduleDescriptor;
            bindingContext2 = bindingContext;
            list3 = list2;
            compilerConfiguration2 = compilerConfiguration;
            generateClassFilter2 = generateClassFilter;
            codegenFactory2 = codegenFactory;
            targetId = targetId2;
            string = string2;
        } else {
            string = null;
        }
        Module module6 = module2;
        if (module6 != null) {
            module3 = module6;
            string2 = string;
            targetId2 = targetId;
            codegenFactory = codegenFactory2;
            generateClassFilter = generateClassFilter2;
            compilerConfiguration = compilerConfiguration2;
            list2 = list3;
            bindingContext = bindingContext2;
            moduleDescriptor = moduleDescriptor2;
            classBuilderFactory = classBuilderFactory3;
            project = project2;
            Module it = module3;
            File file2 = new File(it.getOutputDirectory());
            project2 = project;
            classBuilderFactory3 = classBuilderFactory;
            moduleDescriptor2 = moduleDescriptor;
            bindingContext2 = bindingContext;
            list3 = list2;
            compilerConfiguration2 = compilerConfiguration;
            generateClassFilter2 = generateClassFilter;
            codegenFactory2 = codegenFactory;
            targetId = targetId2;
            string = string2;
            file = file2;
        } else {
            file = null;
        }
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n = 4096;
        boolean bl3 = false;
        GenerationStateEventCallback generationStateEventCallback = this.createOutputFilesFlushingCallbackIfPossible(configuration);
        File file3 = file;
        String string3 = string;
        TargetId targetId3 = targetId;
        CodegenFactory codegenFactory3 = codegenFactory2;
        GenerationState.GenerateClassFilter generateClassFilter3 = generateClassFilter2;
        CompilerConfiguration compilerConfiguration3 = compilerConfiguration2;
        List<? extends KtFile> list4 = list3;
        BindingContext bindingContext3 = bindingContext2;
        ModuleDescriptor moduleDescriptor3 = moduleDescriptor2;
        ClassBuilderFactory classBuilderFactory4 = classBuilderFactory3;
        Project project3 = project2;
        GenerationState generationState = new GenerationState(project3, classBuilderFactory4, moduleDescriptor3, bindingContext3, list4, compilerConfiguration3, generateClassFilter3, codegenFactory3, targetId3, string3, file3, generationStateEventCallback, bl3, n, defaultConstructorMarker);
        ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
        long generationStart = PerformanceCounter.Companion.currentTime();
        KotlinCodegenFacade.compileCorrectFiles(generationState, CompilationErrorHandler.THROW_EXCEPTION);
        long generationNanos = PerformanceCounter.Companion.currentTime() - generationStart;
        String desc = module2 != null ? "target " + module2.getModuleName() + "-" + module2.getModuleType() + " " : "";
        int numberOfSourceFiles = sourceFiles2.size();
        int numberOfLines = environment2.countLinesOfCode$cli(sourceFiles2);
        long time = TimeUnit.NANOSECONDS.toMillis(generationNanos);
        float speed = (float)numberOfLines * (float)1000 / (float)time;
        String string4 = "%.3f";
        Object[] objectArray = new Object[]{Float.valueOf(speed)};
        StringBuilder stringBuilder = new StringBuilder().append("GENERATE: ").append(numberOfSourceFiles).append(" files (").append(numberOfLines).append(" lines) ").append(desc).append("in ").append(time).append(" ms - ");
        String string5 = String.format(string4, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull(string5, "java.lang.String.format(this, *args)");
        String string6 = string5;
        String message = stringBuilder.append(string6).append(" loc/s").toString();
        K2JVMCompiler.Companion.reportPerf(environment2.getConfiguration(), message);
        ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
        Diagnostics diagnostics = generationState.getCollectedExtraJvmDiagnostics();
        Diagnostics diagnostics2 = result2.getBindingContext().getDiagnostics();
        Intrinsics.checkExpressionValueIsNotNull(diagnostics2, "result.bindingContext.diagnostics");
        AnalyzerWithCompilerReport.Companion.reportDiagnostics((Diagnostics)new FilteredJvmDiagnostics(diagnostics, diagnostics2), this.getMessageCollector(environment2));
        BindingContext bindingContext4 = generationState.getExtraJvmDiagnosticsTrace().getBindingContext();
        Intrinsics.checkExpressionValueIsNotNull(bindingContext4, "generationState.extraJvm\u2026sticsTrace.bindingContext");
        AnalyzerWithCompilerReport.Companion.reportBytecodeVersionErrors(bindingContext4, this.getMessageCollector(environment2));
        ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
        return generationState;
    }

    private final MessageCollector getMessageCollector(@NotNull KotlinCoreEnvironment $receiver) {
        MessageCollector messageCollector2 = $receiver.getConfiguration().getNotNull(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY);
        Intrinsics.checkExpressionValueIsNotNull(messageCollector2, "configuration.getNotNull\u2026ys.MESSAGE_COLLECTOR_KEY)");
        return messageCollector2;
    }

    private KotlinToJVMBytecodeCompiler() {
        INSTANCE = this;
    }

    static {
        new KotlinToJVMBytecodeCompiler();
    }

    public static final /* synthetic */ void access$writeOutput(KotlinToJVMBytecodeCompiler $this, @NotNull CompilerConfiguration configuration, @NotNull OutputFileCollection outputFiles, @Nullable FqName mainClass) {
        $this.writeOutput(configuration, outputFiles, mainClass);
    }

    @Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0011\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0006H\u0096\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\n0\tj\b\u0012\u0004\u0012\u00020\n`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinToJVMBytecodeCompiler$DirectoriesScope;", "Lcom/intellij/psi/search/DelegatingGlobalSearchScope;", "project", "Lcom/intellij/openapi/project/Project;", "directories", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/intellij/openapi/project/Project;Ljava/util/Set;)V", "fileSystems", "Ljava/util/HashSet;", "Lcom/intellij/openapi/vfs/VirtualFileSystem;", "Lkotlin/collections/HashSet;", "contains", "", "file", "toString", "", "cli"})
    public static final class DirectoriesScope
    extends DelegatingGlobalSearchScope {
        private final HashSet<VirtualFileSystem> fileSystems;
        private final Set<VirtualFile> directories;

        @Override
        public boolean contains(@NotNull VirtualFile file) {
            Intrinsics.checkParameterIsNotNull(file, "file");
            if (!this.fileSystems.contains(file.getFileSystem())) {
                return false;
            }
            VirtualFile parent2 = file;
            while (!this.directories.contains(parent2)) {
                if (parent2.getParent() != null) continue;
                return false;
            }
            return true;
        }

        @Override
        @NotNull
        public String toString() {
            return "All files under: " + this.directories;
        }

        /*
         * WARNING - void declaration
         */
        public DirectoriesScope(@NotNull Project project, @NotNull Set<? extends VirtualFile> directories) {
            void destination$iv;
            void $receiver$iv;
            Intrinsics.checkParameterIsNotNull(project, "project");
            Intrinsics.checkParameterIsNotNull(directories, "directories");
            super(GlobalSearchScope.allScope(project));
            this.directories = directories;
            Iterable iterable = this.directories;
            DirectoriesScope directoriesScope = this;
            HashSet<VirtualFileSystem> hashSet = new HashSet<VirtualFileSystem>();
            Collection collection = hashSet;
            for (Object item$iv : $receiver$iv) {
                void p1;
                VirtualFile virtualFile2 = (VirtualFile)item$iv;
                hashSet = destination$iv;
                VirtualFileSystem virtualFileSystem = p1.getFileSystem();
                hashSet.add(virtualFileSystem);
            }
            hashSet = destination$iv;
            directoriesScope.fileSystems = hashSet;
        }
    }
}

