/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.daemon.report;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.daemon.common.CompilerServicesFacadeBase;
import org.jetbrains.kotlin.daemon.common.ReportCategory;
import org.jetbrains.kotlin.daemon.common.ReportSeverity;
import org.jetbrains.kotlin.daemon.report.DaemonMessageReporter;

@Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/daemon/report/DaemonMessageReporterImpl;", "Lorg/jetbrains/kotlin/daemon/report/DaemonMessageReporter;", "servicesFacade", "Lorg/jetbrains/kotlin/daemon/common/CompilerServicesFacadeBase;", "mySeverity", "Lorg/jetbrains/kotlin/daemon/common/ReportSeverity;", "(Lorg/jetbrains/kotlin/daemon/common/CompilerServicesFacadeBase;Lorg/jetbrains/kotlin/daemon/common/ReportSeverity;)V", "report", "", "severity", "message", "", "daemon"})
final class DaemonMessageReporterImpl
implements DaemonMessageReporter {
    private final CompilerServicesFacadeBase servicesFacade;
    private final ReportSeverity mySeverity;

    @Override
    public void report(@NotNull ReportSeverity severity, @NotNull String message) {
        Intrinsics.checkParameterIsNotNull((Object)severity, "severity");
        Intrinsics.checkParameterIsNotNull(message, "message");
        if (severity.getCode() <= this.mySeverity.getCode()) {
            this.servicesFacade.report(ReportCategory.DAEMON_MESSAGE.getCode(), severity.getCode(), message, null);
        }
    }

    public DaemonMessageReporterImpl(@NotNull CompilerServicesFacadeBase servicesFacade, @NotNull ReportSeverity mySeverity) {
        Intrinsics.checkParameterIsNotNull(servicesFacade, "servicesFacade");
        Intrinsics.checkParameterIsNotNull((Object)mySeverity, "mySeverity");
        this.servicesFacade = servicesFacade;
        this.mySeverity = mySeverity;
    }
}

