/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.callTranslator;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.backend.ast.metadata.SideEffectKind;
import org.jetbrains.kotlin.js.translate.callTranslator.CallInfoKt;
import org.jetbrains.kotlin.js.translate.callTranslator.CallTranslator;
import org.jetbrains.kotlin.js.translate.callTranslator.CallTranslatorKt$WhenMappings;
import org.jetbrains.kotlin.js.translate.callTranslator.ExplicitReceivers;
import org.jetbrains.kotlin.js.translate.callTranslator.FunctionCallCasesKt;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.general.Translation;
import org.jetbrains.kotlin.js.translate.reference.CallExpressionTranslator;
import org.jetbrains.kotlin.js.translate.utils.InlineUtils;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;
import org.jetbrains.kotlin.js.translate.utils.UtilsKt;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.resolve.calls.callResolverUtil.CallResolverUtilKt;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.VariableAsFunctionResolvedCall;
import org.jetbrains.kotlin.resolve.calls.tasks.ExplicitReceiverKind;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=2, d1={"\u00008\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a&\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u000e\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u0005\u001a(\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u00022\u000e\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u0005H\u0002\u001a8\u0010\r\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u00022\u000e\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\b2\u000e\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\b2\u0006\u0010\n\u001a\u00020\u0005H\u0002\u001a\u0014\u0010\u0010\u001a\u00020\u0001*\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\bH\u0002\u001a\u0012\u0010\u0011\u001a\u00020\u0012*\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\b\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0000\u0010\u0003\u00a8\u0006\u0013"}, d2={"isInStateMachine", "", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "(Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;)Z", "computeExplicitReceiversForInvoke", "Lorg/jetbrains/kotlin/js/translate/callTranslator/ExplicitReceivers;", "context", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "explicitReceivers", "translateCall", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "translateFunctionCall", "inlineResolvedCall", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "expectedReceivers", "getReturnType", "Lorg/jetbrains/kotlin/types/KotlinType;", "js.translator"})
public final class CallTranslatorKt {
    private static final boolean expectedReceivers(@NotNull ResolvedCall<? extends CallableDescriptor> $receiver) {
        return Intrinsics.areEqual((Object)$receiver.getExplicitReceiverKind(), (Object)ExplicitReceiverKind.NO_EXPLICIT_RECEIVER) ^ true;
    }

    private static final JsExpression translateCall(TranslationContext context, ResolvedCall<? extends FunctionDescriptor> resolvedCall2, ExplicitReceivers explicitReceivers) {
        if (resolvedCall2 instanceof VariableAsFunctionResolvedCall) {
            JsExpression jsExpression;
            boolean bl;
            boolean bl2 = bl = explicitReceivers.getExtensionReceiver() == null;
            if (_Assertions.ENABLED && !bl) {
                String string = "VariableAsFunctionResolvedCall must have one receiver";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            ResolvedCall<VariableDescriptor> variableCall = ((VariableAsFunctionResolvedCall)((Object)resolvedCall2)).getVariableCall();
            if (CallTranslatorKt.expectedReceivers(variableCall)) {
                JsExpression newReceiver = CallTranslator.INSTANCE.translateGet(context, variableCall, explicitReceivers.getExtensionOrDispatchReceiver());
                jsExpression = CallTranslatorKt.translateFunctionCall(context, ((VariableAsFunctionResolvedCall)((Object)resolvedCall2)).getFunctionCall(), ((VariableAsFunctionResolvedCall)((Object)resolvedCall2)).getVariableCall(), new ExplicitReceivers(newReceiver, null, 2, null));
            } else {
                JsExpression dispatchReceiver = CallTranslator.INSTANCE.translateGet(context, variableCall, null);
                boolean isFunctionType = FunctionTypesKt.isFunctionTypeOrSubtype(((VariableAsFunctionResolvedCall)((Object)resolvedCall2)).getVariableCall().getResultingDescriptor().getType());
                ResolvedCall<? extends FunctionDescriptor> inlineCall2 = isFunctionType ? ((VariableAsFunctionResolvedCall)((Object)resolvedCall2)).getVariableCall() : resolvedCall2;
                jsExpression = explicitReceivers.getExtensionOrDispatchReceiver() == null ? CallTranslatorKt.translateFunctionCall(context, ((VariableAsFunctionResolvedCall)((Object)resolvedCall2)).getFunctionCall(), inlineCall2, new ExplicitReceivers(dispatchReceiver, null, 2, null)) : CallTranslatorKt.translateFunctionCall(context, ((VariableAsFunctionResolvedCall)((Object)resolvedCall2)).getFunctionCall(), inlineCall2, new ExplicitReceivers(dispatchReceiver, explicitReceivers.getExtensionOrDispatchReceiver()));
            }
            JsExpression result2 = jsExpression;
            return result2;
        }
        Call call2 = resolvedCall2.getCall();
        if (Intrinsics.areEqual((Object)call2.getCallType(), (Object)Call.CallType.INVOKE)) {
            Call call3 = call2;
            Intrinsics.checkExpressionValueIsNotNull(call3, "call");
            if (!CallResolverUtilKt.isInvokeCallOnVariable(call3)) {
                ExplicitReceivers explicitReceiversForInvoke = CallTranslatorKt.computeExplicitReceiversForInvoke(context, resolvedCall2, explicitReceivers);
                return CallTranslatorKt.translateFunctionCall(context, resolvedCall2, resolvedCall2, explicitReceiversForInvoke);
            }
        }
        return CallTranslatorKt.translateFunctionCall(context, resolvedCall2, resolvedCall2, explicitReceivers);
    }

    private static final JsExpression translateFunctionCall(TranslationContext context, ResolvedCall<? extends FunctionDescriptor> resolvedCall2, ResolvedCall<? extends CallableDescriptor> inlineResolvedCall, ExplicitReceivers explicitReceivers) {
        JsExpression callExpression = FunctionCallCasesKt.translateFunctionCall(CallInfoKt.getCallInfo(context, resolvedCall2, explicitReceivers));
        if (CallExpressionTranslator.shouldBeInlined(inlineResolvedCall.getResultingDescriptor(), context)) {
            KtElement ktElement = resolvedCall2.getCall().getCallElement();
            if (ktElement == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
            }
            InlineUtils.setInlineCallMetadata(callExpression, (KtExpression)ktElement, inlineResolvedCall.getResultingDescriptor(), context);
        }
        if (resolvedCall2.getResultingDescriptor().isSuspend()) {
            if (CallTranslatorKt.isInStateMachine(context)) {
                JsNode jsNode;
                Collection collection = context.getCurrentBlock().getStatements();
                JsExpression $receiver = jsNode = callExpression;
                MetadataProperties.setSuspend($receiver, true);
                $receiver.setSource(resolvedCall2.getCall().getCallElement());
                jsNode = JsAstUtils.asSyntheticStatement(jsNode);
                collection.add(jsNode);
                $receiver = jsNode = TranslationUtils.translateContinuationArgument(context);
                $receiver.setSource(resolvedCall2.getCall().getCallElement());
                JsNode coroutineRef = jsNode;
                jsNode = new JsNameRef("$$coroutineResult$$", (JsExpression)coroutineRef);
                TranslationContext translationContext = context;
                $receiver = jsNode;
                MetadataProperties.setSideEffects($receiver, SideEffectKind.DEPENDS_ON_STATE);
                $receiver.setSource(resolvedCall2.getCall().getCallElement());
                MetadataProperties.setCoroutineResult((JsNameRef)$receiver, true);
                JsNode jsNode2 = jsNode;
                JsExpression jsExpression = translationContext.defineTemporary((JsExpression)jsNode2);
                Intrinsics.checkExpressionValueIsNotNull(jsExpression, "context.defineTemporary(\u2026ult = true\n            })");
                return jsExpression;
            }
            MetadataProperties.setTailCallSuspend(callExpression, true);
        }
        KotlinType kotlinType = CallTranslatorKt.getReturnType(resolvedCall2);
        JsExpression jsExpression = callExpression;
        KotlinType it = kotlinType;
        KotlinType kotlinType2 = CallUtilKt.isSafeCall(resolvedCall2.getCall()) ? TypeUtilsKt.makeNullable(it) : it;
        MetadataProperties.setType(jsExpression, kotlinType2);
        return callExpression;
    }

    @NotNull
    public static final KotlinType getReturnType(@NotNull ResolvedCall<? extends CallableDescriptor> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        KotlinType kotlinType = TranslationUtils.getReturnTypeForCoercion($receiver.getResultingDescriptor());
        Intrinsics.checkExpressionValueIsNotNull(kotlinType, "TranslationUtils.getRetu\u2026cion(resultingDescriptor)");
        return kotlinType;
    }

    private static final boolean isInStateMachine(@NotNull TranslationContext $receiver) {
        DeclarationDescriptor declarationDescriptor = $receiver.getDeclarationDescriptor();
        if (!(declarationDescriptor instanceof FunctionDescriptor)) {
            declarationDescriptor = null;
        }
        FunctionDescriptor functionDescriptor = (FunctionDescriptor)declarationDescriptor;
        return functionDescriptor != null && UtilsKt.requiresStateMachineTransformation(functionDescriptor, $receiver);
    }

    @NotNull
    public static final ExplicitReceivers computeExplicitReceiversForInvoke(@NotNull TranslationContext context, @NotNull ResolvedCall<? extends FunctionDescriptor> resolvedCall2, @NotNull ExplicitReceivers explicitReceivers) {
        ExplicitReceivers explicitReceivers2;
        boolean bl;
        Intrinsics.checkParameterIsNotNull(context, "context");
        Intrinsics.checkParameterIsNotNull(resolvedCall2, "resolvedCall");
        Intrinsics.checkParameterIsNotNull(explicitReceivers, "explicitReceivers");
        KtElement callElement = resolvedCall2.getCall().getCallElement();
        boolean bl2 = bl = explicitReceivers.getExtensionReceiver() == null;
        if (_Assertions.ENABLED && !bl) {
            String string = "'Invoke' call must have one receiver: " + callElement;
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        Function1<ReceiverValue, JsExpression> translateReceiverAsExpression$ = new Function1<ReceiverValue, JsExpression>(context){
            final /* synthetic */ TranslationContext $context;

            @Nullable
            public final JsExpression invoke(@Nullable ReceiverValue receiver) {
                JsExpression jsExpression;
                ReceiverValue receiverValue = receiver;
                if (!(receiverValue instanceof ExpressionReceiver)) {
                    receiverValue = null;
                }
                ExpressionReceiver expressionReceiver = (ExpressionReceiver)receiverValue;
                if (expressionReceiver != null) {
                    ExpressionReceiver expressionReceiver2;
                    ExpressionReceiver it = expressionReceiver2 = expressionReceiver;
                    jsExpression = Translation.translateAsExpression(it.getExpression(), this.$context);
                } else {
                    jsExpression = null;
                }
                return jsExpression;
            }
            {
                this.$context = translationContext;
                super(1);
            }
        };
        ReceiverValue dispatchReceiver = resolvedCall2.getDispatchReceiver();
        ReceiverValue extensionReceiver = resolvedCall2.getExtensionReceiver();
        if (dispatchReceiver != null && extensionReceiver != null && Intrinsics.areEqual((Object)resolvedCall2.getExplicitReceiverKind(), (Object)ExplicitReceiverKind.BOTH_RECEIVERS)) {
            boolean bl3;
            boolean bl4 = bl3 = explicitReceivers.getExtensionOrDispatchReceiver() != null;
            if (_Assertions.ENABLED && !bl3) {
                String string = "No explicit receiver for 'invoke' resolved call with both receivers: " + callElement + ", text: " + callElement.getText() + "Dispatch receiver: " + dispatchReceiver + " Extension receiver: " + extensionReceiver;
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
        } else {
            boolean bl5;
            boolean bl6 = bl5 = explicitReceivers.getExtensionOrDispatchReceiver() == null;
            if (_Assertions.ENABLED && !bl5) {
                String string = "Non trivial explicit receiver " + explicitReceivers.getExtensionOrDispatchReceiver() + '\n' + "for 'invoke' resolved call: " + callElement + ", text: " + callElement.getText() + '\n' + "Dispatch receiver: " + dispatchReceiver + " Extension receiver: " + extensionReceiver;
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
        }
        switch (CallTranslatorKt$WhenMappings.$EnumSwitchMapping$0[resolvedCall2.getExplicitReceiverKind().ordinal()]) {
            case 1: {
                explicitReceivers2 = new ExplicitReceivers(null, null, 2, null);
                break;
            }
            case 2: {
                explicitReceivers2 = new ExplicitReceivers(translateReceiverAsExpression$.invoke(dispatchReceiver), null, 2, null);
                break;
            }
            case 3: {
                explicitReceivers2 = new ExplicitReceivers(translateReceiverAsExpression$.invoke(extensionReceiver), null, 2, null);
                break;
            }
            case 4: {
                explicitReceivers2 = new ExplicitReceivers(translateReceiverAsExpression$.invoke(dispatchReceiver), translateReceiverAsExpression$.invoke(extensionReceiver));
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return explicitReceivers2;
    }

    @NotNull
    public static final /* synthetic */ JsExpression access$translateCall(@NotNull TranslationContext context, @NotNull ResolvedCall resolvedCall2, @NotNull ExplicitReceivers explicitReceivers) {
        return CallTranslatorKt.translateCall(context, resolvedCall2, explicitReceivers);
    }
}

