/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.utils.mutator;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsCatch;
import org.jetbrains.kotlin.js.backend.ast.JsExpressionStatement;
import org.jetbrains.kotlin.js.backend.ast.JsIf;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsTry;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.mutator.Mutator;

public final class LastExpressionMutator {
    @NotNull
    private final Mutator mutator;

    public static JsStatement mutateLastExpression(@NotNull JsNode node, @NotNull Mutator mutator) {
        return JsAstUtils.convertToStatement(new LastExpressionMutator(mutator).apply(node));
    }

    private LastExpressionMutator(@NotNull Mutator mutator) {
        this.mutator = mutator;
    }

    @NotNull
    private JsNode apply(@NotNull JsNode node) {
        if (node instanceof JsBlock) {
            return this.applyToBlock((JsBlock)node);
        }
        if (node instanceof JsIf) {
            return this.applyToIf((JsIf)node);
        }
        if (node instanceof JsTry) {
            return this.applyToTry((JsTry)node);
        }
        if (node instanceof JsExpressionStatement) {
            return this.applyToStatement((JsExpressionStatement)node);
        }
        return this.mutator.mutate(node);
    }

    @NotNull
    private JsNode applyToStatement(@NotNull JsExpressionStatement node) {
        return JsAstUtils.convertToStatement(this.apply(node.getExpression()));
    }

    @NotNull
    private JsNode applyToIf(@NotNull JsIf node) {
        node.setThenStatement(JsAstUtils.convertToStatement(this.apply(node.getThenStatement())));
        JsStatement elseStmt = node.getElseStatement();
        if (elseStmt != null) {
            node.setElseStatement(JsAstUtils.convertToStatement(this.apply(elseStmt)));
        }
        return node;
    }

    @NotNull
    private JsNode applyToTry(@NotNull JsTry node) {
        this.applyToBlock(node.getTryBlock());
        for (JsCatch jsCatch : node.getCatches()) {
            this.applyToBlock(jsCatch.getBody());
        }
        return node;
    }

    @NotNull
    private JsNode applyToBlock(@NotNull JsBlock node) {
        List<JsStatement> statements = node.getStatements();
        if (statements.isEmpty()) {
            return node;
        }
        int size = statements.size();
        statements.set(size - 1, JsAstUtils.convertToStatement(this.apply(statements.get(size - 1))));
        return node;
    }
}

