/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.kdoc.parser;

import com.intellij.lang.ASTNode;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiBuilderFactory;
import com.intellij.lang.PsiParser;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.kdoc.parser.KDocElementTypes;
import org.jetbrains.kotlin.lexer.KotlinLexer;
import org.jetbrains.kotlin.lexer.KtTokens;

@Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/kdoc/parser/KDocLinkParser;", "Lcom/intellij/lang/PsiParser;", "()V", "isName", "", "tokenType", "Lcom/intellij/psi/tree/IElementType;", "parse", "Lcom/intellij/lang/ASTNode;", "root", "builder", "Lcom/intellij/lang/PsiBuilder;", "parseQualifiedName", "", "Companion", "frontend"})
public final class KDocLinkParser
implements PsiParser {
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public ASTNode parse(@NotNull IElementType root2, @NotNull PsiBuilder builder) {
        Intrinsics.checkParameterIsNotNull(root2, "root");
        Intrinsics.checkParameterIsNotNull(builder, "builder");
        PsiBuilder.Marker rootMarker = builder.mark();
        boolean hasLBracket = Intrinsics.areEqual(builder.getTokenType(), KtTokens.LBRACKET);
        if (hasLBracket) {
            builder.advanceLexer();
        }
        this.parseQualifiedName(builder);
        if (hasLBracket) {
            if (!builder.eof() && Intrinsics.areEqual(builder.getTokenType(), KtTokens.RBRACKET) ^ true) {
                builder.error("Closing bracket expected");
                while (!builder.eof() && Intrinsics.areEqual(builder.getTokenType(), KtTokens.RBRACKET) ^ true) {
                    builder.advanceLexer();
                }
            }
            if (Intrinsics.areEqual(builder.getTokenType(), KtTokens.RBRACKET)) {
                builder.advanceLexer();
            }
        } else if (!builder.eof()) {
            builder.error("Expression expected");
            while (!builder.eof()) {
                builder.advanceLexer();
            }
        }
        rootMarker.done(root2);
        ASTNode aSTNode = builder.getTreeBuilt();
        Intrinsics.checkExpressionValueIsNotNull(aSTNode, "builder.treeBuilt");
        return aSTNode;
    }

    private final void parseQualifiedName(PsiBuilder builder) {
        PsiBuilder.Marker marker = builder.mark();
        while (true) {
            if (!this.isName(builder.getTokenType())) {
                marker.drop();
                builder.error("Identifier expected");
                break;
            }
            builder.advanceLexer();
            marker.done(KDocElementTypes.KDOC_NAME);
            if (Intrinsics.areEqual(builder.getTokenType(), KtTokens.DOT) ^ true) break;
            marker = marker.precede();
            builder.advanceLexer();
        }
    }

    private final boolean isName(IElementType tokenType) {
        return Intrinsics.areEqual(tokenType, KtTokens.IDENTIFIER) || KtTokens.KEYWORDS.contains(tokenType);
    }

    @JvmStatic
    @NotNull
    public static final ASTNode parseMarkdownLink(@NotNull IElementType root2, @NotNull ASTNode chameleon) {
        Intrinsics.checkParameterIsNotNull(root2, "root");
        Intrinsics.checkParameterIsNotNull(chameleon, "chameleon");
        return Companion.parseMarkdownLink(root2, chameleon);
    }

    @Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004H\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/kdoc/parser/KDocLinkParser$Companion;", "", "()V", "parseMarkdownLink", "Lcom/intellij/lang/ASTNode;", "root", "Lcom/intellij/psi/tree/IElementType;", "chameleon", "frontend"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final ASTNode parseMarkdownLink(@NotNull IElementType root2, @NotNull ASTNode chameleon) {
            Intrinsics.checkParameterIsNotNull(root2, "root");
            Intrinsics.checkParameterIsNotNull(chameleon, "chameleon");
            PsiElement parentElement = chameleon.getTreeParent().getPsi();
            Project project = parentElement.getProject();
            PsiBuilder builder = PsiBuilderFactory.getInstance().createBuilder(project, chameleon, (Lexer)new KotlinLexer(), root2.getLanguage(), (CharSequence)chameleon.getText());
            KDocLinkParser parser = new KDocLinkParser();
            PsiBuilder psiBuilder = builder;
            Intrinsics.checkExpressionValueIsNotNull(psiBuilder, "builder");
            ASTNode aSTNode = parser.parse(root2, psiBuilder).getFirstChildNode();
            Intrinsics.checkExpressionValueIsNotNull(aSTNode, "parser.parse(root, builder).firstChildNode");
            return aSTNode;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

