// **********************************************************************
//
// Copyright (c) 2003-2017 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************
//
// Ice version 3.7.0
//
// <auto-generated>
//
// Generated from file `Router.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

package Glacier2;

/**
 * The Glacier2 specialization of the <tt>Ice::Router</tt> interface.
 *
 **/
public interface _RouterOperations extends Ice._RouterOperations
{
    /**
     * This category must be used in the identities of all of the client's
     * callback objects. This is necessary in order for the router to
     * forward callback requests to the intended client. If the Glacier2
     * server endpoints are not set, the returned category is an empty
     * string.
     *
     * @param current The Current object for the invocation.
     * @return The category.
     *
     **/
    String getCategoryForClient(Ice.Current current);

    /**
     * Create a per-client session with the router. If a
     * {@link SessionManager} has been installed, a proxy to a {@link Session}
     * object is returned to the client. Otherwise, null is returned
     * and only an internal session (i.e., not visible to the client)
     * is created.
     *
     * If a session proxy is returned, it must be configured to route
     * through the router that created it. This will happen automatically
     * if the router is configured as the client's default router at the
     * time the session proxy is created in the client process, otherwise
     * the client must configure the session proxy explicitly.
     *
     * @param cb The callback object for the operation.
     * @param userId The user id for which to check the password.
     *
     * @param password The password for the given user id.
     *
     * @param current The Current object for the invocation.
     * @throws PermissionDeniedException Raised if the password for
     * the given user id is not correct, or if the user is not allowed
     * access.
     *
     * @throws CannotCreateSessionException Raised if the session
     * cannot be created.
     *
     **/
    void createSession_async(AMD_Router_createSession cb, String userId, String password, Ice.Current current)
        throws CannotCreateSessionException,
               PermissionDeniedException;

    /**
     * Create a per-client session with the router. The user is
     * authenticated through the SSL certificates that have been
     * associated with the connection. If a {@link SessionManager} has been
     * installed, a proxy to a {@link Session} object is returned to the
     * client. Otherwise, null is returned and only an internal
     * session (i.e., not visible to the client) is created.
     *
     * If a session proxy is returned, it must be configured to route
     * through the router that created it. This will happen automatically
     * if the router is configured as the client's default router at the
     * time the session proxy is created in the client process, otherwise
     * the client must configure the session proxy explicitly.
     *
     * @param cb The callback object for the operation.
     * @param current The Current object for the invocation.
     * @throws PermissionDeniedException Raised if the user cannot be
     * authenticated or if the user is not allowed access.
     *
     * @throws CannotCreateSessionException Raised if the session
     * cannot be created.
     *
     **/
    void createSessionFromSecureConnection_async(AMD_Router_createSessionFromSecureConnection cb, Ice.Current current)
        throws CannotCreateSessionException,
               PermissionDeniedException;

    /**
     * Keep the calling client's session with this router alive.
     *
     * @param cb The callback object for the operation.
     * @param current The Current object for the invocation.
     * @throws SessionNotExistException Raised if no session exists
     * for the calling client.
     *
     **/
    void refreshSession_async(AMD_Router_refreshSession cb, Ice.Current current)
        throws SessionNotExistException;

    /**
     * Destroy the calling client's session with this router.
     *
     * @throws SessionNotExistException Raised if no session exists
     * for the calling client.
     *
     * @param current The Current object for the invocation.
     **/
    void destroySession(Ice.Current current)
        throws SessionNotExistException;

    /**
     * Get the value of the session timeout. Sessions are destroyed
     * if they see no activity for this period of time.
     *
     * @param current The Current object for the invocation.
     * @return The timeout (in seconds).
     *
     **/
    long getSessionTimeout(Ice.Current current);

    /**
     * Get the value of the ACM timeout. Clients supporting connection
     * heartbeats can enable them instead of explicitly sending keep
     * alives requests.
     *
     * NOTE: This method is only available since Ice 3.6.
     *
     * @param current The Current object for the invocation.
     * @return The timeout (in seconds).
     *
     **/
    int getACMTimeout(Ice.Current current);
}
