/*
 * Decompiled with CFR 0.152.
 */
package accessories.plugins;

import freemind.controller.MenuItemEnabledListener;
import freemind.controller.actions.generated.instance.ChangeRootNodeAction;
import freemind.controller.actions.generated.instance.XmlAction;
import freemind.extensions.HookRegistration;
import freemind.main.Tools;
import freemind.modes.MindMap;
import freemind.modes.MindMapNode;
import freemind.modes.ModeController;
import freemind.modes.NodeAdapter;
import freemind.modes.mindmapmode.MindMapController;
import freemind.modes.mindmapmode.actions.xml.ActionPair;
import freemind.modes.mindmapmode.actions.xml.ActorXml;
import freemind.modes.mindmapmode.hooks.MindMapNodeHookAdapter;
import freemind.view.mindmapview.MapView;
import freemind.view.mindmapview.NodeMotionListenerView;
import freemind.view.mindmapview.NodeView;
import java.awt.Component;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JMenuItem;

public class ChangeRootNode
extends MindMapNodeHookAdapter {
    private static final String TRANSACTION_NAME = "ChangeRootNode";

    @Override
    public void invoke(MindMapNode node) {
        MindMapNode focussed = this.getMindMapController().getSelected();
        MindMapNode rootNode = this.getMindMapController().getRootNode();
        this.getMindMapController().doTransaction(TRANSACTION_NAME, new ActionPair(this.getAction(focussed), this.getAction(rootNode)));
    }

    private XmlAction getAction(MindMapNode pNode) {
        ChangeRootNodeAction action = new ChangeRootNodeAction();
        action.setNode(this.getMindMapController().getNodeID(pNode));
        return action;
    }

    public static class Registration
    implements HookRegistration,
    MenuItemEnabledListener,
    ActorXml {
        private final MindMapController controller;
        private final MindMap mMap;
        private final Logger logger;

        public Registration(ModeController controller, MindMap map) {
            this.controller = (MindMapController)controller;
            this.mMap = map;
            this.logger = controller.getFrame().getLogger(this.getClass().getName());
        }

        @Override
        public boolean isEnabled(JMenuItem pItem, Action pAction) {
            return this.controller.getSelecteds().size() == 1;
        }

        @Override
        public void register() {
            this.controller.getActionFactory().registerActor(this, this.getDoActionClass());
        }

        @Override
        public void deRegister() {
            this.controller.getActionFactory().deregisterActor(this.getDoActionClass());
        }

        @Override
        public void act(XmlAction pAction) {
            if (pAction instanceof ChangeRootNodeAction) {
                ChangeRootNodeAction rootNodeAction = (ChangeRootNodeAction)pAction;
                NodeAdapter focussed = this.controller.getNodeFromID(rootNodeAction.getNode());
                if (focussed.isRoot()) {
                    return;
                }
                MindMapNode oldRoot = this.mMap.getRootNode();
                oldRoot.removeAllHooks();
                this.mMap.changeRoot(focussed);
                Vector<NodeAdapter> nodes = new Vector<NodeAdapter>();
                nodes.add(focussed);
                while (!nodes.isEmpty()) {
                    MindMapNode child = (MindMapNode)nodes.firstElement();
                    this.logger.fine("Removing viewers for " + child);
                    nodes.remove(0);
                    nodes.addAll(child.getChildren());
                    Vector viewers = new Vector(child.getViewers());
                    for (NodeView viewer : viewers) {
                        child.removeViewer(viewer);
                    }
                }
                MapView mapView = this.controller.getView();
                for (int i = mapView.getComponentCount() - 1; i >= 0; --i) {
                    Component comp = mapView.getComponent(i);
                    if (!(comp instanceof NodeView) && !(comp instanceof NodeMotionListenerView)) continue;
                    mapView.remove(comp);
                }
                mapView.initRoot();
                mapView.add(mapView.getRoot());
                mapView.doLayout();
                this.controller.nodeChanged(focussed);
                this.logger.fine("layout done.");
                this.controller.select(focussed, Tools.getVectorWithSingleElement(focussed));
                this.controller.centerNode(focussed);
                this.controller.obtainFocusForSelected();
            }
        }

        @Override
        public Class getDoActionClass() {
            return ChangeRootNodeAction.class;
        }
    }
}

