/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source;

import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.util.TextRange;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiIdentifier;
import org.jetbrains.kotlin.com.intellij.psi.PsiLabeledStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiReference;
import org.jetbrains.kotlin.com.intellij.psi.PsiStatement;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiImplUtil;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtil;
import org.jetbrains.kotlin.com.intellij.util.IncorrectOperationException;

public class PsiLabelReference
implements PsiReference {
    private final PsiStatement myStatement;
    private PsiIdentifier myIdentifier;

    public PsiLabelReference(PsiStatement stat, PsiIdentifier identifier) {
        this.myStatement = stat;
        this.myIdentifier = identifier;
    }

    @Override
    public PsiElement getElement() {
        return this.myStatement;
    }

    @Override
    public TextRange getRangeInElement() {
        int parent2 = this.myIdentifier.getStartOffsetInParent();
        return new TextRange(parent2, this.myIdentifier.getTextLength() + parent2);
    }

    @Override
    public PsiElement resolve() {
        String label = this.myIdentifier.getText();
        if (label == null) {
            return null;
        }
        for (PsiElement context = this.myStatement; context != null; context = context.getContext()) {
            PsiLabeledStatement statement2;
            if (!(context instanceof PsiLabeledStatement) || !label.equals((statement2 = (PsiLabeledStatement)context).getName())) continue;
            return statement2;
        }
        return null;
    }

    @Override
    @NotNull
    public String getCanonicalText() {
        String string = this.getElement().getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiLabelReference", "getCanonicalText"));
        }
        return string;
    }

    @Override
    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        this.myIdentifier = (PsiIdentifier)PsiImplUtil.setName(this.myIdentifier, newElementName);
        return this.myIdentifier;
    }

    @Override
    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiLabelReference", "bindToElement"));
        }
        if (element instanceof PsiLabeledStatement) {
            this.myIdentifier = (PsiIdentifier)PsiImplUtil.setName(this.myIdentifier, ((PsiLabeledStatement)element).getName());
            return this.myIdentifier;
        }
        throw new IncorrectOperationException("Can't bind not to labeled statement");
    }

    @Override
    public boolean isReferenceTo(PsiElement element) {
        return this.resolve() == element;
    }

    @NotNull
    public String[] getVariants() {
        ArrayList<String> result2 = new ArrayList<String>();
        for (PsiElement context = this.myStatement; context != null; context = context.getContext()) {
            if (!(context instanceof PsiLabeledStatement)) continue;
            result2.add(((PsiLabeledStatement)context).getName());
        }
        String[] stringArray = ArrayUtil.toStringArray(result2);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiLabelReference", "getVariants"));
        }
        return stringArray;
    }

    @Override
    public boolean isSoft() {
        return false;
    }
}

