/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.local;

import java.io.File;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.Transformer;
import org.gradle.api.internal.file.TemporaryFileProvider;
import org.gradle.internal.hash.HashUtil;
import org.gradle.internal.resource.local.FileStore;
import org.gradle.internal.resource.local.FileStoreSearcher;
import org.gradle.internal.resource.local.LocallyAvailableResource;
import org.gradle.internal.resource.local.PathKeyFileStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupedAndNamedUniqueFileStore<K>
implements FileStore<K>,
FileStoreSearcher<K> {
    private PathKeyFileStore delegate;
    private final TemporaryFileProvider temporaryFileProvider;
    private final Transformer<String, K> grouper;
    private final Transformer<String, K> namer;

    public GroupedAndNamedUniqueFileStore(PathKeyFileStore delegate, TemporaryFileProvider temporaryFileProvider, Transformer<String, K> grouper, Transformer<String, K> namer) {
        this.delegate = delegate;
        this.temporaryFileProvider = temporaryFileProvider;
        this.grouper = grouper;
        this.namer = namer;
    }

    public LocallyAvailableResource move(K key, File source) {
        return this.delegate.move((Object)this.toPath(key, this.getChecksum(source)), source);
    }

    public LocallyAvailableResource copy(K key, File source) {
        return this.delegate.copy((Object)this.toPath(key, this.getChecksum(source)), source);
    }

    public Set<? extends LocallyAvailableResource> search(K key) {
        return this.delegate.search((Object)this.toPath(key, "*"));
    }

    protected String toPath(K key, String checksumPart) {
        String group = (String)this.grouper.transform(key);
        String name = (String)this.namer.transform(key);
        return group + "/" + checksumPart + "/" + name;
    }

    private String getChecksum(File contentFile) {
        return HashUtil.createHash((File)contentFile, (String)"SHA1").asHexString();
    }

    public File getTempFile() {
        return this.temporaryFileProvider.createTemporaryFile("filestore", "bin", new String[0]);
    }

    public void moveFilestore(File destination) {
        this.delegate.moveFilestore(destination);
    }

    public LocallyAvailableResource add(K key, Action<File> addAction) {
        File tempFile = this.getTempFile();
        addAction.execute((Object)tempFile);
        String groupedAndNamedKey = this.toPath(key, this.getChecksum(tempFile));
        return this.delegate.move((Object)groupedAndNamedKey, tempFile);
    }
}

