/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.nativeplatform.internal.incremental;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.internal.hash.FileHasher;
import org.gradle.internal.hash.HashCode;
import org.gradle.language.nativeplatform.internal.IncludeDirectives;
import org.gradle.language.nativeplatform.internal.incremental.BuildableCompilationState;
import org.gradle.language.nativeplatform.internal.incremental.CompilationFileState;
import org.gradle.language.nativeplatform.internal.incremental.CompilationState;
import org.gradle.language.nativeplatform.internal.incremental.IncrementalCompileFiles;
import org.gradle.language.nativeplatform.internal.incremental.ResolvedInclude;
import org.gradle.language.nativeplatform.internal.incremental.SourceIncludesParser;
import org.gradle.language.nativeplatform.internal.incremental.SourceIncludesResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IncrementalCompileFilesFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(IncrementalCompileFilesFactory.class);
    private final SourceIncludesParser sourceIncludesParser;
    private final SourceIncludesResolver sourceIncludesResolver;
    private final FileHasher hasher;

    public IncrementalCompileFilesFactory(SourceIncludesParser sourceIncludesParser, SourceIncludesResolver sourceIncludesResolver, FileHasher hasher) {
        this.sourceIncludesParser = sourceIncludesParser;
        this.sourceIncludesResolver = sourceIncludesResolver;
        this.hasher = hasher;
    }

    public IncrementalCompileFiles filesFor(CompilationState previousCompileState) {
        return new DefaultIncrementalCompileFiles(previousCompileState);
    }

    private class DefaultIncrementalCompileFiles
    implements IncrementalCompileFiles {
        private final CompilationState previous;
        private final BuildableCompilationState current = new BuildableCompilationState();
        private final Map<File, Boolean> processed = new HashMap<File, Boolean>();
        private final List<File> toRecompile = new ArrayList<File>();
        private final Set<File> discoveredInputs = Sets.newHashSet();
        private boolean sourceFilesUseMacroIncludes;

        @Override
        public CompilationState getCurrent() {
            return this.current.snapshot();
        }

        public DefaultIncrementalCompileFiles(CompilationState previousCompileState) {
            this.previous = previousCompileState == null ? new CompilationState() : previousCompileState;
        }

        @Override
        public void processSource(File sourceFile) {
            this.current.addSourceInput(sourceFile);
            if (this.checkChangedAndUpdateState(sourceFile) || !this.previous.getSourceInputs().contains((Object)sourceFile)) {
                this.toRecompile.add(sourceFile);
            }
        }

        public boolean checkChangedAndUpdateState(File file) {
            IncludeDirectives includeDirectives;
            boolean changed = false;
            if (this.processed.containsKey(file)) {
                return this.processed.get(file);
            }
            if (!file.exists()) {
                return true;
            }
            this.processed.put(file, false);
            CompilationFileState previousState = this.previous.getState(file);
            HashCode newHash = IncrementalCompileFilesFactory.this.hasher.hash(file);
            if (!this.sameHash(previousState, newHash)) {
                changed = true;
                includeDirectives = IncrementalCompileFilesFactory.this.sourceIncludesParser.parseIncludes(file);
            } else {
                includeDirectives = previousState.getIncludeDirectives();
            }
            SourceIncludesResolver.ResolvedSourceIncludes resolutionResult = this.resolveIncludes(file, includeDirectives);
            CompilationFileState newState = new CompilationFileState(newHash, includeDirectives, (ImmutableSet<ResolvedInclude>)ImmutableSet.copyOf(resolutionResult.getResolvedIncludes()));
            for (ResolvedInclude resolvedInclude : resolutionResult.getResolvedIncludes()) {
                if (!resolvedInclude.isMaybeMacro()) continue;
                this.sourceFilesUseMacroIncludes = true;
            }
            this.discoveredInputs.addAll(resolutionResult.getCheckedLocations());
            if (!this.sameResolved(previousState, newState)) {
                changed = true;
            }
            this.current.setState(file, newState);
            for (ResolvedInclude dep : newState.getResolvedIncludes()) {
                if (dep.isUnknown()) {
                    LOGGER.info("Cannot determine changed state of included '{}' in source file '{}'. Assuming changed.", (Object)dep.getInclude(), (Object)file.getName());
                    changed = true;
                    continue;
                }
                boolean depChanged = this.checkChangedAndUpdateState(dep.getFile());
                changed = changed || depChanged;
            }
            this.processed.put(file, changed);
            return changed;
        }

        private boolean sameHash(CompilationFileState previousState, HashCode newHash) {
            return previousState != null && newHash.equals((Object)previousState.getHash());
        }

        private boolean sameResolved(CompilationFileState previousState, CompilationFileState newState) {
            return previousState != null && newState.getResolvedIncludes().equals(previousState.getResolvedIncludes());
        }

        private SourceIncludesResolver.ResolvedSourceIncludes resolveIncludes(File file, IncludeDirectives includeDirectives) {
            return IncrementalCompileFilesFactory.this.sourceIncludesResolver.resolveIncludes(file, includeDirectives);
        }

        @Override
        public List<File> getModifiedSources() {
            return this.toRecompile;
        }

        @Override
        public List<File> getRemovedSources() {
            ArrayList<File> removed = new ArrayList<File>();
            for (File previousSource : this.previous.getSourceInputs()) {
                if (this.current.getSourceInputs().contains(previousSource)) continue;
                removed.add(previousSource);
            }
            return removed;
        }

        @Override
        public Set<File> getDiscoveredInputs() {
            return this.discoveredInputs;
        }

        @Override
        public boolean isSourceFilesUseMacroIncludes() {
            return this.sourceFilesUseMacroIncludes;
        }
    }
}

