/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.recomp;

import java.io.File;
import java.util.Collection;
import java.util.LinkedHashSet;

public class RecompilationSpec {
    private final Collection<String> classesToCompile = new NormalizingClassNamesSet();
    private String fullRebuildCause;

    public Collection<String> getClassNames() {
        return this.classesToCompile;
    }

    public boolean isFullRebuildNeeded() {
        return this.fullRebuildCause != null;
    }

    public String getFullRebuildCause() {
        return this.fullRebuildCause;
    }

    public void setFullRebuildCause(String description, File file) {
        this.fullRebuildCause = description != null ? description : "'" + file.getName() + "' was changed";
    }

    private static class NormalizingClassNamesSet
    extends LinkedHashSet<String> {
        private NormalizingClassNamesSet() {
        }

        @Override
        public boolean add(String className) {
            int idx = className.indexOf(36);
            if (idx > 0) {
                className = className.substring(0, idx);
            }
            return super.add(className);
        }

        @Override
        public boolean addAll(Collection<? extends String> classNames) {
            boolean added = false;
            for (String string : classNames) {
                added |= this.add(string);
            }
            return added;
        }
    }
}

