/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.io.File;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Date;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.actions.RenameLayerAction;
import org.openstreetmap.josm.actions.SaveActionBase;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.SystemOfMeasurement;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.data.gpx.GpxTrack;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.data.preferences.NamedColorProperty;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.dialogs.LayerListPopup;
import org.openstreetmap.josm.gui.io.importexport.GpxImporter;
import org.openstreetmap.josm.gui.layer.CustomizeColor;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.LayerPositionStrategy;
import org.openstreetmap.josm.gui.layer.MapViewPaintable;
import org.openstreetmap.josm.gui.layer.gpx.ChooseTrackVisibilityAction;
import org.openstreetmap.josm.gui.layer.gpx.ConvertToDataLayerAction;
import org.openstreetmap.josm.gui.layer.gpx.CustomizeDrawingAction;
import org.openstreetmap.josm.gui.layer.gpx.DownloadAlongTrackAction;
import org.openstreetmap.josm.gui.layer.gpx.DownloadWmsAlongTrackAction;
import org.openstreetmap.josm.gui.layer.gpx.GpxDrawHelper;
import org.openstreetmap.josm.gui.layer.gpx.ImportAudioAction;
import org.openstreetmap.josm.gui.layer.gpx.ImportImagesAction;
import org.openstreetmap.josm.gui.layer.gpx.MarkersFromNamedPointsAction;
import org.openstreetmap.josm.gui.widgets.HtmlPanel;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.date.DateUtils;

public class GpxLayer
extends Layer {
    public GpxData data;
    private final boolean isLocalFile;
    public boolean[] trackVisibility = new boolean[0];
    private final GpxData.GpxDataChangeListener dataChangeListener = e -> this.invalidate();

    public GpxLayer(GpxData d) {
        this(d, null, false);
    }

    public GpxLayer(GpxData d, String name) {
        this(d, name, false);
    }

    public GpxLayer(GpxData d, String name, boolean isLocal) {
        super(d.getString("meta.name"));
        this.data = d;
        this.data.addWeakChangeListener(this.dataChangeListener);
        this.trackVisibility = new boolean[this.data.getTracks().size()];
        Arrays.fill(this.trackVisibility, true);
        this.setName(name);
        this.isLocalFile = isLocal;
    }

    @Override
    protected NamedColorProperty getBaseColorProperty() {
        return GpxDrawHelper.DEFAULT_COLOR;
    }

    public static String getTimespanForTrack(GpxTrack trk) {
        Date[] bounds = GpxData.getMinMaxTimeForTrack(trk);
        String ts = "";
        if (bounds != null) {
            String latestDate;
            DateFormat df = DateUtils.getDateFormat(3);
            String earliestDate = df.format(bounds[0]);
            if (earliestDate.equals(latestDate = df.format(bounds[1]))) {
                DateFormat tf = DateUtils.getTimeFormat(3);
                ts = ts + earliestDate + ' ';
                ts = ts + tf.format(bounds[0]) + " - " + tf.format(bounds[1]);
            } else {
                DateFormat dtf = DateUtils.getDateTimeFormat(3, 2);
                ts = ts + dtf.format(bounds[0]) + " - " + dtf.format(bounds[1]);
            }
            int diff = (int)(bounds[1].getTime() - bounds[0].getTime()) / 1000;
            ts = ts + String.format(" (%d:%02d)", diff / 3600, diff % 3600 / 60);
        }
        return ts;
    }

    @Override
    public Icon getIcon() {
        return ImageProvider.get("layer", "gpx_small");
    }

    @Override
    public Object getInfoComponent() {
        StringBuilder info = new StringBuilder(48).append("<html>");
        if (this.data.attr.containsKey("name")) {
            info.append(I18n.tr("Name: {0}", this.data.get("meta.name"))).append("<br>");
        }
        if (this.data.attr.containsKey("desc")) {
            info.append(I18n.tr("Description: {0}", this.data.get("meta.desc"))).append("<br>");
        }
        if (!this.data.getTracks().isEmpty()) {
            info.append("<table><thead align='center'><tr><td colspan='5'>").append(I18n.trn("{0} track", "{0} tracks", this.data.tracks.size(), this.data.tracks.size())).append("</td></tr><tr align='center'><td>").append(I18n.tr("Name", new Object[0])).append("</td><td>").append(I18n.tr("Description", new Object[0])).append("</td><td>").append(I18n.tr("Timespan", new Object[0])).append("</td><td>").append(I18n.tr("Length", new Object[0])).append("</td><td>").append(I18n.tr("URL", new Object[0])).append("</td></tr></thead>");
            for (GpxTrack trk : this.data.getTracks()) {
                info.append("<tr><td>");
                if (trk.getAttributes().containsKey("name")) {
                    info.append(trk.get("name"));
                }
                info.append("</td><td>");
                if (trk.getAttributes().containsKey("desc")) {
                    info.append(' ').append(trk.get("desc"));
                }
                info.append("</td><td>");
                info.append(GpxLayer.getTimespanForTrack(trk));
                info.append("</td><td>");
                info.append(SystemOfMeasurement.getSystemOfMeasurement().getDistText(trk.length()));
                info.append("</td><td>");
                if (trk.getAttributes().containsKey("url")) {
                    info.append(trk.get("url"));
                }
                info.append("</td></tr>");
            }
            info.append("</table><br><br>");
        }
        info.append(I18n.tr("Length: {0}", SystemOfMeasurement.getSystemOfMeasurement().getDistText(this.data.length()))).append("<br>").append(I18n.trn("{0} route, ", "{0} routes, ", this.data.getRoutes().size(), this.data.getRoutes().size())).append(I18n.trn("{0} waypoint", "{0} waypoints", this.data.getWaypoints().size(), this.data.getWaypoints().size())).append("<br></html>");
        JScrollPane sp = new JScrollPane(new HtmlPanel(info.toString()));
        sp.setPreferredSize(new Dimension(sp.getPreferredSize().width + 20, 370));
        SwingUtilities.invokeLater(() -> sp.getVerticalScrollBar().setValue(0));
        return sp;
    }

    @Override
    public boolean isInfoResizable() {
        return true;
    }

    @Override
    public Action[] getMenuEntries() {
        return new Action[]{LayerListDialog.getInstance().createShowHideLayerAction(), LayerListDialog.getInstance().createDeleteLayerAction(), LayerListDialog.getInstance().createMergeLayerAction(this), Layer.SeparatorLayerAction.INSTANCE, new Layer.LayerSaveAction(this), new Layer.LayerSaveAsAction(this), new CustomizeColor(this), new CustomizeDrawingAction(this), new ImportImagesAction(this), new ImportAudioAction(this), new MarkersFromNamedPointsAction(this), new ConvertToDataLayerAction.FromGpxLayer(this), new DownloadAlongTrackAction(this.data), new DownloadWmsAlongTrackAction(this.data), Layer.SeparatorLayerAction.INSTANCE, new ChooseTrackVisibilityAction(this), new RenameLayerAction(this.getAssociatedFile(), this), Layer.SeparatorLayerAction.INSTANCE, new LayerListPopup.InfoAction(this)};
    }

    public boolean isLocalFile() {
        return this.isLocalFile;
    }

    @Override
    public String getToolTipText() {
        StringBuilder info = new StringBuilder(48).append("<html>");
        if (this.data.attr.containsKey("meta.name")) {
            info.append(I18n.tr("Name: {0}", this.data.get("meta.name"))).append("<br>");
        }
        if (this.data.attr.containsKey("meta.desc")) {
            info.append(I18n.tr("Description: {0}", this.data.get("meta.desc"))).append("<br>");
        }
        info.append(I18n.trn("{0} track, ", "{0} tracks, ", this.data.getTracks().size(), this.data.getTracks().size())).append(I18n.trn("{0} route, ", "{0} routes, ", this.data.getRoutes().size(), this.data.getRoutes().size())).append(I18n.trn("{0} waypoint", "{0} waypoints", this.data.getWaypoints().size(), this.data.getWaypoints().size())).append("<br>").append(I18n.tr("Length: {0}", SystemOfMeasurement.getSystemOfMeasurement().getDistText(this.data.length()))).append("<br></html>");
        return info.toString();
    }

    @Override
    public boolean isMergable(Layer other) {
        return other instanceof GpxLayer;
    }

    public void filterTracksByDate(Date fromDate, Date toDate, boolean showWithoutDate) {
        int i = 0;
        long from = fromDate.getTime();
        long to = toDate.getTime();
        for (GpxTrack trk : this.data.getTracks()) {
            Date[] t = GpxData.getMinMaxTimeForTrack(trk);
            if (t == null) continue;
            long tm = t[1].getTime();
            this.trackVisibility[i] = tm == 0L && showWithoutDate || from <= tm && tm <= to;
            ++i;
        }
        this.invalidate();
    }

    @Override
    public void mergeFrom(Layer from) {
        if (!(from instanceof GpxLayer)) {
            throw new IllegalArgumentException("not a GpxLayer: " + from);
        }
        this.data.mergeFrom(((GpxLayer)from).data);
        this.invalidate();
    }

    @Override
    public void visitBoundingBox(BoundingXYVisitor v) {
        v.visit(this.data.recalculateBounds());
    }

    @Override
    public File getAssociatedFile() {
        return this.data.storageFile;
    }

    @Override
    public void setAssociatedFile(File file) {
        this.data.storageFile = file;
    }

    @Override
    public void projectionChanged(Projection oldValue, Projection newValue) {
        if (newValue == null) {
            return;
        }
        this.data.resetEastNorthCache();
    }

    @Override
    public boolean isSavable() {
        return true;
    }

    @Override
    public boolean checkSaveConditions() {
        return this.data != null;
    }

    @Override
    public File createAndOpenSaveFileChooser() {
        return SaveActionBase.createAndOpenSaveFileChooser(I18n.tr("Save GPX file", new Object[0]), GpxImporter.getFileFilter());
    }

    @Override
    public LayerPositionStrategy getDefaultLayerPosition() {
        return LayerPositionStrategy.AFTER_LAST_DATA_LAYER;
    }

    @Override
    public void paint(Graphics2D g, MapView mv, Bounds bbox) {
    }

    @Override
    protected MapViewPaintable.LayerPainter createMapViewPainter(MapViewPaintable.MapViewEvent event) {
        return new GpxDrawHelper(this);
    }
}

