/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress;

import com.intellij.openapi.progress.NonCancelableSection;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ProgressIndicatorProvider {
    public static ProgressIndicatorProvider getInstance() {
        return ProgressManager.getInstance();
    }

    public abstract ProgressIndicator getProgressIndicator();

    protected abstract void doCheckCanceled() throws ProcessCanceledException;

    @Nullable
    public static ProgressIndicator getGlobalProgressIndicator() {
        return ProgressIndicatorProvider.getInstance().getProgressIndicator();
    }

    @Deprecated
    @NotNull
    public abstract NonCancelableSection startNonCancelableSection();

    @Deprecated
    @NotNull
    public static NonCancelableSection startNonCancelableSectionIfSupported() {
        NonCancelableSection nonCancelableSection = ProgressIndicatorProvider.getInstance().startNonCancelableSection();
        if (nonCancelableSection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/progress/ProgressIndicatorProvider", "startNonCancelableSectionIfSupported"));
        }
        return nonCancelableSection;
    }

    public static void checkCanceled() throws ProcessCanceledException {
        ProgressManager.checkCanceled();
    }
}

