/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.optimization.fixStack;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.optimization.fixStack.SavedStackDescriptor;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.InsnList;
import org.jetbrains.org.objectweb.asm.tree.InsnNode;
import org.jetbrains.org.objectweb.asm.tree.JumpInsnNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.tree.VarInsnNode;
import org.jetbrains.org.objectweb.asm.tree.analysis.BasicValue;
import org.jetbrains.org.objectweb.asm.tree.analysis.Frame;
import org.jetbrains.org.objectweb.asm.tree.analysis.Value;

@Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=2, d1={"\u0000L\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010!\n\u0002\b\u0003\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u001e\u0010\b\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u001a\u0016\u0010\r\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u0005\u001a\u0016\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u0005\u001a,\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\f0\u0014\u001a\u001e\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a.\u0010\u0016\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u0012\u001a\u001e\u0010\u001a\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a)\u0010\u001b\u001a\u0004\u0018\u0001H\u001c\"\b\b\u0000\u0010\u001c*\u00020\u001d*\b\u0012\u0004\u0012\u0002H\u001c0\u001e2\u0006\u0010\u001f\u001a\u00020\u0012\u00a2\u0006\u0002\u0010 \u001a*\u0010!\u001a\n\u0012\u0004\u0012\u0002H\u001c\u0018\u00010\u0014\"\b\b\u0000\u0010\u001c*\u00020\u001d*\b\u0012\u0004\u0012\u0002H\u001c0\u001e2\u0006\u0010\"\u001a\u00020\u0012\u001a2\u0010!\u001a\n\u0012\u0004\u0012\u0002H\u001c\u0018\u00010\u0014\"\b\b\u0000\u0010\u001c*\u00020\u001d*\b\u0012\u0004\u0012\u0002H\u001c0\u001e2\u0006\u0010#\u001a\u00020\u00122\u0006\u0010$\u001a\u00020\u0012\u001a<\u0010%\u001a\u00020\u0012\"\b\b\u0000\u0010\u001c*\u00020\u001d*\b\u0012\u0004\u0012\u0002H\u001c0\u001e2\f\u0010&\u001a\b\u0012\u0004\u0012\u0002H\u001c0'2\u0006\u0010\"\u001a\u00020\u00122\b\b\u0002\u0010(\u001a\u00020\u0012H\u0002\u001a!\u0010\u000b\u001a\u0004\u0018\u0001H\u001c\"\b\b\u0000\u0010\u001c*\u00020\u001d*\b\u0012\u0004\u0012\u0002H\u001c0\u001e\u00a2\u0006\u0002\u0010)\u00a8\u0006*"}, d2={"generateLoadInstructions", "", "methodNode", "Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "location", "Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "savedStackDescriptor", "Lorg/jetbrains/kotlin/codegen/optimization/fixStack/SavedStackDescriptor;", "generateStoreInstructions", "getPopInstruction", "Lorg/jetbrains/org/objectweb/asm/tree/InsnNode;", "top", "Lorg/jetbrains/org/objectweb/asm/tree/analysis/BasicValue;", "removeAlwaysFalseIfeq", "node", "replaceAlwaysTrueIfeqWithGoto", "replaceMarkerWithPops", "expectedStackSize", "", "stackContent", "", "restoreStack", "restoreStackWithReturnValue", "nodeToReplace", "returnValue", "returnValueLocalVarIndex", "saveStack", "peek", "V", "Lorg/jetbrains/org/objectweb/asm/tree/analysis/Value;", "Lorg/jetbrains/org/objectweb/asm/tree/analysis/Frame;", "offset", "(Lorg/jetbrains/org/objectweb/asm/tree/analysis/Frame;I)Lorg/jetbrains/org/objectweb/asm/tree/analysis/Value;", "peekWords", "size", "size1", "size2", "peekWordsTo", "dest", "", "offset0", "(Lorg/jetbrains/org/objectweb/asm/tree/analysis/Frame;)Lorg/jetbrains/org/objectweb/asm/tree/analysis/Value;", "backend"})
public final class StackTransformationUtilsKt {
    @Nullable
    public static final <V extends Value> V top(@NotNull Frame<V> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return StackTransformationUtilsKt.peek($receiver, 0);
    }

    @Nullable
    public static final <V extends Value> V peek(@NotNull Frame<V> $receiver, int offset2) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return $receiver.getStackSize() > offset2 ? (V)$receiver.getStack($receiver.getStackSize() - offset2 - 1) : null;
    }

    private static final <V extends Value> int peekWordsTo(@NotNull Frame<V> $receiver, List<V> dest, int size, int offset0) {
        int totalSize;
        V value;
        int offset2 = offset0;
        for (totalSize = 0; totalSize < size; totalSize += value.getSize()) {
            if (StackTransformationUtilsKt.peek($receiver, offset2++) == null) {
                return -1;
            }
            dest.add(value);
        }
        if (totalSize > size) {
            return -1;
        }
        return offset2;
    }

    static /* bridge */ /* synthetic */ int peekWordsTo$default(Frame frame, List list2, int n, int n2, int n3, Object object) {
        if ((n3 & 4) != 0) {
            n2 = 0;
        }
        return StackTransformationUtilsKt.peekWordsTo(frame, list2, n, n2);
    }

    @Nullable
    public static final <V extends Value> List<V> peekWords(@NotNull Frame<V> $receiver, int size) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        ArrayList result2 = new ArrayList(size);
        return StackTransformationUtilsKt.peekWordsTo$default($receiver, result2, size, 0, 4, null) < 0 ? null : (List)result2;
    }

    @Nullable
    public static final <V extends Value> List<V> peekWords(@NotNull Frame<V> $receiver, int size1, int size2) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        ArrayList result2 = new ArrayList(size1 + size2);
        int offset2 = StackTransformationUtilsKt.peekWordsTo$default($receiver, result2, size1, 0, 4, null);
        if (offset2 < 0) {
            return null;
        }
        if (StackTransformationUtilsKt.peekWordsTo($receiver, result2, size2, offset2) < 0) {
            return null;
        }
        return result2;
    }

    public static final void saveStack(@NotNull MethodNode methodNode, @NotNull AbstractInsnNode nodeToReplace, @NotNull SavedStackDescriptor savedStackDescriptor) {
        InsnList insnList;
        Intrinsics.checkParameterIsNotNull(methodNode, "methodNode");
        Intrinsics.checkParameterIsNotNull(nodeToReplace, "nodeToReplace");
        Intrinsics.checkParameterIsNotNull(savedStackDescriptor, "savedStackDescriptor");
        InsnList $receiver = insnList = methodNode.instructions;
        StackTransformationUtilsKt.generateStoreInstructions(methodNode, nodeToReplace, savedStackDescriptor);
        $receiver.remove(nodeToReplace);
    }

    public static final void restoreStack(@NotNull MethodNode methodNode, @NotNull AbstractInsnNode location2, @NotNull SavedStackDescriptor savedStackDescriptor) {
        InsnList insnList;
        Intrinsics.checkParameterIsNotNull(methodNode, "methodNode");
        Intrinsics.checkParameterIsNotNull(location2, "location");
        Intrinsics.checkParameterIsNotNull(savedStackDescriptor, "savedStackDescriptor");
        InsnList $receiver = insnList = methodNode.instructions;
        StackTransformationUtilsKt.generateLoadInstructions(methodNode, location2, savedStackDescriptor);
        $receiver.remove(location2);
    }

    public static final void restoreStackWithReturnValue(@NotNull MethodNode methodNode, @NotNull AbstractInsnNode nodeToReplace, @NotNull SavedStackDescriptor savedStackDescriptor, @NotNull BasicValue returnValue, int returnValueLocalVarIndex) {
        InsnList insnList;
        Intrinsics.checkParameterIsNotNull(methodNode, "methodNode");
        Intrinsics.checkParameterIsNotNull(nodeToReplace, "nodeToReplace");
        Intrinsics.checkParameterIsNotNull(savedStackDescriptor, "savedStackDescriptor");
        Intrinsics.checkParameterIsNotNull(returnValue, "returnValue");
        InsnList $receiver = insnList = methodNode.instructions;
        $receiver.insertBefore(nodeToReplace, new VarInsnNode(returnValue.getType().getOpcode(54), returnValueLocalVarIndex));
        StackTransformationUtilsKt.generateLoadInstructions(methodNode, nodeToReplace, savedStackDescriptor);
        $receiver.insertBefore(nodeToReplace, new VarInsnNode(returnValue.getType().getOpcode(21), returnValueLocalVarIndex));
        $receiver.remove(nodeToReplace);
    }

    public static final void generateLoadInstructions(@NotNull MethodNode methodNode, @NotNull AbstractInsnNode location2, @NotNull SavedStackDescriptor savedStackDescriptor) {
        Intrinsics.checkParameterIsNotNull(methodNode, "methodNode");
        Intrinsics.checkParameterIsNotNull(location2, "location");
        Intrinsics.checkParameterIsNotNull(savedStackDescriptor, "savedStackDescriptor");
        int localVarIndex = savedStackDescriptor.getFirstLocalVarIndex();
        for (BasicValue value : savedStackDescriptor.getSavedValues()) {
            methodNode.instructions.insertBefore(location2, new VarInsnNode(value.getType().getOpcode(21), localVarIndex));
            localVarIndex += value.getSize();
        }
    }

    public static final void generateStoreInstructions(@NotNull MethodNode methodNode, @NotNull AbstractInsnNode location2, @NotNull SavedStackDescriptor savedStackDescriptor) {
        Intrinsics.checkParameterIsNotNull(methodNode, "methodNode");
        Intrinsics.checkParameterIsNotNull(location2, "location");
        Intrinsics.checkParameterIsNotNull(savedStackDescriptor, "savedStackDescriptor");
        int localVarIndex = savedStackDescriptor.getFirstUnusedLocalVarIndex();
        for (BasicValue value : CollectionsKt.asReversed(savedStackDescriptor.getSavedValues())) {
            methodNode.instructions.insertBefore(location2, new VarInsnNode(value.getType().getOpcode(54), localVarIndex -= value.getSize()));
        }
    }

    @NotNull
    public static final InsnNode getPopInstruction(@NotNull BasicValue top) {
        int n;
        Intrinsics.checkParameterIsNotNull(top, "top");
        switch (top.getSize()) {
            case 1: {
                n = 87;
                break;
            }
            case 2: {
                n = 88;
                break;
            }
            default: {
                throw (Throwable)((Object)new AssertionError((Object)"Unexpected value type size"));
            }
        }
        return new InsnNode(n);
    }

    public static final void removeAlwaysFalseIfeq(@NotNull MethodNode methodNode, @NotNull AbstractInsnNode node) {
        InsnList insnList;
        Intrinsics.checkParameterIsNotNull(methodNode, "methodNode");
        Intrinsics.checkParameterIsNotNull(node, "node");
        InsnList $receiver = insnList = methodNode.instructions;
        $receiver.remove(node.getNext());
        $receiver.remove(node);
    }

    public static final void replaceAlwaysTrueIfeqWithGoto(@NotNull MethodNode methodNode, @NotNull AbstractInsnNode node) {
        InsnList insnList;
        Intrinsics.checkParameterIsNotNull(methodNode, "methodNode");
        Intrinsics.checkParameterIsNotNull(node, "node");
        InsnList $receiver = insnList = methodNode.instructions;
        AbstractInsnNode abstractInsnNode = node.getNext();
        if (abstractInsnNode == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.tree.JumpInsnNode");
        }
        JumpInsnNode next = (JumpInsnNode)abstractInsnNode;
        $receiver.insertBefore(node, new JumpInsnNode(167, next.label));
        $receiver.remove(node);
        $receiver.remove(next);
    }

    public static final void replaceMarkerWithPops(@NotNull MethodNode methodNode, @NotNull AbstractInsnNode node, int expectedStackSize, @NotNull List<? extends BasicValue> stackContent) {
        InsnList insnList;
        Intrinsics.checkParameterIsNotNull(methodNode, "methodNode");
        Intrinsics.checkParameterIsNotNull(node, "node");
        Intrinsics.checkParameterIsNotNull(stackContent, "stackContent");
        InsnList $receiver = insnList = methodNode.instructions;
        for (BasicValue basicValue : stackContent.subList(expectedStackSize, stackContent.size())) {
            $receiver.insert(node, StackTransformationUtilsKt.getPopInstruction(basicValue));
        }
        $receiver.remove(node);
    }
}

