/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.io.BooleanDataDescriptor;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorStringDescriptor;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.build.GeneratedJvmClass;
import org.jetbrains.kotlin.incremental.CacheVersionKt;
import org.jetbrains.kotlin.incremental.ChangesCollector;
import org.jetbrains.kotlin.incremental.IncrementalCacheCommon;
import org.jetbrains.kotlin.incremental.IncrementalJvmCache;
import org.jetbrains.kotlin.incremental.IncrementalJvmCache$WhenMappings;
import org.jetbrains.kotlin.incremental.IncrementalJvmCacheKt;
import org.jetbrains.kotlin.incremental.LocalFileKotlinClass;
import org.jetbrains.kotlin.incremental.PathCollectionExternalizer;
import org.jetbrains.kotlin.incremental.ProtoData;
import org.jetbrains.kotlin.incremental.ProtoDifferenceUtilsKt;
import org.jetbrains.kotlin.incremental.storage.BasicMap;
import org.jetbrains.kotlin.incremental.storage.BasicStringMap;
import org.jetbrains.kotlin.incremental.storage.ConstantsMapExternalizer;
import org.jetbrains.kotlin.incremental.storage.LazyStorage;
import org.jetbrains.kotlin.incremental.storage.PathStringDescriptor;
import org.jetbrains.kotlin.incremental.storage.ProtoMapValue;
import org.jetbrains.kotlin.incremental.storage.ProtoMapValueExternalizer;
import org.jetbrains.kotlin.incremental.storage.StringCollectionExternalizer;
import org.jetbrains.kotlin.incremental.storage.StringToLongMapExternalizer;
import org.jetbrains.kotlin.inline.InlineUtilKt;
import org.jetbrains.kotlin.load.kotlin.ModuleMapping;
import org.jetbrains.kotlin.load.kotlin.header.KotlinClassHeader;
import org.jetbrains.kotlin.load.kotlin.incremental.components.IncrementalCache;
import org.jetbrains.kotlin.load.kotlin.incremental.components.JvmPackagePartProto;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;
import org.jetbrains.kotlin.serialization.ClassData;
import org.jetbrains.kotlin.serialization.ProtoBuf;
import org.jetbrains.kotlin.serialization.deserialization.NameResolver;
import org.jetbrains.kotlin.serialization.jvm.BitEncoding;
import org.jetbrains.kotlin.serialization.jvm.JvmProtoBufUtil;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.ClassWriter;
import org.jetbrains.org.objectweb.asm.FieldVisitor;
import org.jetbrains.org.objectweb.asm.MethodVisitor;

@Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000\u00a6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\b\u0016\u0018\u0000 H2\u00020\u00012\u00020\u0002:\nHIJKLMNOPQB\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0004H\u0002J\u001c\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00040$H\u0007J\b\u0010'\u001a\u00020\u001fH\u0016J\u000e\u0010(\u001a\u00020\u001f2\u0006\u0010)\u001a\u00020*J\u0010\u0010+\u001a\u00020\u001f2\u0006\u0010,\u001a\u00020-H\u0014J\u0010\u0010.\u001a\u00020-2\u0006\u0010/\u001a\u00020-H\u0016J\n\u00100\u001a\u0004\u0018\u000101H\u0016J\u000e\u00102\u001a\b\u0012\u0004\u0012\u00020-03H\u0016J\u000e\u00104\u001a\b\u0012\u0004\u0012\u00020-03H\u0016J\u0012\u00105\u001a\u0004\u0018\u0001062\u0006\u00107\u001a\u00020-H\u0016J\u0018\u00108\u001a\n\u0012\u0004\u0012\u00020-\u0018\u0001032\u0006\u00109\u001a\u00020-H\u0016J\u000e\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020%J\u0016\u0010=\u001a\u00020\u001f2\f\u0010>\u001a\b\u0012\u0004\u0012\u00020\u00040?H\u0016J\u0018\u0010@\u001a\u00020\u001f2\u0006\u0010A\u001a\u00020B2\u0006\u0010)\u001a\u00020*H\u0016J\u001c\u0010C\u001a\u00020\u001f2\f\u0010D\u001a\b\u0012\u0004\u0012\u00020\u0004032\u0006\u0010E\u001a\u00020\u0004J\u0014\u0010F\u001a\b\u0012\u0004\u0012\u00020\u0004032\u0006\u0010G\u001a\u00020-R\u0012\u0010\u0007\u001a\u00060\bR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u00060\nR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000b\u001a\u00060\fR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\r\u001a\u00060\u000eR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000f\u001a\u00060\u0010R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0011\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0012\u0010\u0013R\u0012\u0010\u0016\u001a\u00060\u0017R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0018\u001a\u00060\u0019R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001a\u001a\u00060\u001bR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001c\u001a\u00060\u001dR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006R"}, d2={"Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache;", "Lorg/jetbrains/kotlin/incremental/IncrementalCacheCommon;", "Lorg/jetbrains/kotlin/load/kotlin/incremental/components/IncrementalCache;", "targetDataRoot", "Ljava/io/File;", "targetOutputDir", "(Ljava/io/File;Ljava/io/File;)V", "constantsMap", "Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache$ConstantsMap;", "dirtyOutputClassesMap", "Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache$DirtyOutputClassesMap;", "inlineFunctionsMap", "Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache$InlineFunctionsMap;", "internalNameToSource", "Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache$InternalNameToSourcesMap;", "multifileFacadeToParts", "Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache$MultifileClassFacadeMap;", "outputDir", "getOutputDir", "()Ljava/io/File;", "outputDir$delegate", "Lkotlin/Lazy;", "packagePartMap", "Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache$PackagePartMap;", "partToMultifileFacade", "Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache$MultifileClassPartMap;", "protoMap", "Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache$ProtoMap;", "sourceToClassesMap", "Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache$SourceToClassesMap;", "addToClassStorage", "", "kotlinClass", "Lorg/jetbrains/kotlin/incremental/LocalFileKotlinClass;", "srcFile", "classesBySources", "", "Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;", "sources", "clean", "clearCacheForRemovedClasses", "changesCollector", "Lorg/jetbrains/kotlin/incremental/ChangesCollector;", "debugLog", "message", "", "getClassFilePath", "internalClassName", "getModuleMappingData", "", "getObsoleteMultifileClasses", "", "getObsoletePackageParts", "getPackagePartData", "Lorg/jetbrains/kotlin/load/kotlin/incremental/components/JvmPackagePartProto;", "partInternalName", "getStableMultifileFacadeParts", "facadeInternalName", "isMultifileFacade", "", "className", "markDirty", "removedAndCompiledSources", "", "saveFileToCache", "generatedClass", "Lorg/jetbrains/kotlin/build/GeneratedJvmClass;", "saveModuleMappingToCache", "sourceFiles", "file", "sourcesByInternalName", "internalName", "Companion", "ConstantsMap", "DirtyOutputClassesMap", "InlineFunctionsMap", "InternalNameToSourcesMap", "MultifileClassFacadeMap", "MultifileClassPartMap", "PackagePartMap", "ProtoMap", "SourceToClassesMap", "kotlin-build-common"})
public class IncrementalJvmCache
extends IncrementalCacheCommon
implements IncrementalCache {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private final ProtoMap protoMap;
    private final ConstantsMap constantsMap;
    private final PackagePartMap packagePartMap;
    private final MultifileClassFacadeMap multifileFacadeToParts;
    private final MultifileClassPartMap partToMultifileFacade;
    private final SourceToClassesMap sourceToClassesMap;
    private final DirtyOutputClassesMap dirtyOutputClassesMap;
    private final InlineFunctionsMap inlineFunctionsMap;
    private final InternalNameToSourcesMap internalNameToSource;
    private final Lazy outputDir$delegate;
    private final File targetDataRoot;
    private static final String PROTO_MAP = "proto";
    private static final String CONSTANTS_MAP = "constants";
    private static final String PACKAGE_PARTS = "package-parts";
    private static final String MULTIFILE_CLASS_FACADES = "multifile-class-facades";
    private static final String MULTIFILE_CLASS_PARTS = "multifile-class-parts";
    private static final String SOURCE_TO_CLASSES = "source-to-classes";
    private static final String DIRTY_OUTPUT_CLASSES = "dirty-output-classes";
    private static final String INLINE_FUNCTIONS = "inline-functions";
    private static final String INTERNAL_NAME_TO_SOURCE = "internal-name-to-source";
    private static final String MODULE_MAPPING_FILE_NAME = ".kotlin_module";
    public static final Companion Companion;

    static {
        $$delegatedProperties = new KProperty[]{Reflection.property1(new PropertyReference1Impl(Reflection.getOrCreateKotlinClass(IncrementalJvmCache.class), "outputDir", "getOutputDir()Ljava/io/File;"))};
        Companion = new Companion(null);
        PROTO_MAP = PROTO_MAP;
        CONSTANTS_MAP = CONSTANTS_MAP;
        PACKAGE_PARTS = PACKAGE_PARTS;
        MULTIFILE_CLASS_FACADES = MULTIFILE_CLASS_FACADES;
        MULTIFILE_CLASS_PARTS = MULTIFILE_CLASS_PARTS;
        SOURCE_TO_CLASSES = SOURCE_TO_CLASSES;
        DIRTY_OUTPUT_CLASSES = DIRTY_OUTPUT_CLASSES;
        INLINE_FUNCTIONS = INLINE_FUNCTIONS;
        INTERNAL_NAME_TO_SOURCE = INTERNAL_NAME_TO_SOURCE;
        MODULE_MAPPING_FILE_NAME = "." + ModuleMapping.MAPPING_FILE_EXT;
    }

    private final File getOutputDir() {
        Lazy lazy = this.outputDir$delegate;
        IncrementalJvmCache incrementalJvmCache = this;
        KProperty kProperty = $$delegatedProperties[0];
        return (File)lazy.getValue();
    }

    protected void debugLog(@NotNull String message) {
        Intrinsics.checkParameterIsNotNull(message, "message");
    }

    @Override
    public void markDirty(@NotNull List<? extends File> removedAndCompiledSources) {
        Intrinsics.checkParameterIsNotNull(removedAndCompiledSources, "removedAndCompiledSources");
        for (File file : removedAndCompiledSources) {
            Collection<JvmClassName> classes2 = this.sourceToClassesMap.get(file);
            Iterable $receiver$iv = classes2;
            for (Object element$iv : $receiver$iv) {
                JvmClassName it = (JvmClassName)element$iv;
                String string = it.getInternalName();
                Intrinsics.checkExpressionValueIsNotNull(string, "it.internalName");
                this.dirtyOutputClassesMap.markDirty(string);
            }
            this.sourceToClassesMap.clearOutputsForSource(file);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Iterable<JvmClassName> classesBySources(@NotNull Iterable<? extends File> sources) {
        void $receiver$iv$iv;
        Iterable<? extends File> $receiver$iv;
        Intrinsics.checkParameterIsNotNull(sources, "sources");
        Iterable<? extends File> iterable = $receiver$iv = sources;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            File it = (File)element$iv$iv;
            Iterable list$iv$iv = this.sourceToClassesMap.get(it);
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final Collection<File> sourcesByInternalName(@NotNull String internalName) {
        Intrinsics.checkParameterIsNotNull(internalName, "internalName");
        return this.internalNameToSource.get(internalName);
    }

    public final boolean isMultifileFacade(@NotNull JvmClassName className2) {
        Intrinsics.checkParameterIsNotNull(className2, "className");
        String string = className2.getInternalName();
        Intrinsics.checkExpressionValueIsNotNull(string, "className.internalName");
        return this.multifileFacadeToParts.contains(string);
    }

    @Override
    @NotNull
    public String getClassFilePath(@NotNull String internalClassName) {
        Intrinsics.checkParameterIsNotNull(internalClassName, "internalClassName");
        String string = FileUtil.toSystemIndependentName(new File(this.getOutputDir(), "" + internalClassName + ".class").getCanonicalPath());
        Intrinsics.checkExpressionValueIsNotNull(string, "toSystemIndependentName(\u2026me.class\").canonicalPath)");
        return string;
    }

    public final void saveModuleMappingToCache(@NotNull Collection<? extends File> sourceFiles2, @NotNull File file) {
        JvmClassName jvmClassName;
        Intrinsics.checkParameterIsNotNull(sourceFiles2, "sourceFiles");
        Intrinsics.checkParameterIsNotNull(file, "file");
        JvmClassName jvmClassName2 = jvmClassName = JvmClassName.byInternalName(IncrementalJvmCache.Companion.getMODULE_MAPPING_FILE_NAME());
        Intrinsics.checkExpressionValueIsNotNull(jvmClassName2, "jvmClassName");
        this.protoMap.storeModuleMapping(jvmClassName2, FilesKt.readBytes(file));
        this.dirtyOutputClassesMap.notDirty(IncrementalJvmCache.Companion.getMODULE_MAPPING_FILE_NAME());
        Iterable $receiver$iv = sourceFiles2;
        for (Object element$iv : $receiver$iv) {
            File it = (File)element$iv;
            this.sourceToClassesMap.add(it, jvmClassName);
        }
    }

    public void saveFileToCache(@NotNull GeneratedJvmClass generatedClass, @NotNull ChangesCollector changesCollector) {
        Intrinsics.checkParameterIsNotNull(generatedClass, "generatedClass");
        Intrinsics.checkParameterIsNotNull(changesCollector, "changesCollector");
        Collection<File> sourceFiles2 = generatedClass.getSourceFiles();
        LocalFileKotlinClass kotlinClass = generatedClass.getOutputClass();
        JvmClassName className2 = kotlinClass.getClassName();
        String string = className2.getInternalName();
        Intrinsics.checkExpressionValueIsNotNull(string, "className.internalName");
        this.dirtyOutputClassesMap.notDirty(string);
        Iterable $receiver$iv = sourceFiles2;
        for (Object element$iv : $receiver$iv) {
            File it = (File)element$iv;
            this.sourceToClassesMap.add(it, className2);
        }
        String string2 = className2.getInternalName();
        Intrinsics.checkExpressionValueIsNotNull(string2, "className.internalName");
        this.internalNameToSource.set(string2, (Iterable<? extends File>)sourceFiles2);
        if (kotlinClass.getClassId().isLocal()) {
            return;
        }
        KotlinClassHeader header = kotlinClass.getClassHeader();
        switch (IncrementalJvmCache$WhenMappings.$EnumSwitchMapping$0[header.getKind().ordinal()]) {
            case 1: {
                String string3;
                boolean bl;
                boolean bl2 = bl = sourceFiles2.size() == 1;
                if (_Assertions.ENABLED && !bl) {
                    string3 = "Package part from several source files: " + sourceFiles2;
                    throw (Throwable)((Object)new AssertionError((Object)string3));
                }
                this.packagePartMap.addPackagePart(className2);
                this.protoMap.process(kotlinClass, changesCollector);
                this.constantsMap.process(kotlinClass, changesCollector);
                this.inlineFunctionsMap.process(kotlinClass, changesCollector);
                break;
            }
            case 2: {
                Object object = kotlinClass.getClassHeader().getData();
                if (object == null || (object = ArraysKt.toList((Object[])object)) == null) {
                    throw (Throwable)((Object)new AssertionError((Object)("Multifile class has no parts: " + kotlinClass.getClassName())));
                }
                Object partNames = object;
                this.multifileFacadeToParts.set(className2, (Collection)partNames);
                if (this.protoMap.contains(className2)) {
                    FqName fqName2 = className2.getFqNameForClassNameWithoutDollars();
                    Intrinsics.checkExpressionValueIsNotNull(fqName2, "className.fqNameForClassNameWithoutDollars");
                    changesCollector.collectSignature(fqName2, true);
                }
                this.protoMap.remove(className2, changesCollector);
                IncrementalCacheCommon.ClassFqNameToSourceMap classFqNameToSourceMap = this.getClassFqNameToSourceMap();
                FqName fqName3 = className2.getFqNameForClassNameWithoutDollars();
                Intrinsics.checkExpressionValueIsNotNull(fqName3, "className.fqNameForClassNameWithoutDollars");
                classFqNameToSourceMap.remove(fqName3);
                String string4 = className2.getInternalName();
                Intrinsics.checkExpressionValueIsNotNull(string4, "className.internalName");
                this.internalNameToSource.remove(string4);
                this.constantsMap.process(kotlinClass, changesCollector);
                this.inlineFunctionsMap.process(kotlinClass, changesCollector);
                break;
            }
            case 3: {
                boolean bl;
                String string3;
                boolean bl3 = bl = sourceFiles2.size() == 1;
                if (_Assertions.ENABLED && !bl) {
                    string3 = "Multifile class part from several source files: " + sourceFiles2;
                    throw (Throwable)((Object)new AssertionError((Object)string3));
                }
                this.packagePartMap.addPackagePart(className2);
                String string5 = className2.getInternalName();
                Intrinsics.checkExpressionValueIsNotNull(string5, "className.internalName");
                String string6 = header.getMultifileClassName();
                if (string6 == null) {
                    Intrinsics.throwNpe();
                }
                this.partToMultifileFacade.set(string5, string6);
                this.protoMap.process(kotlinClass, changesCollector);
                this.constantsMap.process(kotlinClass, changesCollector);
                this.inlineFunctionsMap.process(kotlinClass, changesCollector);
                break;
            }
            case 4: {
                boolean bl;
                String string3;
                boolean bl4 = bl = sourceFiles2.size() == 1;
                if (_Assertions.ENABLED && !bl) {
                    string3 = "Class is expected to have only one source file: " + sourceFiles2;
                    throw (Throwable)((Object)new AssertionError((Object)string3));
                }
                this.addToClassStorage(kotlinClass, (File)CollectionsKt.first((Iterable)sourceFiles2));
                this.protoMap.process(kotlinClass, changesCollector);
                this.constantsMap.process(kotlinClass, changesCollector);
                this.inlineFunctionsMap.process(kotlinClass, changesCollector);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void clearCacheForRemovedClasses(@NotNull ChangesCollector changesCollector) {
        void $receiver$iv$iv;
        void $receiver$iv;
        Object removedParts;
        Object value$iv;
        JvmClassName facade;
        Object object;
        Object object2;
        void $receiver$iv$iv2;
        Intrinsics.checkParameterIsNotNull(changesCollector, "changesCollector");
        Iterable $receiver$iv2 = this.dirtyOutputClassesMap.getDirtyOutputClasses();
        Iterable iterable = $receiver$iv2;
        Iterator destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv2, 10));
        for (Object item$iv$iv : $receiver$iv$iv2) {
            void p1;
            String string = (String)item$iv$iv;
            object2 = destination$iv$iv;
            object = JvmClassName.byInternalName((String)p1);
            object2.add(object);
        }
        List<Object> dirtyClasses = CollectionsKt.toList((List)((Object)destination$iv$iv));
        HashMap facadesWithRemovedParts = new HashMap();
        for (Object dirtyClass : dirtyClasses) {
            Object object3;
            JvmClassName key$iv;
            void $receiver$iv22;
            String string = ((JvmClassName)dirtyClass).getInternalName();
            Intrinsics.checkExpressionValueIsNotNull(string, "dirtyClass.internalName");
            if (this.partToMultifileFacade.get(string) == null) {
                continue;
            }
            JvmClassName facadeClassName = JvmClassName.byInternalName((String)((Object)facade));
            Map $i$a$1$unknown = facadesWithRemovedParts;
            Intrinsics.checkExpressionValueIsNotNull(facadeClassName, "facadeClassName");
            value$iv = $receiver$iv22.get(key$iv);
            if (value$iv == null) {
                HashSet answer$iv = new HashSet();
                $receiver$iv22.put(key$iv, answer$iv);
                object3 = answer$iv;
            } else {
                object3 = value$iv;
            }
            removedParts = (Set)object3;
            String string2 = ((JvmClassName)dirtyClass).getInternalName();
            Intrinsics.checkExpressionValueIsNotNull(string2, "dirtyClass.internalName");
            removedParts.add(string2);
        }
        destination$iv$iv = facadesWithRemovedParts.entrySet().iterator();
        while (destination$iv$iv.hasNext()) {
            void $receiver$iv$iv3;
            Collection<String> allParts;
            Object dirtyClass;
            removedParts = dirtyClass = destination$iv$iv.next();
            facade = (JvmClassName)removedParts.getKey();
            removedParts = dirtyClass;
            Set removedParts2 = (Set)removedParts.getValue();
            String string = facade.getInternalName();
            Intrinsics.checkExpressionValueIsNotNull(string, "facade.internalName");
            if (this.multifileFacadeToParts.get(string) == null) {
                continue;
            }
            Iterable $receiver$iv3 = allParts;
            value$iv = $receiver$iv3;
            Collection destination$iv$iv2 = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv3) {
                String it = (String)element$iv$iv;
                if (!(!removedParts2.contains(it))) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List notRemovedParts = (List)destination$iv$iv2;
            if (notRemovedParts.isEmpty()) {
                Object object4 = facade;
                Intrinsics.checkExpressionValueIsNotNull(object4, "facade");
                this.multifileFacadeToParts.remove((JvmClassName)object4);
                continue;
            }
            Object object5 = facade;
            Intrinsics.checkExpressionValueIsNotNull(object5, "facade");
            this.multifileFacadeToParts.set((JvmClassName)object5, notRemovedParts);
        }
        Iterable $receiver$iv4 = dirtyClasses;
        for (Map.Entry element$iv : $receiver$iv4) {
            JvmClassName it;
            JvmClassName jvmClassName = it = (JvmClassName)((Object)element$iv);
            Intrinsics.checkExpressionValueIsNotNull(jvmClassName, "it");
            this.protoMap.remove(jvmClassName, changesCollector);
            this.packagePartMap.remove(it);
            this.multifileFacadeToParts.remove(it);
            this.partToMultifileFacade.remove(it);
            this.constantsMap.remove(it);
            this.inlineFunctionsMap.remove(it);
            String string = it.getInternalName();
            Intrinsics.checkExpressionValueIsNotNull(string, "it.internalName");
            this.internalNameToSource.remove(string);
        }
        $receiver$iv4 = dirtyClasses;
        object2 = this;
        destination$iv$iv = $receiver$iv;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            JvmClassName $i$f$forEach = (JvmClassName)item$iv$iv;
            object = destination$iv$iv3;
            FqName fqName2 = it.getFqNameForClassNameWithoutDollars();
            object.add(fqName2);
        }
        object = (List)destination$iv$iv3;
        ((IncrementalCacheCommon)object2).removeAllFromClassStorage((Collection)object);
        this.dirtyOutputClassesMap.clean();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Collection<String> getObsoletePackageParts() {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Iterable iterable = $receiver$iv = (Iterable)this.dirtyOutputClassesMap.getDirtyOutputClasses();
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            String it = (String)element$iv$iv;
            JvmClassName jvmClassName = JvmClassName.byInternalName(it);
            Intrinsics.checkExpressionValueIsNotNull(jvmClassName, "JvmClassName.byInternalName(it)");
            if (!this.packagePartMap.isPackagePart(jvmClassName)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List obsoletePackageParts = (List)destination$iv$iv;
        this.debugLog("Obsolete package parts: " + obsoletePackageParts);
        return obsoletePackageParts;
    }

    @Override
    @Nullable
    public JvmPackagePartProto getPackagePartData(@NotNull String partInternalName) {
        JvmPackagePartProto jvmPackagePartProto;
        Intrinsics.checkParameterIsNotNull(partInternalName, "partInternalName");
        JvmClassName jvmClassName = JvmClassName.byInternalName(partInternalName);
        Intrinsics.checkExpressionValueIsNotNull(jvmClassName, "JvmClassName.byInternalName(partInternalName)");
        ProtoMapValue protoMapValue = this.protoMap.get(jvmClassName);
        if (protoMapValue != null) {
            ProtoMapValue protoMapValue2;
            ProtoMapValue value = protoMapValue2 = protoMapValue;
            jvmPackagePartProto = new JvmPackagePartProto(value.getBytes(), value.getStrings());
        } else {
            jvmPackagePartProto = null;
        }
        return jvmPackagePartProto;
    }

    @Override
    @NotNull
    public Collection<String> getObsoleteMultifileClasses() {
        LinkedHashSet<String> obsoleteMultifileClasses = new LinkedHashSet<String>();
        for (String dirtyClass : this.dirtyOutputClassesMap.getDirtyOutputClasses()) {
            String dirtyFacade;
            if (this.partToMultifileFacade.get(dirtyClass) == null) {
                continue;
            }
            obsoleteMultifileClasses.add(dirtyFacade);
        }
        this.debugLog("Obsolete multifile class facades: " + obsoleteMultifileClasses);
        return obsoleteMultifileClasses;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Collection<String> getStableMultifileFacadeParts(@NotNull String facadeInternalName) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull(facadeInternalName, "facadeInternalName");
        Collection<String> collection = this.multifileFacadeToParts.get(facadeInternalName);
        if (collection == null) {
            return null;
        }
        Collection<String> partNames = collection;
        Iterable iterable = $receiver$iv = (Iterable)partNames;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            String it = (String)element$iv$iv;
            if (!(!this.dirtyOutputClassesMap.isDirty(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Override
    @Nullable
    public byte[] getModuleMappingData() {
        JvmClassName jvmClassName = JvmClassName.byInternalName(IncrementalJvmCache.Companion.getMODULE_MAPPING_FILE_NAME());
        Intrinsics.checkExpressionValueIsNotNull(jvmClassName, "JvmClassName.byInternalN\u2026MODULE_MAPPING_FILE_NAME)");
        ProtoMapValue protoMapValue = this.protoMap.get(jvmClassName);
        return (byte[])(protoMapValue != null ? protoMapValue.getBytes() : null);
    }

    @Override
    public void clean() {
        super.clean();
        CacheVersionKt.normalCacheVersion$default(this.targetDataRoot, null, 2, null).clean();
    }

    /*
     * WARNING - void declaration
     */
    private final void addToClassStorage(LocalFileKotlinClass kotlinClass, File srcFile) {
        void nameResolver;
        String[] stringArray = kotlinClass.getClassHeader().getData();
        if (stringArray == null) {
            Intrinsics.throwNpe();
        }
        String[] stringArray2 = kotlinClass.getClassHeader().getStrings();
        if (stringArray2 == null) {
            Intrinsics.throwNpe();
        }
        ClassData classData = JvmProtoBufUtil.readClassDataFrom(stringArray, stringArray2);
        NameResolver nameResolver2 = classData.component1();
        ProtoBuf.Class proto = classData.component2();
        this.addToClassStorage(proto, (NameResolver)nameResolver, srcFile);
    }

    public IncrementalJvmCache(@NotNull File targetDataRoot, @Nullable File targetOutputDir) {
        Intrinsics.checkParameterIsNotNull(targetDataRoot, "targetDataRoot");
        super(new File(targetDataRoot, IncrementalJvmCacheKt.getKOTLIN_CACHE_DIRECTORY_NAME()));
        this.targetDataRoot = targetDataRoot;
        this.protoMap = (ProtoMap)this.registerMap((BasicMap)new ProtoMap(this.getStorageFile(IncrementalJvmCache.Companion.getPROTO_MAP())));
        this.constantsMap = (ConstantsMap)this.registerMap((BasicMap)new ConstantsMap(this.getStorageFile(IncrementalJvmCache.Companion.getCONSTANTS_MAP())));
        this.packagePartMap = (PackagePartMap)this.registerMap((BasicMap)new PackagePartMap(this.getStorageFile(IncrementalJvmCache.Companion.getPACKAGE_PARTS())));
        this.multifileFacadeToParts = (MultifileClassFacadeMap)this.registerMap((BasicMap)new MultifileClassFacadeMap(this.getStorageFile(IncrementalJvmCache.Companion.getMULTIFILE_CLASS_FACADES())));
        this.partToMultifileFacade = (MultifileClassPartMap)this.registerMap((BasicMap)new MultifileClassPartMap(this.getStorageFile(IncrementalJvmCache.Companion.getMULTIFILE_CLASS_PARTS())));
        this.sourceToClassesMap = (SourceToClassesMap)this.registerMap((BasicMap)new SourceToClassesMap(this.getStorageFile(IncrementalJvmCache.Companion.getSOURCE_TO_CLASSES())));
        this.dirtyOutputClassesMap = (DirtyOutputClassesMap)this.registerMap((BasicMap)new DirtyOutputClassesMap(this.getStorageFile(IncrementalJvmCache.Companion.getDIRTY_OUTPUT_CLASSES())));
        this.inlineFunctionsMap = (InlineFunctionsMap)this.registerMap((BasicMap)new InlineFunctionsMap(this.getStorageFile(IncrementalJvmCache.Companion.getINLINE_FUNCTIONS())));
        this.internalNameToSource = (InternalNameToSourcesMap)this.registerMap((BasicMap)new InternalNameToSourcesMap(this.getStorageFile(IncrementalJvmCache.Companion.getINTERNAL_NAME_TO_SOURCE())));
        this.outputDir$delegate = LazyKt.lazy(LazyThreadSafetyMode.NONE, (Function0)new Function0<File>(targetOutputDir){
            final /* synthetic */ File $targetOutputDir;

            @NotNull
            public final File invoke() {
                File file = this.$targetOutputDir;
                if (file == null) {
                    String string = "Target is expected to have output directory";
                    throw (Throwable)new IllegalArgumentException(string.toString());
                }
                return file;
            }
            {
                this.$targetOutputDir = file;
                super(0);
            }
        });
    }

    @Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0000\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0011\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0086\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0014J\u0013\u0010\r\u001a\u0004\u0018\u00010\u00022\u0006\u0010\b\u001a\u00020\tH\u0086\u0002J\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u0018\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0016\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0013J\u0016\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u0018\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache$ProtoMap;", "Lorg/jetbrains/kotlin/incremental/storage/BasicStringMap;", "Lorg/jetbrains/kotlin/incremental/storage/ProtoMapValue;", "storageFile", "Ljava/io/File;", "(Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache;Ljava/io/File;)V", "contains", "", "className", "Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;", "dumpValue", "", "value", "get", "process", "", "kotlinClass", "Lorg/jetbrains/kotlin/incremental/LocalFileKotlinClass;", "changesCollector", "Lorg/jetbrains/kotlin/incremental/ChangesCollector;", "put", "remove", "storeModuleMapping", "bytes", "", "kotlin-build-common"})
    private final class ProtoMap
    extends BasicStringMap<ProtoMapValue> {
        public final void process(@NotNull LocalFileKotlinClass kotlinClass, @NotNull ChangesCollector changesCollector) {
            Intrinsics.checkParameterIsNotNull(kotlinClass, "kotlinClass");
            Intrinsics.checkParameterIsNotNull(changesCollector, "changesCollector");
            this.put(kotlinClass, changesCollector);
        }

        public final void storeModuleMapping(@NotNull JvmClassName className2, @NotNull byte[] bytes) {
            String[] stringArray;
            Intrinsics.checkParameterIsNotNull(className2, "className");
            Intrinsics.checkParameterIsNotNull(bytes, "bytes");
            LazyStorage<String, ProtoMapValue> lazyStorage = this.getStorage();
            String string = className2.getInternalName();
            Intrinsics.checkExpressionValueIsNotNull(string, "className.internalName");
            byte[] byArray = bytes;
            boolean bl = false;
            String string2 = string;
            LazyStorage<String, ProtoMapValue> lazyStorage2 = lazyStorage;
            String[] stringArray2 = stringArray = new String[0];
            byte[] byArray2 = byArray;
            boolean bl2 = bl;
            lazyStorage2.set(string2, new ProtoMapValue(bl2, byArray2, stringArray2));
        }

        private final void put(LocalFileKotlinClass kotlinClass, ChangesCollector changesCollector) {
            ProtoData protoData;
            KotlinClassHeader header = kotlinClass.getClassHeader();
            String key = kotlinClass.getClassName().getInternalName();
            LazyStorage lazyStorage = this.getStorage();
            String string = key;
            Intrinsics.checkExpressionValueIsNotNull(string, "key");
            ProtoMapValue oldData = (ProtoMapValue)lazyStorage.get(string);
            boolean bl = Intrinsics.areEqual((Object)header.getKind(), (Object)KotlinClassHeader.Kind.CLASS) ^ true;
            String[] stringArray = header.getData();
            if (stringArray == null) {
                Intrinsics.throwNpe();
            }
            byte[] byArray = BitEncoding.decodeBytes(stringArray);
            Intrinsics.checkExpressionValueIsNotNull(byArray, "BitEncoding.decodeBytes(header.data!!)");
            String[] stringArray2 = header.getStrings();
            if (stringArray2 == null) {
                Intrinsics.throwNpe();
            }
            ProtoMapValue newData = new ProtoMapValue(bl, byArray, stringArray2);
            this.getStorage().set(key, newData);
            FqName packageFqName = kotlinClass.getClassName().getPackageFqName();
            ProtoMapValue protoMapValue = oldData;
            if (protoMapValue != null) {
                FqName fqName2 = packageFqName;
                Intrinsics.checkExpressionValueIsNotNull(fqName2, "packageFqName");
                protoData = ProtoDifferenceUtilsKt.toProtoData(protoMapValue, fqName2);
            } else {
                protoData = null;
            }
            FqName fqName3 = packageFqName;
            Intrinsics.checkExpressionValueIsNotNull(fqName3, "packageFqName");
            changesCollector.collectProtoChanges(protoData, ProtoDifferenceUtilsKt.toProtoData(newData, fqName3));
        }

        public final boolean contains(@NotNull JvmClassName className2) {
            Intrinsics.checkParameterIsNotNull(className2, "className");
            LazyStorage lazyStorage = this.getStorage();
            String string = className2.getInternalName();
            Intrinsics.checkExpressionValueIsNotNull(string, "className.internalName");
            return lazyStorage.contains(string);
        }

        @Nullable
        public final ProtoMapValue get(@NotNull JvmClassName className2) {
            Intrinsics.checkParameterIsNotNull(className2, "className");
            LazyStorage lazyStorage = this.getStorage();
            String string = className2.getInternalName();
            Intrinsics.checkExpressionValueIsNotNull(string, "className.internalName");
            return (ProtoMapValue)lazyStorage.get(string);
        }

        public final void remove(@NotNull JvmClassName className2, @NotNull ChangesCollector changesCollector) {
            Intrinsics.checkParameterIsNotNull(className2, "className");
            Intrinsics.checkParameterIsNotNull(changesCollector, "changesCollector");
            String key = className2.getInternalName();
            LazyStorage lazyStorage = this.getStorage();
            String string = key;
            Intrinsics.checkExpressionValueIsNotNull(string, "key");
            ProtoMapValue protoMapValue = (ProtoMapValue)lazyStorage.get(string);
            if (protoMapValue == null) {
                return;
            }
            ProtoMapValue oldValue = protoMapValue;
            FqName fqName2 = className2.getPackageFqName();
            Intrinsics.checkExpressionValueIsNotNull(fqName2, "className.packageFqName");
            changesCollector.collectProtoChanges(ProtoDifferenceUtilsKt.toProtoData(oldValue, fqName2), null);
            this.getStorage().remove(key);
        }

        @Override
        @NotNull
        protected String dumpValue(@NotNull ProtoMapValue value) {
            Intrinsics.checkParameterIsNotNull(value, "value");
            return (value.isPackageFacade() ? "1" : "0") + Long.toHexString(IncrementalJvmCacheKt.md5(value.getBytes()));
        }

        public ProtoMap(@NotNull File storageFile) {
            Intrinsics.checkParameterIsNotNull(storageFile, "storageFile");
            super(storageFile, ProtoMapValueExternalizer.INSTANCE);
        }
    }

    @Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00020\u0001B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0011\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0086\u0002J\u001c\u0010\f\u001a\u00020\u00032\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002H\u0014J\u001c\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00022\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0016\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0017\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache$ConstantsMap;", "Lorg/jetbrains/kotlin/incremental/storage/BasicStringMap;", "", "", "", "storageFile", "Ljava/io/File;", "(Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache;Ljava/io/File;)V", "contains", "", "className", "Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;", "dumpValue", "value", "getConstantsMap", "bytes", "", "process", "", "kotlinClass", "Lorg/jetbrains/kotlin/incremental/LocalFileKotlinClass;", "changesCollector", "Lorg/jetbrains/kotlin/incremental/ChangesCollector;", "remove", "kotlin-build-common"})
    private final class ConstantsMap
    extends BasicStringMap<Map<String, ? extends Object>> {
        private final Map<String, Object> getConstantsMap(byte[] bytes) {
            HashMap result2 = new HashMap();
            new ClassReader(bytes).accept(new ClassVisitor(result2, 327680){
                final /* synthetic */ HashMap $result;

                @Nullable
                public FieldVisitor visitField(int access, @NotNull String name, @NotNull String desc, @Nullable String signature, @Nullable Object value) {
                    Intrinsics.checkParameterIsNotNull(name, "name");
                    Intrinsics.checkParameterIsNotNull(desc, "desc");
                    int staticFinal = 26;
                    if (value != null && (access & staticFinal) == 24) {
                        Map map2 = this.$result;
                        Object object = value;
                        map2.put(name, object);
                    }
                    return null;
                }
                {
                    this.$result = $captured_local_variable$0;
                    super($super_call_param$1);
                }
            }, 7);
            return result2;
        }

        public final boolean contains(@NotNull JvmClassName className2) {
            Intrinsics.checkParameterIsNotNull(className2, "className");
            LazyStorage lazyStorage = this.getStorage();
            String string = className2.getInternalName();
            Intrinsics.checkExpressionValueIsNotNull(string, "className.internalName");
            return lazyStorage.contains(string);
        }

        public final void process(@NotNull LocalFileKotlinClass kotlinClass, @NotNull ChangesCollector changesCollector) {
            Map<String, Object> newMap;
            Intrinsics.checkParameterIsNotNull(kotlinClass, "kotlinClass");
            Intrinsics.checkParameterIsNotNull(changesCollector, "changesCollector");
            String key = kotlinClass.getClassName().getInternalName();
            LazyStorage lazyStorage = this.getStorage();
            String string = key;
            Intrinsics.checkExpressionValueIsNotNull(string, "key");
            Map map2 = (Map)lazyStorage.get(string);
            if (map2 == null) {
                map2 = MapsKt.emptyMap();
            }
            Map oldMap = map2;
            Map<String, Object> map3 = newMap = this.getConstantsMap(kotlinClass.getFileContents());
            if (!map3.isEmpty()) {
                this.getStorage().set(key, newMap);
            } else {
                this.getStorage().remove(key);
            }
            for (String string2 : SetsKt.plus(oldMap.keySet(), (Iterable)newMap.keySet())) {
                FqName fqName2 = IncrementalJvmCacheKt.access$scopeFqName(kotlinClass);
                Intrinsics.checkExpressionValueIsNotNull(fqName2, "kotlinClass.scopeFqName()");
                changesCollector.collectMemberIfValueWasChanged(fqName2, string2, oldMap.get(string2), newMap.get(string2));
            }
        }

        public final void remove(@NotNull JvmClassName className2) {
            Intrinsics.checkParameterIsNotNull(className2, "className");
            LazyStorage lazyStorage = this.getStorage();
            String string = className2.getInternalName();
            Intrinsics.checkExpressionValueIsNotNull(string, "className.internalName");
            lazyStorage.remove(string);
        }

        @Override
        @NotNull
        protected String dumpValue(@NotNull Map<String, ? extends Object> value) {
            Intrinsics.checkParameterIsNotNull(value, "value");
            return IncrementalJvmCacheKt.dumpMap(value, dumpValue.1.INSTANCE);
        }

        public ConstantsMap(@NotNull File storageFile) {
            Intrinsics.checkParameterIsNotNull(storageFile, "storageFile");
            super(storageFile, ConstantsMapExternalizer.INSTANCE);
        }
    }

    @Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0014J\u000e\u0010\r\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\u000e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache$PackagePartMap;", "Lorg/jetbrains/kotlin/incremental/storage/BasicStringMap;", "", "storageFile", "Ljava/io/File;", "(Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache;Ljava/io/File;)V", "addPackagePart", "", "className", "Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;", "dumpValue", "", "value", "isPackagePart", "remove", "kotlin-build-common"})
    private final class PackagePartMap
    extends BasicStringMap<Boolean> {
        public final void addPackagePart(@NotNull JvmClassName className2) {
            Intrinsics.checkParameterIsNotNull(className2, "className");
            LazyStorage<String, Boolean> lazyStorage = this.getStorage();
            String string = className2.getInternalName();
            Intrinsics.checkExpressionValueIsNotNull(string, "className.internalName");
            lazyStorage.set(string, true);
        }

        public final void remove(@NotNull JvmClassName className2) {
            Intrinsics.checkParameterIsNotNull(className2, "className");
            LazyStorage lazyStorage = this.getStorage();
            String string = className2.getInternalName();
            Intrinsics.checkExpressionValueIsNotNull(string, "className.internalName");
            lazyStorage.remove(string);
        }

        public final boolean isPackagePart(@NotNull JvmClassName className2) {
            Intrinsics.checkParameterIsNotNull(className2, "className");
            LazyStorage lazyStorage = this.getStorage();
            String string = className2.getInternalName();
            Intrinsics.checkExpressionValueIsNotNull(string, "className.internalName");
            return lazyStorage.contains(string);
        }

        @Override
        @NotNull
        protected String dumpValue(boolean value) {
            return "";
        }

        public PackagePartMap(@NotNull File storageFile) {
            Intrinsics.checkParameterIsNotNull(storageFile, "storageFile");
            BooleanDataDescriptor booleanDataDescriptor = BooleanDataDescriptor.INSTANCE;
            Intrinsics.checkExpressionValueIsNotNull(booleanDataDescriptor, "BooleanDataDescriptor.INSTANCE");
            super(storageFile, booleanDataDescriptor);
        }
    }

    @Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0011\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0003H\u0086\u0002J\u0016\u0010\n\u001a\u00020\u00032\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0014J\u0019\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u00022\u0006\u0010\t\u001a\u00020\u0003H\u0086\u0002J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u001f\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00102\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0086\u0002\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache$MultifileClassFacadeMap;", "Lorg/jetbrains/kotlin/incremental/storage/BasicStringMap;", "", "", "storageFile", "Ljava/io/File;", "(Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache;Ljava/io/File;)V", "contains", "", "internalName", "dumpValue", "value", "get", "remove", "", "className", "Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;", "set", "facadeName", "partNames", "kotlin-build-common"})
    private final class MultifileClassFacadeMap
    extends BasicStringMap<Collection<? extends String>> {
        public final void set(@NotNull JvmClassName facadeName, @NotNull Collection<String> partNames) {
            Intrinsics.checkParameterIsNotNull(facadeName, "facadeName");
            Intrinsics.checkParameterIsNotNull(partNames, "partNames");
            LazyStorage<String, Collection<String>> lazyStorage = this.getStorage();
            String string = facadeName.getInternalName();
            Intrinsics.checkExpressionValueIsNotNull(string, "facadeName.internalName");
            lazyStorage.set(string, partNames);
        }

        @Nullable
        public final Collection<String> get(@NotNull String internalName) {
            Intrinsics.checkParameterIsNotNull(internalName, "internalName");
            return (Collection)this.getStorage().get(internalName);
        }

        public final boolean contains(@NotNull String internalName) {
            Intrinsics.checkParameterIsNotNull(internalName, "internalName");
            return this.getStorage().contains(internalName);
        }

        public final void remove(@NotNull JvmClassName className2) {
            Intrinsics.checkParameterIsNotNull(className2, "className");
            LazyStorage lazyStorage = this.getStorage();
            String string = className2.getInternalName();
            Intrinsics.checkExpressionValueIsNotNull(string, "className.internalName");
            lazyStorage.remove(string);
        }

        @Override
        @NotNull
        protected String dumpValue(@NotNull Collection<String> value) {
            Intrinsics.checkParameterIsNotNull(value, "value");
            return IncrementalJvmCacheKt.dumpCollection(value);
        }

        public MultifileClassFacadeMap(@NotNull File storageFile) {
            Intrinsics.checkParameterIsNotNull(storageFile, "storageFile");
            super(storageFile, StringCollectionExternalizer.INSTANCE);
        }
    }

    @Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0002H\u0014J\u0010\u0010\b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\t\u001a\u00020\u0002J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0016\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache$MultifileClassPartMap;", "Lorg/jetbrains/kotlin/incremental/storage/BasicStringMap;", "", "storageFile", "Ljava/io/File;", "(Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache;Ljava/io/File;)V", "dumpValue", "value", "get", "partName", "remove", "", "className", "Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;", "set", "facadeName", "kotlin-build-common"})
    private final class MultifileClassPartMap
    extends BasicStringMap<String> {
        public final void set(@NotNull String partName, @NotNull String facadeName) {
            Intrinsics.checkParameterIsNotNull(partName, "partName");
            Intrinsics.checkParameterIsNotNull(facadeName, "facadeName");
            this.getStorage().set(partName, facadeName);
        }

        @Nullable
        public final String get(@NotNull String partName) {
            Intrinsics.checkParameterIsNotNull(partName, "partName");
            return (String)this.getStorage().get(partName);
        }

        public final void remove(@NotNull JvmClassName className2) {
            Intrinsics.checkParameterIsNotNull(className2, "className");
            LazyStorage lazyStorage = this.getStorage();
            String string = className2.getInternalName();
            Intrinsics.checkExpressionValueIsNotNull(string, "className.internalName");
            lazyStorage.remove(string);
        }

        @Override
        @NotNull
        protected String dumpValue(@NotNull String value) {
            Intrinsics.checkParameterIsNotNull(value, "value");
            return value;
        }

        public MultifileClassPartMap(@NotNull File storageFile) {
            Intrinsics.checkParameterIsNotNull(storageFile, "storageFile");
            EnumeratorStringDescriptor enumeratorStringDescriptor = EnumeratorStringDescriptor.INSTANCE;
            Intrinsics.checkExpressionValueIsNotNull(enumeratorStringDescriptor, "EnumeratorStringDescriptor.INSTANCE");
            super(storageFile, enumeratorStringDescriptor);
        }
    }

    @Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0004\u0018\u00002\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0005J\u0016\u0010\r\u001a\u00020\u00032\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0014J\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00022\u0006\u0010\t\u001a\u00020\u0005H\u0086\u0002J\u0010\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0003H\u0002\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache$SourceToClassesMap;", "Lorg/jetbrains/kotlin/incremental/storage/BasicStringMap;", "", "", "storageFile", "Ljava/io/File;", "(Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache;Ljava/io/File;)V", "add", "", "sourceFile", "className", "Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;", "clearOutputsForSource", "dumpValue", "value", "get", "remove", "path", "kotlin-build-common"})
    public final class SourceToClassesMap
    extends BasicStringMap<Collection<? extends String>> {
        public final void clearOutputsForSource(@NotNull File sourceFile) {
            Intrinsics.checkParameterIsNotNull(sourceFile, "sourceFile");
            String string = sourceFile.getAbsolutePath();
            Intrinsics.checkExpressionValueIsNotNull(string, "sourceFile.absolutePath");
            this.remove(string);
        }

        public final void add(@NotNull File sourceFile, @NotNull JvmClassName className2) {
            Intrinsics.checkParameterIsNotNull(sourceFile, "sourceFile");
            Intrinsics.checkParameterIsNotNull(className2, "className");
            LazyStorage lazyStorage = this.getStorage();
            String string = sourceFile.getAbsolutePath();
            Intrinsics.checkExpressionValueIsNotNull(string, "sourceFile.absolutePath");
            String string2 = className2.getInternalName();
            Intrinsics.checkExpressionValueIsNotNull(string2, "className.internalName");
            lazyStorage.append(string, string2);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Collection<JvmClassName> get(@NotNull File sourceFile) {
            void $receiver$iv$iv;
            Intrinsics.checkParameterIsNotNull(sourceFile, "sourceFile");
            LazyStorage lazyStorage = this.getStorage();
            String string = sourceFile.getAbsolutePath();
            Intrinsics.checkExpressionValueIsNotNull(string, "sourceFile.absolutePath");
            Collection collection = (Collection)lazyStorage.get(string);
            Collection collection2 = collection;
            if (collection2 == null) {
                collection2 = CollectionsKt.emptyList();
            }
            Iterable $receiver$iv = collection2;
            Iterable iterable = $receiver$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                String string2 = (String)item$iv$iv;
                Collection collection3 = destination$iv$iv;
                JvmClassName jvmClassName = JvmClassName.byInternalName((String)it);
                collection3.add(jvmClassName);
            }
            return (List)destination$iv$iv;
        }

        @Override
        @NotNull
        protected String dumpValue(@NotNull Collection<String> value) {
            Intrinsics.checkParameterIsNotNull(value, "value");
            return IncrementalJvmCacheKt.dumpCollection(value);
        }

        private final void remove(String path2) {
            this.getStorage().remove(path2);
        }

        public SourceToClassesMap(@NotNull File storageFile) {
            Intrinsics.checkParameterIsNotNull(storageFile, "storageFile");
            super(storageFile, PathStringDescriptor.INSTANCE, (DataExternalizer)StringCollectionExternalizer.INSTANCE);
        }
    }

    @Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0000\b\u0086\u0004\u0018\u00002\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u0007\u001a\u00020\u00032\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0014J\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\u00022\u0006\u0010\n\u001a\u00020\u0003H\u0086\u0002J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\u0003J\u001f\u0010\r\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\u00032\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u000fH\u0086\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache$InternalNameToSourcesMap;", "Lorg/jetbrains/kotlin/incremental/storage/BasicStringMap;", "", "", "storageFile", "Ljava/io/File;", "(Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache;Ljava/io/File;)V", "dumpValue", "value", "get", "internalName", "remove", "", "set", "sourceFiles", "", "kotlin-build-common"})
    public final class InternalNameToSourcesMap
    extends BasicStringMap<Collection<? extends String>> {
        /*
         * WARNING - void declaration
         */
        public final void set(@NotNull String internalName, @NotNull Iterable<? extends File> sourceFiles2) {
            Collection<String> collection;
            void $receiver$iv$iv;
            void $receiver$iv;
            Intrinsics.checkParameterIsNotNull(internalName, "internalName");
            Intrinsics.checkParameterIsNotNull(sourceFiles2, "sourceFiles");
            Iterable<? extends File> iterable = sourceFiles2;
            String string = internalName;
            LazyStorage<String, List> lazyStorage = this.getStorage();
            void var4_6 = $receiver$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                File file = (File)item$iv$iv;
                collection = destination$iv$iv;
                String string2 = it.getCanonicalPath();
                collection.add(string2);
            }
            collection = (List)destination$iv$iv;
            lazyStorage.set(string, (List)collection);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Collection<File> get(@NotNull String internalName) {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Intrinsics.checkParameterIsNotNull(internalName, "internalName");
            Collection collection = (Collection)this.getStorage().get(internalName);
            if (collection == null) {
                collection = CollectionsKt.emptyList();
            }
            Iterable iterable = $receiver$iv = (Iterable)collection;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void p1;
                String string = (String)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                File file = new File((String)p1);
                collection2.add(file);
            }
            return (List)destination$iv$iv;
        }

        public final void remove(@NotNull String internalName) {
            Intrinsics.checkParameterIsNotNull(internalName, "internalName");
            this.getStorage().remove(internalName);
        }

        @Override
        @NotNull
        protected String dumpValue(@NotNull Collection<String> value) {
            Intrinsics.checkParameterIsNotNull(value, "value");
            return IncrementalJvmCacheKt.dumpCollection(value);
        }

        public InternalNameToSourcesMap(@NotNull File storageFile) {
            Intrinsics.checkParameterIsNotNull(storageFile, "storageFile");
            super(storageFile, new EnumeratorStringDescriptor(), (DataExternalizer)PathCollectionExternalizer.INSTANCE);
        }
    }

    @Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0014J\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\nJ\u000e\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u0007J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u0007J\u000e\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u0007\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache$DirtyOutputClassesMap;", "Lorg/jetbrains/kotlin/incremental/storage/BasicStringMap;", "", "storageFile", "Ljava/io/File;", "(Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache;Ljava/io/File;)V", "dumpValue", "", "value", "getDirtyOutputClasses", "", "isDirty", "className", "markDirty", "", "notDirty", "kotlin-build-common"})
    private final class DirtyOutputClassesMap
    extends BasicStringMap<Boolean> {
        public final void markDirty(@NotNull String className2) {
            Intrinsics.checkParameterIsNotNull(className2, "className");
            this.getStorage().set(className2, true);
        }

        public final void notDirty(@NotNull String className2) {
            Intrinsics.checkParameterIsNotNull(className2, "className");
            this.getStorage().remove(className2);
        }

        @NotNull
        public final Collection<String> getDirtyOutputClasses() {
            return this.getStorage().getKeys();
        }

        public final boolean isDirty(@NotNull String className2) {
            Intrinsics.checkParameterIsNotNull(className2, "className");
            return this.getStorage().contains(className2);
        }

        @Override
        @NotNull
        protected String dumpValue(boolean value) {
            return "";
        }

        public DirtyOutputClassesMap(@NotNull File storageFile) {
            Intrinsics.checkParameterIsNotNull(storageFile, "storageFile");
            BooleanDataDescriptor booleanDataDescriptor = BooleanDataDescriptor.INSTANCE;
            Intrinsics.checkExpressionValueIsNotNull(booleanDataDescriptor, "BooleanDataDescriptor.INSTANCE");
            super(storageFile, booleanDataDescriptor);
        }
    }

    @Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00020\u0001B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u001c\u0010\b\u001a\u00020\u00032\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002H\u0014J\u0010\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0003H\u0002J$\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00022\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0016\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0019\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache$InlineFunctionsMap;", "Lorg/jetbrains/kotlin/incremental/storage/BasicStringMap;", "", "", "", "storageFile", "Ljava/io/File;", "(Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache;Ljava/io/File;)V", "dumpValue", "value", "functionNameBySignature", "signature", "getInlineFunctionsMap", "header", "Lorg/jetbrains/kotlin/load/kotlin/header/KotlinClassHeader;", "bytes", "", "process", "", "kotlinClass", "Lorg/jetbrains/kotlin/incremental/LocalFileKotlinClass;", "changesCollector", "Lorg/jetbrains/kotlin/incremental/ChangesCollector;", "remove", "className", "Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;", "kotlin-build-common"})
    private final class InlineFunctionsMap
    extends BasicStringMap<Map<String, ? extends Long>> {
        private final Map<String, Long> getInlineFunctionsMap(KotlinClassHeader header, byte[] bytes) {
            Set<String> inlineFunctions = InlineUtilKt.inlineFunctionsJvmNames(header);
            if (inlineFunctions.isEmpty()) {
                return MapsKt.emptyMap();
            }
            HashMap result2 = new HashMap();
            new ClassReader(bytes).accept(new ClassVisitor(inlineFunctions, result2, 327680){
                final /* synthetic */ Set $inlineFunctions;
                final /* synthetic */ HashMap $result;

                @Nullable
                public MethodVisitor visitMethod(int access, @NotNull String name, @NotNull String desc, @Nullable String signature, @Nullable String[] exceptions) {
                    Intrinsics.checkParameterIsNotNull(name, "name");
                    Intrinsics.checkParameterIsNotNull(desc, "desc");
                    ClassWriter dummyClassWriter = new ClassWriter(327680);
                    return new MethodVisitor(this, name, desc, dummyClassWriter, exceptions, 327680, dummyClassWriter.visitMethod(0, name, desc, null, exceptions)){
                        final /* synthetic */ getInlineFunctionsMap.1 this$0;
                        final /* synthetic */ String $name;
                        final /* synthetic */ String $desc;
                        final /* synthetic */ ClassWriter $dummyClassWriter;
                        final /* synthetic */ String[] $exceptions;

                        public void visitEnd() {
                            String jvmName = this.$name + this.$desc;
                            if (!this.this$0.$inlineFunctions.contains(jvmName)) {
                                return;
                            }
                            byte[] byArray = this.$dummyClassWriter.toByteArray();
                            if (byArray == null) {
                                Intrinsics.throwNpe();
                            }
                            byte[] dummyBytes = byArray;
                            long hash = IncrementalJvmCacheKt.md5(dummyBytes);
                            Map map2 = this.this$0.$result;
                            Long l = hash;
                            map2.put(jvmName, l);
                        }
                        {
                            this.this$0 = $outer;
                            this.$name = $captured_local_variable$1;
                            this.$desc = $captured_local_variable$2;
                            this.$dummyClassWriter = $captured_local_variable$3;
                            this.$exceptions = $captured_local_variable$4;
                            super($super_call_param$5, $super_call_param$6);
                        }
                    };
                }
                {
                    this.$inlineFunctions = $captured_local_variable$0;
                    this.$result = $captured_local_variable$1;
                    super($super_call_param$2);
                }
            }, 0);
            return result2;
        }

        public final void process(@NotNull LocalFileKotlinClass kotlinClass, @NotNull ChangesCollector changesCollector) {
            Map<String, Long> newMap;
            Intrinsics.checkParameterIsNotNull(kotlinClass, "kotlinClass");
            Intrinsics.checkParameterIsNotNull(changesCollector, "changesCollector");
            String key = kotlinClass.getClassName().getInternalName();
            LazyStorage lazyStorage = this.getStorage();
            String string = key;
            Intrinsics.checkExpressionValueIsNotNull(string, "key");
            Map map2 = (Map)lazyStorage.get(string);
            if (map2 == null) {
                map2 = MapsKt.emptyMap();
            }
            Map oldMap = map2;
            KotlinClassHeader kotlinClassHeader = kotlinClass.getClassHeader();
            Intrinsics.checkExpressionValueIsNotNull(kotlinClassHeader, "kotlinClass.classHeader");
            Map<String, Long> map3 = newMap = this.getInlineFunctionsMap(kotlinClassHeader, kotlinClass.getFileContents());
            if (!map3.isEmpty()) {
                this.getStorage().set(key, newMap);
            } else {
                this.getStorage().remove(key);
            }
            for (String fn : SetsKt.plus(oldMap.keySet(), (Iterable)newMap.keySet())) {
                FqName fqName2 = IncrementalJvmCacheKt.access$scopeFqName(kotlinClass);
                Intrinsics.checkExpressionValueIsNotNull(fqName2, "kotlinClass.scopeFqName()");
                changesCollector.collectMemberIfValueWasChanged(fqName2, this.functionNameBySignature(fn), oldMap.get(fn), newMap.get(fn));
            }
        }

        private final String functionNameBySignature(String signature) {
            return StringsKt.substringBefore$default(signature, "(", null, 2, null);
        }

        public final void remove(@NotNull JvmClassName className2) {
            Intrinsics.checkParameterIsNotNull(className2, "className");
            LazyStorage lazyStorage = this.getStorage();
            String string = className2.getInternalName();
            Intrinsics.checkExpressionValueIsNotNull(string, "className.internalName");
            lazyStorage.remove(string);
        }

        @Override
        @NotNull
        protected String dumpValue(@NotNull Map<String, Long> value) {
            Intrinsics.checkParameterIsNotNull(value, "value");
            return IncrementalJvmCacheKt.dumpMap(value, dumpValue.1.INSTANCE);
        }

        public InlineFunctionsMap(@NotNull File storageFile) {
            Intrinsics.checkParameterIsNotNull(storageFile, "storageFile");
            super(storageFile, StringToLongMapExternalizer.INSTANCE);
        }
    }

    @Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0015\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0014\u0010\u000b\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0014\u0010\r\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006R\u0014\u0010\u000f\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0006R\u0014\u0010\u0011\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0006R\u0014\u0010\u0013\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0006R\u0014\u0010\u0015\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0006R\u0014\u0010\u0017\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0006\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache$Companion;", "", "()V", "CONSTANTS_MAP", "", "getCONSTANTS_MAP", "()Ljava/lang/String;", "DIRTY_OUTPUT_CLASSES", "getDIRTY_OUTPUT_CLASSES", "INLINE_FUNCTIONS", "getINLINE_FUNCTIONS", "INTERNAL_NAME_TO_SOURCE", "getINTERNAL_NAME_TO_SOURCE", "MODULE_MAPPING_FILE_NAME", "getMODULE_MAPPING_FILE_NAME", "MULTIFILE_CLASS_FACADES", "getMULTIFILE_CLASS_FACADES", "MULTIFILE_CLASS_PARTS", "getMULTIFILE_CLASS_PARTS", "PACKAGE_PARTS", "getPACKAGE_PARTS", "PROTO_MAP", "getPROTO_MAP", "SOURCE_TO_CLASSES", "getSOURCE_TO_CLASSES", "kotlin-build-common"})
    public static final class Companion {
        private final String getPROTO_MAP() {
            return PROTO_MAP;
        }

        private final String getCONSTANTS_MAP() {
            return CONSTANTS_MAP;
        }

        private final String getPACKAGE_PARTS() {
            return PACKAGE_PARTS;
        }

        private final String getMULTIFILE_CLASS_FACADES() {
            return MULTIFILE_CLASS_FACADES;
        }

        private final String getMULTIFILE_CLASS_PARTS() {
            return MULTIFILE_CLASS_PARTS;
        }

        private final String getSOURCE_TO_CLASSES() {
            return SOURCE_TO_CLASSES;
        }

        private final String getDIRTY_OUTPUT_CLASSES() {
            return DIRTY_OUTPUT_CLASSES;
        }

        private final String getINLINE_FUNCTIONS() {
            return INLINE_FUNCTIONS;
        }

        private final String getINTERNAL_NAME_TO_SOURCE() {
            return INTERNAL_NAME_TO_SOURCE;
        }

        private final String getMODULE_MAPPING_FILE_NAME() {
            return MODULE_MAPPING_FILE_NAME;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

