/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.js.inline.util.RelativePathCalculator;

@Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\u0003R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/js/inline/util/RelativePathCalculator;", "", "baseDir", "Ljava/io/File;", "(Ljava/io/File;)V", "baseDirPath", "", "calculateRelativePathTo", "", "file", "js.translator"})
public final class RelativePathCalculator {
    private final List<File> baseDirPath;

    @Nullable
    public final String calculateRelativePathTo(@NotNull File file) {
        int i;
        File second;
        Object item$iv;
        Pair $first_second;
        File first;
        Intrinsics.checkParameterIsNotNull(file, "file");
        List<File> path2 = CollectionsKt.asReversed(SequencesKt.toList(SequencesKt.generateSequence(file.getCanonicalFile(), (Function1)calculateRelativePathTo.path.1.INSTANCE)));
        if (Intrinsics.areEqual(this.baseDirPath.get(0), path2.get(0)) ^ true) {
            return null;
        }
        Iterable $receiver$iv = CollectionsKt.zip((Iterable)this.baseDirPath, (Iterable)path2);
        ArrayList list$iv22 = new ArrayList();
        Iterator iterator2 = $receiver$iv.iterator();
        while (iterator2.hasNext() && Intrinsics.areEqual(first = (File)($first_second = (Pair)(item$iv = iterator2.next())).component1(), second = (File)$first_second.component2())) {
            list$iv22.add(item$iv);
        }
        int commonLength = ((List)list$iv22).size();
        StringBuilder sb = new StringBuilder();
        int list$iv22 = commonLength;
        int n = this.baseDirPath.size();
        while (list$iv22 < n) {
            sb.append("../");
            ++i;
        }
        n = path2.size();
        for (i = commonLength; i < n; ++i) {
            sb.append(path2.get(i).getName()).append('/');
        }
        sb.setLength(StringsKt.getLastIndex(sb));
        return sb.toString();
    }

    public RelativePathCalculator(@NotNull File baseDir) {
        Intrinsics.checkParameterIsNotNull(baseDir, "baseDir");
        this.baseDirPath = CollectionsKt.asReversed(SequencesKt.toList(SequencesKt.generateSequence(baseDir.getCanonicalFile(), (Function1)baseDirPath.1.INSTANCE)));
    }
}

