/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.resolve.diagnostics;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptorWithAccessors;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.js.resolve.diagnostics.ErrorsJs;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDelegatedSuperTypeEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.checkers.SimpleDeclarationChecker;
import org.jetbrains.kotlin.types.DynamicTypesKt;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/js/resolve/diagnostics/JsDynamicDeclarationChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/SimpleDeclarationChecker;", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "diagnosticHolder", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "js.frontend"})
public final class JsDynamicDeclarationChecker
implements SimpleDeclarationChecker {
    public static final JsDynamicDeclarationChecker INSTANCE;

    /*
     * WARNING - void declaration
     */
    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DiagnosticSink diagnosticHolder, @NotNull BindingContext bindingContext) {
        block5: {
            block4: {
                KtExpression delegateExpression;
                block7: {
                    block6: {
                        KtExpression ktExpression;
                        Intrinsics.checkParameterIsNotNull(declaration, "declaration");
                        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
                        Intrinsics.checkParameterIsNotNull(diagnosticHolder, "diagnosticHolder");
                        Intrinsics.checkParameterIsNotNull(bindingContext, "bindingContext");
                        if (!(declaration instanceof KtProperty) || !(descriptor2 instanceof VariableDescriptorWithAccessors)) break block4;
                        KtExpression ktExpression2 = ((KtProperty)declaration).getDelegateExpression();
                        if (ktExpression2 == null) break block5;
                        delegateExpression = ktExpression = ktExpression2;
                        ResolvedCall provideDelegateCall = (ResolvedCall)bindingContext.get(BindingContext.PROVIDE_DELEGATE_RESOLVED_CALL, descriptor2);
                        if (provideDelegateCall == null) break block6;
                        KotlinType kotlinType = ((FunctionDescriptor)provideDelegateCall.getResultingDescriptor()).getReturnType();
                        if (kotlinType != null && DynamicTypesKt.isDynamic(kotlinType)) break block7;
                    }
                    KotlinType kotlinType = bindingContext.getType(delegateExpression);
                    if (kotlinType == null) break block5;
                    if (!DynamicTypesKt.isDynamic(kotlinType)) break block5;
                }
                diagnosticHolder.report(ErrorsJs.PROPERTY_DELEGATION_BY_DYNAMIC.on(delegateExpression));
                break block5;
            }
            if (declaration instanceof KtClassOrObject) {
                void $receiver$iv$iv;
                Iterable $receiver$iv;
                Iterable $i$a$1$let = $receiver$iv = (Iterable)((KtClassOrObject)declaration).getSuperTypeListEntries();
                Collection destination$iv$iv = new ArrayList();
                for (Object element$iv$iv : $receiver$iv$iv) {
                    if (!(element$iv$iv instanceof KtDelegatedSuperTypeEntry)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                for (KtDelegatedSuperTypeEntry delegateDecl : (List)destination$iv$iv) {
                    KtExpression delegateExpr;
                    if (delegateDecl.getDelegateExpression() == null) {
                        continue;
                    }
                    KotlinType kotlinType = bindingContext.getType(delegateExpr);
                    if (kotlinType == null) continue;
                    if (!DynamicTypesKt.isDynamic(kotlinType)) continue;
                    diagnosticHolder.report(ErrorsJs.DELEGATION_BY_DYNAMIC.on(delegateExpr));
                }
            }
        }
    }

    private JsDynamicDeclarationChecker() {
        INSTANCE = this;
    }

    static {
        new JsDynamicDeclarationChecker();
    }

    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DiagnosticSink diagnosticHolder, @NotNull BindingContext bindingContext, @NotNull LanguageVersionSettings languageVersionSettings) {
        Intrinsics.checkParameterIsNotNull(declaration, "declaration");
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        Intrinsics.checkParameterIsNotNull(diagnosticHolder, "diagnosticHolder");
        Intrinsics.checkParameterIsNotNull(bindingContext, "bindingContext");
        Intrinsics.checkParameterIsNotNull(languageVersionSettings, "languageVersionSettings");
        SimpleDeclarationChecker.DefaultImpls.check(this, declaration, descriptor2, diagnosticHolder, bindingContext, languageVersionSettings);
    }
}

