/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.expression;

import java.util.HashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.CodegenUtil;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperator;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsBooleanLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsIf;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsNullLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.SourceInfoAwareJsNode;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.general.AbstractTranslator;
import org.jetbrains.kotlin.js.translate.general.Translation;
import org.jetbrains.kotlin.js.translate.operation.InOperationTranslator;
import org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.mutator.CoercionMutator;
import org.jetbrains.kotlin.js.translate.utils.mutator.LastExpressionMutator;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtWhenCondition;
import org.jetbrains.kotlin.psi.KtWhenConditionInRange;
import org.jetbrains.kotlin.psi.KtWhenConditionIsPattern;
import org.jetbrains.kotlin.psi.KtWhenConditionWithExpression;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;

public final class WhenTranslator
extends AbstractTranslator {
    @NotNull
    private final KtWhenExpression whenExpression;
    @Nullable
    private final JsExpression expressionToMatch;
    @Nullable
    private final KotlinType type;

    @Nullable
    public static JsNode translate(@NotNull KtWhenExpression expression2, @NotNull TranslationContext context) {
        return new WhenTranslator(expression2, context).translate();
    }

    private WhenTranslator(@NotNull KtWhenExpression expression2, @NotNull TranslationContext context) {
        super(context);
        this.whenExpression = expression2;
        KtExpression subject = expression2.getSubjectExpression();
        this.expressionToMatch = subject != null ? context.defineTemporary(Translation.translateAsExpression(subject, context)) : null;
        this.type = this.context().bindingContext().getType(expression2);
    }

    private JsNode translate() {
        JsIf currentIf = null;
        SourceInfoAwareJsNode resultIf = null;
        for (KtWhenEntry entry : this.whenExpression.getEntries()) {
            JsBlock statementBlock = new JsBlock();
            JsStatement statement2 = this.translateEntryExpression(entry, this.context(), statementBlock);
            if (resultIf == null && entry.isElse()) {
                this.context().addStatementsToCurrentBlockFrom(statementBlock);
                return statement2;
            }
            statement2 = JsAstUtils.mergeStatementInBlockIfNeeded(statement2, statementBlock);
            if (resultIf == null) {
                currentIf = JsAstUtils.newJsIf(this.translateConditions(entry, this.context()), statement2);
                currentIf.setSource(entry);
                resultIf = currentIf;
                continue;
            }
            if (entry.isElse()) {
                currentIf.setElseStatement(statement2);
                return resultIf;
            }
            JsBlock conditionsBlock = new JsBlock();
            JsIf nextIf = JsAstUtils.newJsIf(this.translateConditions(entry, this.context().innerBlock(conditionsBlock)), statement2);
            nextIf.setSource(entry);
            JsStatement statementToAdd = JsAstUtils.mergeStatementInBlockIfNeeded(nextIf, conditionsBlock);
            currentIf.setElseStatement(statementToAdd);
            currentIf = nextIf;
        }
        if (currentIf != null && currentIf.getElseStatement() == null && this.isExhaustive()) {
            JsInvocation noWhenMatchedInvocation = new JsInvocation((JsExpression)JsAstUtils.pureFqn("noWhenBranchMatched", (JsExpression)Namer.kotlinObject()), new JsExpression[0]);
            currentIf.setElseStatement(JsAstUtils.asSyntheticStatement(noWhenMatchedInvocation));
        }
        return resultIf != null ? resultIf : new JsNullLiteral();
    }

    private boolean isExhaustive() {
        KotlinType type2 = this.bindingContext().getType(this.whenExpression);
        boolean isStatement = type2 != null && KotlinBuiltIns.isUnit(type2) && !type2.isMarkedNullable();
        return CodegenUtil.isExhaustive(this.bindingContext(), this.whenExpression, isStatement);
    }

    @NotNull
    private JsStatement translateEntryExpression(@NotNull KtWhenEntry entry, @NotNull TranslationContext context, @NotNull JsBlock block) {
        KtExpression expressionToExecute = entry.getExpression();
        assert (expressionToExecute != null) : "WhenEntry should have whenExpression to execute.";
        JsStatement result2 = Translation.translateAsStatement(expressionToExecute, context, block);
        if (this.type != null) {
            return LastExpressionMutator.mutateLastExpression(result2, new CoercionMutator(this.type, context));
        }
        return result2;
    }

    @NotNull
    private JsExpression translateConditions(@NotNull KtWhenEntry entry, @NotNull TranslationContext context) {
        KtWhenCondition[] conditions2 = entry.getConditions();
        assert (conditions2.length > 0) : "When entry (not else) should have at least one condition";
        if (conditions2.length == 1) {
            return this.translateCondition(conditions2[0], context);
        }
        JsExpression result2 = this.translateCondition(conditions2[0], context);
        for (int i = 1; i < conditions2.length; ++i) {
            result2 = this.translateOrCondition(result2, conditions2[i], context);
        }
        return result2;
    }

    @NotNull
    private JsExpression translateOrCondition(@NotNull JsExpression leftExpression, @NotNull KtWhenCondition condition, @NotNull TranslationContext context) {
        TranslationContext rightContext = context.innerBlock();
        JsExpression rightExpression = this.translateCondition(condition, rightContext);
        context.moveVarsFrom(rightContext);
        if (rightContext.currentBlockIsEmpty()) {
            return new JsBinaryOperation(JsBinaryOperator.OR, leftExpression, rightExpression);
        }
        assert (rightExpression instanceof JsNameRef) : "expected JsNameRef, but: " + rightExpression;
        JsNameRef result2 = (JsNameRef)rightExpression;
        JsIf ifStatement = JsAstUtils.newJsIf(leftExpression, JsAstUtils.assignment(result2, new JsBooleanLiteral(true)).makeStmt(), rightContext.getCurrentBlock());
        ifStatement.setSource(condition);
        context.addStatementToCurrentBlock(ifStatement);
        return result2;
    }

    @NotNull
    private JsExpression translateCondition(@NotNull KtWhenCondition condition, @NotNull TranslationContext context) {
        JsExpression patternMatchExpression = this.translateWhenConditionToBooleanExpression(condition, context);
        if (WhenTranslator.isNegated(condition)) {
            return JsAstUtils.not(patternMatchExpression);
        }
        return patternMatchExpression;
    }

    @NotNull
    private JsExpression translateWhenConditionToBooleanExpression(@NotNull KtWhenCondition condition, @NotNull TranslationContext context) {
        if (condition instanceof KtWhenConditionIsPattern) {
            return this.translateIsCondition((KtWhenConditionIsPattern)condition, context);
        }
        if (condition instanceof KtWhenConditionWithExpression) {
            return this.translateExpressionCondition((KtWhenConditionWithExpression)condition, context);
        }
        if (condition instanceof KtWhenConditionInRange) {
            return this.translateRangeCondition((KtWhenConditionInRange)condition, context);
        }
        throw new AssertionError((Object)("Unsupported when condition " + condition.getClass()));
    }

    @NotNull
    private JsExpression translateIsCondition(@NotNull KtWhenConditionIsPattern conditionIsPattern, @NotNull TranslationContext context) {
        JsExpression expressionToMatch = this.getExpressionToMatch();
        assert (expressionToMatch != null) : "An is-check is not allowed in when() without subject.";
        KtTypeReference typeReference = conditionIsPattern.getTypeReference();
        assert (typeReference != null) : "An is-check must have a type reference.";
        KtExpression expressionToMatchNonTranslated = this.whenExpression.getSubjectExpression();
        assert (expressionToMatchNonTranslated != null) : "expressionToMatch != null => expressionToMatchNonTranslated != null: " + PsiUtilsKt.getTextWithLocation(conditionIsPattern);
        JsExpression result2 = Translation.patternTranslator(context).translateIsCheck(expressionToMatch, typeReference);
        return (result2 != null ? result2 : new JsBooleanLiteral(true)).source(conditionIsPattern);
    }

    @NotNull
    private JsExpression translateExpressionCondition(@NotNull KtWhenConditionWithExpression condition, @NotNull TranslationContext context) {
        KtExpression patternExpression = condition.getExpression();
        assert (patternExpression != null) : "Expression pattern should have an expression.";
        JsExpression expressionToMatch = this.getExpressionToMatch();
        if (expressionToMatch == null) {
            return Translation.patternTranslator(context).translateExpressionForExpressionPattern(patternExpression);
        }
        KtExpression subject = this.whenExpression.getSubjectExpression();
        assert (subject != null) : "Subject must be non-null since expressionToMatch is non-null: " + PsiUtilsKt.getTextWithLocation(condition);
        KotlinType type2 = BindingUtils.getTypeForExpression(this.bindingContext(), this.whenExpression.getSubjectExpression());
        return Translation.patternTranslator(context).translateExpressionPattern(type2, expressionToMatch, patternExpression);
    }

    @NotNull
    private JsExpression translateRangeCondition(@NotNull KtWhenConditionInRange condition, @NotNull TranslationContext context) {
        KtExpression patternExpression = condition.getRangeExpression();
        assert (patternExpression != null) : "Expression pattern should have an expression: " + PsiUtilsKt.getTextWithLocation(condition);
        JsExpression expressionToMatch = this.getExpressionToMatch();
        assert (expressionToMatch != null) : "Range pattern is only available for 'when (C) { in ... }'  expressions: " + PsiUtilsKt.getTextWithLocation(condition);
        HashMap<KtExpression, JsExpression> subjectAliases = new HashMap<KtExpression, JsExpression>();
        subjectAliases.put(this.whenExpression.getSubjectExpression(), expressionToMatch);
        TranslationContext callContext = context.innerContextWithAliasesForExpressions(subjectAliases);
        boolean negated = condition.getOperationReference().getReferencedNameElementType() == KtTokens.NOT_IN;
        return new InOperationTranslator(callContext, expressionToMatch, condition.getRangeExpression(), condition.getOperationReference(), negated).translate().source(condition);
    }

    @Nullable
    private JsExpression getExpressionToMatch() {
        return this.expressionToMatch;
    }

    private static boolean isNegated(@NotNull KtWhenCondition condition) {
        if (condition instanceof KtWhenConditionIsPattern) {
            return ((KtWhenConditionIsPattern)condition).isNegated();
        }
        return false;
    }
}

