/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import jnr.posix.FileStat;
import org.jruby.util.FileResource;

class JarFileStat
implements FileStat {
    private final FileResource resource;

    public JarFileStat(FileResource resource2) {
        this.resource = resource2;
    }

    @Override
    public long atime() {
        return this.resource.lastModified();
    }

    @Override
    public long blocks() {
        return this.resource.length();
    }

    @Override
    public long blockSize() {
        return 1L;
    }

    @Override
    public long ctime() {
        return this.resource.lastModified();
    }

    @Override
    public long dev() {
        return -1L;
    }

    @Override
    public String ftype() {
        return "zip file entry";
    }

    @Override
    public int gid() {
        return -1;
    }

    @Override
    public boolean groupMember(int i2) {
        return false;
    }

    @Override
    public long ino() {
        return -1L;
    }

    @Override
    public boolean isBlockDev() {
        return false;
    }

    @Override
    public boolean isCharDev() {
        return false;
    }

    @Override
    public boolean isDirectory() {
        return this.resource.isDirectory();
    }

    @Override
    public boolean isEmpty() {
        return this.resource.length() == 0L;
    }

    @Override
    public boolean isExecutable() {
        return false;
    }

    @Override
    public boolean isExecutableReal() {
        return false;
    }

    @Override
    public boolean isFifo() {
        return false;
    }

    @Override
    public boolean isFile() {
        return this.resource.isFile();
    }

    @Override
    public boolean isGroupOwned() {
        return false;
    }

    @Override
    public boolean isIdentical(FileStat fs) {
        return fs instanceof JarFileStat && ((JarFileStat)fs).resource.equals(this.resource);
    }

    @Override
    public boolean isNamedPipe() {
        return false;
    }

    @Override
    public boolean isOwned() {
        return false;
    }

    @Override
    public boolean isROwned() {
        return false;
    }

    @Override
    public boolean isReadable() {
        return this.resource.canRead();
    }

    @Override
    public boolean isReadableReal() {
        return this.resource.canRead();
    }

    @Override
    public boolean isWritable() {
        return false;
    }

    @Override
    public boolean isWritableReal() {
        return false;
    }

    @Override
    public boolean isSetgid() {
        return false;
    }

    @Override
    public boolean isSetuid() {
        return false;
    }

    @Override
    public boolean isSocket() {
        return false;
    }

    @Override
    public boolean isSticky() {
        return false;
    }

    @Override
    public boolean isSymlink() {
        return false;
    }

    @Override
    public int major(long l) {
        return -1;
    }

    @Override
    public int minor(long l) {
        return -1;
    }

    @Override
    public int mode() {
        return -1;
    }

    @Override
    public long mtime() {
        return this.resource.lastModified();
    }

    @Override
    public int nlink() {
        return -1;
    }

    @Override
    public long rdev() {
        return -1L;
    }

    @Override
    public long st_size() {
        return this.resource.length();
    }

    @Override
    public int uid() {
        return 0;
    }
}

