/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.server;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URI;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;
import org.languagetool.server.ApiV2;
import org.languagetool.server.HTTPServerConfig;
import org.languagetool.server.RequestLimiter;
import org.languagetool.server.ServerTools;
import org.languagetool.server.TextChecker;
import org.languagetool.server.TextTooLongException;
import org.languagetool.server.V2TextChecker;
import org.languagetool.tools.StringTools;

class LanguageToolHttpHandler
implements HttpHandler {
    private static final String ENCODING = "utf-8";
    private final Set<String> allowedIps;
    private final RequestLimiter requestLimiter;
    private final LinkedBlockingQueue<Runnable> workQueue;
    private final TextChecker textCheckerV2;
    private final HTTPServerConfig config;
    private final Set<String> ownIps;

    LanguageToolHttpHandler(HTTPServerConfig config, Set<String> allowedIps, boolean internal, RequestLimiter requestLimiter, LinkedBlockingQueue<Runnable> workQueue) {
        this.config = config;
        this.allowedIps = allowedIps;
        this.requestLimiter = requestLimiter;
        this.workQueue = workQueue;
        this.ownIps = config.getTrustXForwardForHeader() ? this.getServersOwnIps() : new HashSet<String>();
        this.textCheckerV2 = new V2TextChecker(config, internal);
    }

    void shutdown() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(HttpExchange httpExchange) throws IOException {
        block19: {
            String remoteAddress = null;
            Map<String, String> parameters = new HashMap<String, String>();
            try {
                URI requestedUri = httpExchange.getRequestURI();
                String origAddress = httpExchange.getRemoteAddress().getAddress().getHostAddress();
                String realAddressOrNull = this.getRealRemoteAddressOrNull(httpExchange);
                remoteAddress = realAddressOrNull != null ? realAddressOrNull : origAddress;
                parameters = this.getRequestQuery(httpExchange, requestedUri);
                if (this.requestLimiter != null && !this.requestLimiter.isAccessOkay(remoteAddress)) {
                    String text = parameters.get("text");
                    String textSizeMessage = text != null ? " Text size: " + text.length() + "." : "";
                    String errorMessage = "Error: Access from " + remoteAddress + " denied - too many requests." + textSizeMessage + " Allowed maximum requests: " + this.requestLimiter.getRequestLimit() + " requests per " + this.requestLimiter.getRequestLimitPeriodInSeconds() + " seconds";
                    this.sendError(httpExchange, 403, errorMessage);
                    ServerTools.print(errorMessage + " - useragent: " + parameters.get("useragent") + " - HTTP UserAgent: " + this.getHttpUserAgent(httpExchange));
                    return;
                }
                if (this.config.getMaxWorkQueueSize() != 0 && this.workQueue.size() > this.config.getMaxWorkQueueSize()) {
                    String response = "Error: There are currently too many parallel requests. Please try again later.";
                    ServerTools.print(response + " Queue size: " + this.workQueue.size() + ", maximum size: " + this.config.getMaxWorkQueueSize());
                    this.sendError(httpExchange, 503, "Error: " + response);
                    return;
                }
                if (this.allowedIps == null || this.allowedIps.contains(origAddress)) {
                    if (requestedUri.getRawPath().startsWith("/v2/")) {
                        ApiV2 apiV2 = new ApiV2(this.textCheckerV2, this.config.getAllowOriginUrl());
                        String pathWithoutVersion = requestedUri.getRawPath().substring("/v2/".length());
                        apiV2.handleRequest(pathWithoutVersion, httpExchange, parameters);
                        break block19;
                    }
                    if (requestedUri.getRawPath().endsWith("/Languages")) {
                        throw new IllegalArgumentException("You're using an old version of our API that's not supported anymore. Please see https://languagetool.org/http-api/migration.php");
                    }
                    if (requestedUri.getRawPath().contains("/v2/")) {
                        throw new IllegalArgumentException("You have '/v2/' in your path, but not at the root. Try an URL like 'http://server/v2/...' ");
                    }
                    throw new IllegalArgumentException("You're using an old version of our API that's not supported anymore. Please see https://languagetool.org/http-api/migration.php");
                }
                String errorMessage = "Error: Access from " + StringTools.escapeXML(origAddress) + " denied";
                this.sendError(httpExchange, 403, errorMessage);
                throw new RuntimeException(errorMessage);
            }
            catch (Exception e) {
                String response;
                int errorCode;
                boolean textLoggingAllowed = false;
                if (e instanceof TextTooLongException) {
                    errorCode = 413;
                    response = e.getMessage();
                } else if (e instanceof IllegalArgumentException) {
                    errorCode = 400;
                    response = e.getMessage();
                } else if (e.getCause() != null && e.getCause() instanceof TimeoutException) {
                    errorCode = 503;
                    response = "Checking took longer than " + this.config.getMaxCheckTimeMillis() / 1000L + " seconds, which is this server's limit. Please make sure you have selected the proper language or consider submitting a shorter text.";
                } else {
                    response = "Internal Error: " + e.getMessage();
                    errorCode = 500;
                    textLoggingAllowed = true;
                }
                this.logError(remoteAddress, e, errorCode, httpExchange, parameters, textLoggingAllowed);
                this.sendError(httpExchange, errorCode, "Error: " + response);
            }
            finally {
                httpExchange.close();
            }
        }
    }

    private void logError(String remoteAddress, Exception e, int errorCode, HttpExchange httpExchange, Map<String, String> params, boolean textLoggingAllowed) {
        String message = "An error has occurred: '" + e.getMessage() + "', sending HTTP code " + errorCode + ". ";
        message = message + "Access from " + remoteAddress + ", ";
        message = message + "HTTP user agent: " + this.getHttpUserAgent(httpExchange) + ", ";
        message = message + "Referrer: " + this.getHttpReferrer(httpExchange) + ", ";
        message = message + "language: " + params.get("language") + ", ";
        String text = params.get("text");
        if (text != null) {
            message = message + "text length: " + text.length() + ", ";
        }
        message = message + "Stacktrace follows:";
        ServerTools.print(message, System.err);
        e.printStackTrace();
        if (this.config.isVerbose() && text != null && textLoggingAllowed) {
            ServerTools.print("Exception was caused by this text (" + text.length() + " chars, showing up to 500):\n" + StringUtils.abbreviate(text, 500), System.err);
        }
    }

    private String getHttpUserAgent(HttpExchange httpExchange) {
        return httpExchange.getRequestHeaders().getFirst("User-Agent");
    }

    private String getHttpReferrer(HttpExchange httpExchange) {
        return httpExchange.getRequestHeaders().getFirst("Referer");
    }

    private Set<String> getServersOwnIps() {
        HashSet<String> ownIps = new HashSet<String>();
        try {
            Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
            while (e.hasMoreElements()) {
                NetworkInterface netInterface = e.nextElement();
                Enumeration<InetAddress> addresses = netInterface.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    InetAddress address = addresses.nextElement();
                    ownIps.add(address.getHostAddress());
                }
            }
        }
        catch (SocketException e1) {
            throw new RuntimeException("Could not get the server's own IP addresses", e1);
        }
        return ownIps;
    }

    @Nullable
    private String getRealRemoteAddressOrNull(HttpExchange httpExchange) {
        Object forwardedIpsStr;
        if (this.config.getTrustXForwardForHeader() && (forwardedIpsStr = httpExchange.getRequestHeaders().get("X-forwarded-for")) != null) {
            String allForwardedIpsStr = String.join((CharSequence)", ", (Iterable<? extends CharSequence>)forwardedIpsStr);
            List<String> allForwardedIps = Arrays.asList(allForwardedIpsStr.split(", "));
            return this.getLastIpIgnoringOwn(allForwardedIps);
        }
        return null;
    }

    private String getLastIpIgnoringOwn(List<String> forwardedIps) {
        String lastIp = null;
        for (String ip : forwardedIps) {
            if (this.ownIps.contains(ip)) continue;
            lastIp = ip;
        }
        return lastIp;
    }

    private void sendError(HttpExchange httpExchange, int httpReturnCode, String response) throws IOException {
        ServerTools.setAllowOrigin(httpExchange, this.config.getAllowOriginUrl());
        httpExchange.sendResponseHeaders(httpReturnCode, response.getBytes(ENCODING).length);
        httpExchange.getResponseBody().write(response.getBytes(ENCODING));
    }

    private Map<String, String> getRequestQuery(HttpExchange httpExchange, URI requestedUri) throws IOException {
        String query;
        if ("post".equalsIgnoreCase(httpExchange.getRequestMethod())) {
            try (InputStreamReader isr = new InputStreamReader(httpExchange.getRequestBody(), ENCODING);){
                query = this.readerToString(isr, this.config.getMaxTextHardLength());
            }
        } else {
            query = requestedUri.getRawQuery();
        }
        return this.parseQuery(query, httpExchange);
    }

    private String readerToString(Reader reader, int maxTextLength) throws IOException {
        StringBuilder sb = new StringBuilder();
        int readBytes = 0;
        char[] chars = new char[4000];
        while (readBytes >= 0 && (readBytes = reader.read(chars, 0, 4000)) > 0) {
            int generousMaxLength = maxTextLength * 3 + 1000;
            if (generousMaxLength < 0) {
                generousMaxLength = Integer.MAX_VALUE;
            }
            if (sb.length() > 0 && sb.length() > generousMaxLength) {
                throw new TextTooLongException("Your text's length exceeds this server's hard limit of " + maxTextLength + " characters.");
            }
            sb.append(new String(chars, 0, readBytes));
        }
        return sb.toString();
    }

    private Map<String, String> parseQuery(String query, HttpExchange httpExchange) throws UnsupportedEncodingException {
        HashMap<String, String> parameters = new HashMap<String, String>();
        if (query != null) {
            Map<String, String> parameterMap = this.getParameterMap(query, httpExchange);
            parameters.putAll(parameterMap);
        }
        return parameters;
    }

    private Map<String, String> getParameterMap(String query, HttpExchange httpExchange) throws UnsupportedEncodingException {
        String[] pairs = query.split("[&]");
        HashMap<String, String> parameters = new HashMap<String, String>();
        for (String pair : pairs) {
            int delimPos = pair.indexOf(61);
            if (delimPos == -1) continue;
            String param = pair.substring(0, delimPos);
            String key = URLDecoder.decode(param, ENCODING);
            try {
                String value = URLDecoder.decode(pair.substring(delimPos + 1), ENCODING);
                parameters.put(key, value);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException("Could not decode query. Query length: " + query.length() + " Request method: " + httpExchange.getRequestMethod(), e);
            }
        }
        return parameters;
    }
}

