/* iterator.hh
 * This file is part of cdbxx library
 * Copyright (c) 2004 by Stanislav Ievlev
 *
 * This file is covered by the GNU Library General Public License,
 * which should be included with libcdbxx as the file COPYING.
 */
#ifndef CDB_XX_ITERATOR_HH__
#define CDB_XX_ITERATOR_HH__

#include <iterator>

extern "C"
{
#include <cdb.h>
}

#include <cdbxx/data.hh>

namespace cdbxx
{
	/**
	 * forward walking database iterator
	 */
	class iterator: public std::iterator<std::forward_iterator_tag, data_pair>
	{
		static const size_t cdbi_size = sizeof(cdbi_t);
	public:
		iterator(mem_pos pos = 0,bool fill = true);  /**< start iterator with appropriate offset in the database file*/
		iterator& operator++(); /**< prefix operator */
		iterator operator++(int);
		bool equal(const iterator& other) const;
		const data_pair& operator*() const;
		const data_pair* operator->() const;
	private:
		void fill_pair(); /**< fill internal storage with current data */

		mem_pos pos_; /**< current position in the file before database record */
		cdbi_t keylen_; /**< length of the current key */
		cdbi_t valuelen_; /**< length of the current value */
		data_pair pair_;/**< temporary internal storage of current data pair */
	};

	inline bool operator==(const iterator& lhs, const iterator& rhs)
	{
		return lhs.equal(rhs);
	}

	inline bool operator!=(const iterator& lhs, const iterator& rhs)
	{
		return !(lhs.equal(rhs));
	}
}

#endif

