/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.el;

import java.io.Serializable;
import java.util.List;

public abstract class Expression
implements Serializable {
    public abstract String getExpressionString();

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public abstract boolean isLiteralText();

    public static final class ResolvedProperty {
        private final Object source;
        private final Object property;

        public ResolvedProperty(Object source, Object property) {
            this.source = source;
            this.property = property;
            if (source == null || property == null) {
                throw new IllegalArgumentException("Source and property must be non-null");
            }
        }

        public Object getSource() {
            return this.source;
        }

        public Object getProperty() {
            return this.property;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof ResolvedProperty) {
                ResolvedProperty orp = (ResolvedProperty)o;
                return orp.source == this.source && (orp.property == null && this.property == null || orp.property != null && orp.property.equals(this.property));
            }
            return false;
        }

        public int hashCode() {
            int hash = 17;
            hash = 37 * hash + this.source.hashCode();
            hash = 37 * hash + this.property.hashCode();
            return hash;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Result {
        private final Type type;
        private final Object result;
        private final List<ResolvedProperty> resolvedProperties;

        public Result(Type type, Object result, List<ResolvedProperty> resolvedProperties) {
            this.type = type;
            this.result = result;
            this.resolvedProperties = resolvedProperties;
            if (type == null || resolvedProperties == null) {
                throw new NullPointerException("Type, result and resolvedProperties must be non-null");
            }
        }

        public Type getType() {
            return this.type;
        }

        public Object getResult() {
            return this.result;
        }

        public List<ResolvedProperty> getResolvedProperties() {
            return this.resolvedProperties;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Type {
            UNRESOLVABLE,
            VALUE;

        }
    }
}

