/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve.constants;

import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ConstantValue;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt;
import kotlin.reflect.jvm.internal.impl.types.ErrorUtils;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EnumValue
extends ConstantValue<ClassDescriptor> {
    @Override
    @NotNull
    public KotlinType getType() {
        KotlinType kotlinType = DescriptorUtilsKt.getClassValueType((ClassDescriptor)this.getValue());
        if (kotlinType == null) {
            SimpleType simpleType2 = ErrorUtils.createErrorType("Containing class for error-class based enum entry " + (ClassDescriptor)this.getValue());
            Intrinsics.checkExpressionValueIsNotNull(simpleType2, "ErrorUtils.createErrorTy\u2026based enum entry $value\")");
            kotlinType = simpleType2;
        }
        return kotlinType;
    }

    @Override
    @NotNull
    public String toString() {
        return "" + this.getType() + '.' + ((ClassDescriptor)this.getValue()).getName();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || Intrinsics.areEqual(other.getClass(), this.getClass()) ^ true) {
            return false;
        }
        return Intrinsics.areEqual((ClassDescriptor)this.getValue(), (ClassDescriptor)((EnumValue)other).getValue());
    }

    public int hashCode() {
        return this.getValue().hashCode();
    }

    public EnumValue(@NotNull ClassDescriptor value) {
        Intrinsics.checkParameterIsNotNull(value, "value");
        super(value);
    }
}

