/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.optimization.boxing;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.kotlin.codegen.RangeCodegenUtilKt;
import org.jetbrains.kotlin.codegen.intrinsics.IteratorNext;
import org.jetbrains.kotlin.codegen.optimization.common.StrictBasicValue;
import org.jetbrains.kotlin.com.google.common.collect.ImmutableMap;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.jvm.JvmPrimitiveType;
import org.jetbrains.org.objectweb.asm.Type;

public class ProgressionIteratorBasicValue
extends StrictBasicValue {
    private static final ImmutableMap<String, Type> VALUES_TYPENAME_TO_TYPE;
    private static final ImmutableMap<PrimitiveType, ProgressionIteratorBasicValue> ITERATOR_VALUE_BY_ELEMENT_PRIMITIVE_TYPE;
    private final Type valuesPrimitiveType;
    private final String valuesPrimitiveTypeName;

    @NotNull
    private static Type getValuesType(@NotNull String valuesTypeName) {
        if (valuesTypeName == null) {
            ProgressionIteratorBasicValue.$$$reportNull$$$0(0);
        }
        Type type2 = VALUES_TYPENAME_TO_TYPE.get(valuesTypeName);
        assert (type2 != null) : "Unexpected type " + valuesTypeName;
        Type type3 = type2;
        if (type3 == null) {
            ProgressionIteratorBasicValue.$$$reportNull$$$0(1);
        }
        return type3;
    }

    private ProgressionIteratorBasicValue(@NotNull String valuesPrimitiveTypeName) {
        if (valuesPrimitiveTypeName == null) {
            ProgressionIteratorBasicValue.$$$reportNull$$$0(2);
        }
        super(IteratorNext.Companion.getPrimitiveIteratorType(Name.identifier(valuesPrimitiveTypeName)));
        this.valuesPrimitiveType = ProgressionIteratorBasicValue.getValuesType(valuesPrimitiveTypeName);
        this.valuesPrimitiveTypeName = valuesPrimitiveTypeName;
    }

    @Nullable
    public static ProgressionIteratorBasicValue byProgressionClassType(@NotNull Type progressionClassType) {
        if (progressionClassType == null) {
            ProgressionIteratorBasicValue.$$$reportNull$$$0(3);
        }
        FqName classFqName = new FqName(progressionClassType.getClassName());
        PrimitiveType elementType = RangeCodegenUtilKt.getPrimitiveRangeOrProgressionElementType(classFqName);
        return ITERATOR_VALUE_BY_ELEMENT_PRIMITIVE_TYPE.get((Object)elementType);
    }

    @NotNull
    public Type getValuesPrimitiveType() {
        Type type2 = this.valuesPrimitiveType;
        if (type2 == null) {
            ProgressionIteratorBasicValue.$$$reportNull$$$0(4);
        }
        return type2;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ProgressionIteratorBasicValue value = (ProgressionIteratorBasicValue)o;
        return this.valuesPrimitiveType.equals(value.valuesPrimitiveType);
    }

    @NotNull
    public String getNextMethodName() {
        String string = "next" + this.valuesPrimitiveTypeName;
        if (string == null) {
            ProgressionIteratorBasicValue.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public String getNextMethodDesc() {
        String string = "()" + this.getValuesPrimitiveType().getDescriptor();
        if (string == null) {
            ProgressionIteratorBasicValue.$$$reportNull$$$0(6);
        }
        return string;
    }

    static {
        ImmutableMap.Builder<Object, Object> builder = ImmutableMap.builder();
        for (PrimitiveType primitiveType : RangeCodegenUtilKt.getSupportedRangeTypes()) {
            builder.put(primitiveType.getTypeName().asString(), Type.getType(JvmPrimitiveType.get(primitiveType).getDesc()));
        }
        VALUES_TYPENAME_TO_TYPE = builder.build();
        builder = ImmutableMap.builder();
        for (PrimitiveType elementType : RangeCodegenUtilKt.getSupportedRangeTypes()) {
            builder.put((Object)elementType, new ProgressionIteratorBasicValue(elementType.getTypeName().asString()));
        }
        ITERATOR_VALUE_BY_ELEMENT_PRIMITIVE_TYPE = builder.build();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valuesTypeName";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/codegen/optimization/boxing/ProgressionIteratorBasicValue";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valuesPrimitiveTypeName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressionClassType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/codegen/optimization/boxing/ProgressionIteratorBasicValue";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getValuesType";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getValuesPrimitiveType";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getNextMethodName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getNextMethodDesc";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getValuesType";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "byProgressionClassType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

