/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs;

import java.io.IOException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.lang.LighterAST;
import org.jetbrains.kotlin.com.intellij.lang.LighterASTNode;
import org.jetbrains.kotlin.com.intellij.psi.JavaTokenType;
import org.jetbrains.kotlin.com.intellij.psi.PsiImportStatementBase;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.JavaStubElementType;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.PsiImportStatementStub;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.impl.PsiImportStatementStubImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.PsiImportStatementImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.PsiImportStaticStatementImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.JavaElementType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.JavaSourceUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.java.ImportStaticStatementElement;
import org.jetbrains.kotlin.com.intellij.psi.stubs.IndexSink;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubElement;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubInputStream;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubOutputStream;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.util.io.StringRef;

public abstract class JavaImportStatementElementType
extends JavaStubElementType<PsiImportStatementStub, PsiImportStatementBase> {
    public JavaImportStatementElementType(@NonNls @NotNull String id) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "org/jetbrains/kotlin/com/intellij/psi/impl/java/stubs/JavaImportStatementElementType", "<init>"));
        }
        super(id);
    }

    @Override
    public PsiImportStatementBase createPsi(@NotNull PsiImportStatementStub stub) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "org/jetbrains/kotlin/com/intellij/psi/impl/java/stubs/JavaImportStatementElementType", "createPsi"));
        }
        return this.getPsiFactory(stub).createImportStatement(stub);
    }

    @Override
    public PsiImportStatementBase createPsi(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/com/intellij/psi/impl/java/stubs/JavaImportStatementElementType", "createPsi"));
        }
        if (node instanceof ImportStaticStatementElement) {
            return new PsiImportStaticStatementImpl(node);
        }
        return new PsiImportStatementImpl(node);
    }

    @Override
    public PsiImportStatementStub createStub(LighterAST tree, LighterASTNode node, StubElement parentStub) {
        boolean isOnDemand = false;
        String refText = null;
        for (LighterASTNode child : tree.getChildren(node)) {
            IElementType type2 = child.getTokenType();
            if (type2 == JavaElementType.JAVA_CODE_REFERENCE || type2 == JavaElementType.IMPORT_STATIC_REFERENCE) {
                refText = JavaSourceUtil.getReferenceText(tree, child);
                continue;
            }
            if (type2 != JavaTokenType.ASTERISK) continue;
            isOnDemand = true;
        }
        byte flags = PsiImportStatementStubImpl.packFlags(isOnDemand, node.getTokenType() == JavaElementType.IMPORT_STATIC_STATEMENT);
        return new PsiImportStatementStubImpl(parentStub, refText, flags);
    }

    @Override
    public void serialize(@NotNull PsiImportStatementStub stub, @NotNull StubOutputStream dataStream) throws IOException {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "org/jetbrains/kotlin/com/intellij/psi/impl/java/stubs/JavaImportStatementElementType", "serialize"));
        }
        if (dataStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStream", "org/jetbrains/kotlin/com/intellij/psi/impl/java/stubs/JavaImportStatementElementType", "serialize"));
        }
        dataStream.writeByte(((PsiImportStatementStubImpl)stub).getFlags());
        dataStream.writeName(stub.getImportReferenceText());
    }

    @Override
    @NotNull
    public PsiImportStatementStub deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        if (dataStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStream", "org/jetbrains/kotlin/com/intellij/psi/impl/java/stubs/JavaImportStatementElementType", "deserialize"));
        }
        byte flags = dataStream.readByte();
        StringRef refText = dataStream.readName();
        PsiImportStatementStubImpl psiImportStatementStubImpl = new PsiImportStatementStubImpl(parentStub, refText, flags);
        if (psiImportStatementStubImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/java/stubs/JavaImportStatementElementType", "deserialize"));
        }
        return psiImportStatementStubImpl;
    }

    @Override
    public void indexStub(@NotNull PsiImportStatementStub stub, @NotNull IndexSink sink) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "org/jetbrains/kotlin/com/intellij/psi/impl/java/stubs/JavaImportStatementElementType", "indexStub"));
        }
        if (sink == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sink", "org/jetbrains/kotlin/com/intellij/psi/impl/java/stubs/JavaImportStatementElementType", "indexStub"));
        }
    }
}

