/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs;

import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.lang.LighterAST;
import org.jetbrains.kotlin.com.intellij.lang.LighterASTNode;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.psi.PsiPackageAccessibilityStatement;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.JavaStubElementType;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.PsiPackageAccessibilityStatementStub;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.impl.PsiPackageAccessibilityStatementStubImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.PackageAccessibilityStatementElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.PsiPackageAccessibilityStatementImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.JavaElementType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.JavaSourceUtil;
import org.jetbrains.kotlin.com.intellij.psi.stubs.IndexSink;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubElement;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubInputStream;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubOutputStream;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.com.intellij.util.io.StringRef;

public class JavaPackageAccessibilityStatementElementType
extends JavaStubElementType<PsiPackageAccessibilityStatementStub, PsiPackageAccessibilityStatement> {
    public JavaPackageAccessibilityStatementElementType(@NotNull String debugName) {
        if (debugName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugName", "org/jetbrains/kotlin/com/intellij/psi/impl/java/stubs/JavaPackageAccessibilityStatementElementType", "<init>"));
        }
        super(debugName);
    }

    @Override
    public PsiPackageAccessibilityStatement createPsi(@NotNull PsiPackageAccessibilityStatementStub stub) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "org/jetbrains/kotlin/com/intellij/psi/impl/java/stubs/JavaPackageAccessibilityStatementElementType", "createPsi"));
        }
        return this.getPsiFactory(stub).createPackageAccessibilityStatement(stub);
    }

    @Override
    public PsiPackageAccessibilityStatement createPsi(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/com/intellij/psi/impl/java/stubs/JavaPackageAccessibilityStatementElementType", "createPsi"));
        }
        return new PsiPackageAccessibilityStatementImpl(node);
    }

    @Override
    @NotNull
    public ASTNode createCompositeNode() {
        PackageAccessibilityStatementElement packageAccessibilityStatementElement = new PackageAccessibilityStatementElement(this);
        if (packageAccessibilityStatementElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/java/stubs/JavaPackageAccessibilityStatementElementType", "createCompositeNode"));
        }
        return packageAccessibilityStatementElement;
    }

    @Override
    public PsiPackageAccessibilityStatementStub createStub(LighterAST tree, LighterASTNode node, StubElement parentStub) {
        String refText = null;
        List<String> to = ContainerUtil.newSmartList();
        for (LighterASTNode child : tree.getChildren(node)) {
            IElementType type2 = child.getTokenType();
            if (type2 == JavaElementType.JAVA_CODE_REFERENCE) {
                refText = JavaSourceUtil.getReferenceText(tree, child);
                continue;
            }
            if (type2 != JavaElementType.MODULE_REFERENCE) continue;
            to.add(JavaSourceUtil.getReferenceText(tree, child));
        }
        return new PsiPackageAccessibilityStatementStubImpl(parentStub, this, refText, to);
    }

    @Override
    public void serialize(@NotNull PsiPackageAccessibilityStatementStub stub, @NotNull StubOutputStream dataStream) throws IOException {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "org/jetbrains/kotlin/com/intellij/psi/impl/java/stubs/JavaPackageAccessibilityStatementElementType", "serialize"));
        }
        if (dataStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStream", "org/jetbrains/kotlin/com/intellij/psi/impl/java/stubs/JavaPackageAccessibilityStatementElementType", "serialize"));
        }
        dataStream.writeName(stub.getPackageName());
        dataStream.writeUTFFast(StringUtil.join(stub.getTargets(), "/"));
    }

    @Override
    @NotNull
    public PsiPackageAccessibilityStatementStub deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        if (dataStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStream", "org/jetbrains/kotlin/com/intellij/psi/impl/java/stubs/JavaPackageAccessibilityStatementElementType", "deserialize"));
        }
        String packageName = StringRef.toString(dataStream.readName());
        List<String> targets = StringUtil.split(dataStream.readUTFFast(), "/");
        PsiPackageAccessibilityStatementStubImpl psiPackageAccessibilityStatementStubImpl = new PsiPackageAccessibilityStatementStubImpl(parentStub, this, packageName, targets);
        if (psiPackageAccessibilityStatementStubImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/java/stubs/JavaPackageAccessibilityStatementElementType", "deserialize"));
        }
        return psiPackageAccessibilityStatementStubImpl;
    }

    @Override
    public void indexStub(@NotNull PsiPackageAccessibilityStatementStub stub, @NotNull IndexSink sink) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "org/jetbrains/kotlin/com/intellij/psi/impl/java/stubs/JavaPackageAccessibilityStatementElementType", "indexStub"));
        }
        if (sink == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sink", "org/jetbrains/kotlin/com/intellij/psi/impl/java/stubs/JavaPackageAccessibilityStatementElementType", "indexStub"));
        }
    }

    @NotNull
    public static PsiPackageAccessibilityStatement.Role typeToRole(@NotNull IElementType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/com/intellij/psi/impl/java/stubs/JavaPackageAccessibilityStatementElementType", "typeToRole"));
        }
        if (type2 == JavaElementType.EXPORTS_STATEMENT) {
            PsiPackageAccessibilityStatement.Role role = PsiPackageAccessibilityStatement.Role.EXPORTS;
            if (role == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/java/stubs/JavaPackageAccessibilityStatementElementType", "typeToRole"));
            }
            return role;
        }
        if (type2 == JavaElementType.OPENS_STATEMENT) {
            PsiPackageAccessibilityStatement.Role role = PsiPackageAccessibilityStatement.Role.OPENS;
            if (role == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/java/stubs/JavaPackageAccessibilityStatementElementType", "typeToRole"));
            }
            return role;
        }
        throw new IllegalArgumentException("Unknown type: " + type2);
    }
}

