/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.impl;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.java.lexer.JavaLexer;
import org.jetbrains.kotlin.com.intellij.pom.java.LanguageLevel;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.java.PsiLiteralExpressionImpl;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubBase;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubElement;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;

public class PsiLiteralStub
extends StubBase<PsiLiteralExpressionImpl> {
    @NotNull
    private final String myLiteralText;
    private volatile IElementType myLiteralType;

    public PsiLiteralStub(StubElement parent2, @NotNull String literalText) {
        if (literalText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "literalText", "org/jetbrains/kotlin/com/intellij/psi/impl/java/stubs/impl/PsiLiteralStub", "<init>"));
        }
        super(parent2, JavaStubElementTypes.LITERAL_EXPRESSION);
        this.myLiteralText = literalText;
    }

    @NotNull
    public String getLiteralText() {
        String string = this.myLiteralText;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/java/stubs/impl/PsiLiteralStub", "getLiteralText"));
        }
        return string;
    }

    @NotNull
    public IElementType getLiteralType() {
        IElementType type2 = this.myLiteralType;
        if (type2 == null) {
            JavaLexer lexer = new JavaLexer(LanguageLevel.HIGHEST);
            lexer.start(this.myLiteralText);
            this.myLiteralType = type2 = lexer.getTokenType();
            assert (type2 != null) : this.myLiteralText;
        }
        IElementType iElementType = type2;
        if (iElementType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/java/stubs/impl/PsiLiteralStub", "getLiteralType"));
        }
        return iElementType;
    }
}

