/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.concurrency;

import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.util.LowMemoryWatcherManager;
import org.jetbrains.kotlin.com.intellij.util.Consumer;
import org.jetbrains.kotlin.com.intellij.util.IncorrectOperationException;
import org.jetbrains.kotlin.com.intellij.util.concurrency.AppDelayQueue;
import org.jetbrains.kotlin.com.intellij.util.concurrency.BoundedTaskExecutor;
import org.jetbrains.kotlin.com.intellij.util.concurrency.SchedulingWrapper;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;

public class AppScheduledExecutorService
extends SchedulingWrapper {
    private static final Logger LOG = Logger.getInstance("#org.jetbrains.ide.PooledThreadExecutor");
    @NotNull
    private final String myName;
    private final LowMemoryWatcherManager myLowMemoryWatcherManager;
    private Consumer<Thread> newThreadListener;
    private final AtomicInteger counter;

    @NotNull
    static ScheduledExecutorService getInstance() {
        AppScheduledExecutorService appScheduledExecutorService = Holder.INSTANCE;
        if (appScheduledExecutorService == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/concurrency/AppScheduledExecutorService", "getInstance"));
        }
        return appScheduledExecutorService;
    }

    AppScheduledExecutorService(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/com/intellij/util/concurrency/AppScheduledExecutorService", "<init>"));
        }
        super(new BackendThreadPoolExecutor(), new AppDelayQueue());
        this.counter = new AtomicInteger();
        this.myName = name;
        ((BackendThreadPoolExecutor)this.backendExecutorService).doSetThreadFactory(new ThreadFactory(){

            @Override
            @NotNull
            public Thread newThread(@NotNull Runnable r) {
                if (r == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "r", "org/jetbrains/kotlin/com/intellij/util/concurrency/AppScheduledExecutorService$1", "newThread"));
                }
                Thread thread2 = new Thread(r, "ApplicationImpl pooled thread " + AppScheduledExecutorService.this.counter.incrementAndGet());
                thread2.setPriority(4);
                Consumer listener = AppScheduledExecutorService.this.newThreadListener;
                if (listener != null) {
                    listener.consume(thread2);
                }
                Thread thread3 = thread2;
                if (thread3 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/concurrency/AppScheduledExecutorService$1", "newThread"));
                }
                return thread3;
            }
        });
        this.myLowMemoryWatcherManager = new LowMemoryWatcherManager(this);
    }

    @Override
    @NotNull
    public List<Runnable> shutdownNow() {
        List<Runnable> list2 = AppScheduledExecutorService.error();
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/concurrency/AppScheduledExecutorService", "shutdownNow"));
        }
        return list2;
    }

    @Override
    public void shutdown() {
        AppScheduledExecutorService.error();
    }

    static List<Runnable> error() {
        throw new IncorrectOperationException("You must not call this method on the global app pool");
    }

    @Override
    void doShutdown() {
        super.doShutdown();
        ((BackendThreadPoolExecutor)this.backendExecutorService).doShutdown();
    }

    @Override
    @NotNull
    List<Runnable> doShutdownNow() {
        List<Runnable> list2 = ContainerUtil.concat(super.doShutdownNow(), ((BackendThreadPoolExecutor)this.backendExecutorService).doShutdownNow());
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/concurrency/AppScheduledExecutorService", "doShutdownNow"));
        }
        return list2;
    }

    private static class BackendThreadPoolExecutor
    extends ThreadPoolExecutor {
        BackendThreadPoolExecutor() {
            super(1, Integer.MAX_VALUE, 1L, TimeUnit.MINUTES, new SynchronousQueue<Runnable>());
        }

        @Override
        protected void beforeExecute(Thread t, Runnable r) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("beforeExecute " + BoundedTaskExecutor.info(r) + " in " + t);
            }
        }

        @Override
        protected void afterExecute(Runnable r, Throwable t) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("afterExecute  " + BoundedTaskExecutor.info(r) + " in " + Thread.currentThread());
            }
            if (t != null) {
                LOG.error("Worker exited due to exception", t);
            }
        }

        private void doShutdown() {
            super.shutdown();
        }

        @NotNull
        private List<Runnable> doShutdownNow() {
            List<Runnable> list2 = super.shutdownNow();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/concurrency/AppScheduledExecutorService$BackendThreadPoolExecutor", "doShutdownNow"));
            }
            return list2;
        }

        private void doSetThreadFactory(@NotNull ThreadFactory threadFactory) {
            if (threadFactory == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "threadFactory", "org/jetbrains/kotlin/com/intellij/util/concurrency/AppScheduledExecutorService$BackendThreadPoolExecutor", "doSetThreadFactory"));
            }
            super.setThreadFactory(threadFactory);
        }

        @Override
        public void shutdown() {
            AppScheduledExecutorService.error();
        }

        @Override
        @NotNull
        public List<Runnable> shutdownNow() {
            List<Runnable> list2 = AppScheduledExecutorService.error();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/concurrency/AppScheduledExecutorService$BackendThreadPoolExecutor", "shutdownNow"));
            }
            return list2;
        }

        @Override
        public void setCorePoolSize(int corePoolSize) {
            AppScheduledExecutorService.error();
        }

        @Override
        public void allowCoreThreadTimeOut(boolean value) {
            AppScheduledExecutorService.error();
        }

        @Override
        public void setMaximumPoolSize(int maximumPoolSize) {
            AppScheduledExecutorService.error();
        }

        @Override
        public void setKeepAliveTime(long time, TimeUnit unit) {
            AppScheduledExecutorService.error();
        }

        @Override
        public void setThreadFactory(ThreadFactory threadFactory) {
            AppScheduledExecutorService.error();
        }
    }

    private static class Holder {
        private static final AppScheduledExecutorService INSTANCE = new AppScheduledExecutorService("Global instance");
    }
}

