/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.diagnostics;

import java.util.Arrays;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.Severity;

public abstract class DiagnosticFactory<D extends Diagnostic> {
    private String name;
    private final Severity severity;

    protected DiagnosticFactory(@NotNull Severity severity) {
        if (severity == null) {
            DiagnosticFactory.$$$reportNull$$$0(0);
        }
        this.name = null;
        this.severity = severity;
    }

    protected DiagnosticFactory(@NotNull String name, @NotNull Severity severity) {
        if (name == null) {
            DiagnosticFactory.$$$reportNull$$$0(1);
        }
        if (severity == null) {
            DiagnosticFactory.$$$reportNull$$$0(2);
        }
        this.name = null;
        this.name = name;
        this.severity = severity;
    }

    void setName(@NotNull String name) {
        if (name == null) {
            DiagnosticFactory.$$$reportNull$$$0(3);
        }
        this.name = name;
    }

    @NotNull
    public String getName() {
        String string = this.name;
        if (string == null) {
            DiagnosticFactory.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public Severity getSeverity() {
        Severity severity = this.severity;
        if (severity == null) {
            DiagnosticFactory.$$$reportNull$$$0(5);
        }
        return severity;
    }

    @NotNull
    public D cast(@NotNull Diagnostic diagnostic) {
        if (diagnostic == null) {
            DiagnosticFactory.$$$reportNull$$$0(6);
        }
        if (diagnostic.getFactory() != this) {
            throw new IllegalArgumentException("Factory mismatch: expected " + this + " but was " + diagnostic.getFactory());
        }
        Diagnostic diagnostic2 = diagnostic;
        if (diagnostic2 == null) {
            DiagnosticFactory.$$$reportNull$$$0(7);
        }
        return (D)diagnostic2;
    }

    @NotNull
    public static <D extends Diagnostic> D cast(@NotNull Diagnostic diagnostic, DiagnosticFactory<? extends D> ... factories) {
        if (diagnostic == null) {
            DiagnosticFactory.$$$reportNull$$$0(8);
        }
        if (factories == null) {
            DiagnosticFactory.$$$reportNull$$$0(9);
        }
        D d = DiagnosticFactory.cast(diagnostic, Arrays.asList(factories));
        if (d == null) {
            DiagnosticFactory.$$$reportNull$$$0(10);
        }
        return d;
    }

    @NotNull
    public static <D extends Diagnostic> D cast(@NotNull Diagnostic diagnostic, @NotNull Collection<? extends DiagnosticFactory<? extends D>> factories) {
        if (diagnostic == null) {
            DiagnosticFactory.$$$reportNull$$$0(11);
        }
        if (factories == null) {
            DiagnosticFactory.$$$reportNull$$$0(12);
        }
        for (DiagnosticFactory<D> factory2 : factories) {
            if (diagnostic.getFactory() != factory2) continue;
            D d = factory2.cast(diagnostic);
            if (d == null) {
                DiagnosticFactory.$$$reportNull$$$0(13);
            }
            return d;
        }
        throw new IllegalArgumentException("Factory mismatch: expected one of " + factories + " but was " + diagnostic.getFactory());
    }

    public String toString() {
        return this.getName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 10: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 10: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "severity";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/diagnostics/DiagnosticFactory";
                break;
            }
            case 6: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "diagnostic";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factories";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/diagnostics/DiagnosticFactory";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSeverity";
                break;
            }
            case 7: 
            case 10: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "cast";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 10: 
            case 13: {
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "cast";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 10: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

