/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.utils;

import java.util.Collections;
import java.util.List;
import kotlin.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.util.SmartList;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperator;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsBooleanLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsEmpty;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsExpressionStatement;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsIf;
import org.jetbrains.kotlin.js.backend.ast.JsIntLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNew;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsNullLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsObjectLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsPrefixOperation;
import org.jetbrains.kotlin.js.backend.ast.JsPropertyInitializer;
import org.jetbrains.kotlin.js.backend.ast.JsScope;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsStringLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsThisRef;
import org.jetbrains.kotlin.js.backend.ast.JsUnaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsUnaryOperator;
import org.jetbrains.kotlin.js.backend.ast.JsVars;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.backend.ast.metadata.SideEffectKind;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElementKt;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;
import org.jetbrains.kotlin.util.OperatorNameConventions;

public final class JsAstUtils {
    private static final JsNameRef DEFINE_PROPERTY = JsAstUtils.pureFqn("defineProperty", null);
    private static final JsNameRef VALUE = new JsNameRef("value");
    private static final JsPropertyInitializer WRITABLE = new JsPropertyInitializer(JsAstUtils.pureFqn("writable", null), new JsBooleanLiteral(true));
    private static final JsPropertyInitializer ENUMERABLE = new JsPropertyInitializer(JsAstUtils.pureFqn("enumerable", null), new JsBooleanLiteral(false));

    private JsAstUtils() {
    }

    @NotNull
    public static JsStatement convertToStatement(@NotNull JsNode jsNode) {
        if (jsNode == null) {
            JsAstUtils.$$$reportNull$$$0(0);
        }
        assert (jsNode instanceof JsExpression || jsNode instanceof JsStatement) : "Unexpected node of type: " + jsNode.getClass().toString();
        if (jsNode instanceof JsExpression) {
            JsExpression expression2 = (JsExpression)jsNode;
            JsExpressionStatement statement2 = new JsExpressionStatement(expression2);
            if (expression2 instanceof JsNullLiteral || MetadataProperties.getSynthetic(expression2)) {
                MetadataProperties.setSynthetic(statement2, true);
            }
            JsExpressionStatement jsExpressionStatement = statement2;
            if (jsExpressionStatement == null) {
                JsAstUtils.$$$reportNull$$$0(1);
            }
            return jsExpressionStatement;
        }
        JsStatement jsStatement = (JsStatement)jsNode;
        if (jsStatement == null) {
            JsAstUtils.$$$reportNull$$$0(2);
        }
        return jsStatement;
    }

    @NotNull
    public static JsBlock convertToBlock(@NotNull JsNode jsNode) {
        if (jsNode == null) {
            JsAstUtils.$$$reportNull$$$0(3);
        }
        if (jsNode instanceof JsBlock) {
            JsBlock jsBlock = (JsBlock)jsNode;
            if (jsBlock == null) {
                JsAstUtils.$$$reportNull$$$0(4);
            }
            return jsBlock;
        }
        JsBlock block = new JsBlock();
        block.getStatements().add(JsAstUtils.convertToStatement(jsNode));
        JsBlock jsBlock = block;
        if (jsBlock == null) {
            JsAstUtils.$$$reportNull$$$0(5);
        }
        return jsBlock;
    }

    @NotNull
    private static JsStatement deBlockIfPossible(@NotNull JsStatement statement2) {
        if (statement2 == null) {
            JsAstUtils.$$$reportNull$$$0(6);
        }
        if (statement2 instanceof JsBlock && ((JsBlock)statement2).getStatements().size() == 1) {
            JsStatement jsStatement = ((JsBlock)statement2).getStatements().get(0);
            if (jsStatement == null) {
                JsAstUtils.$$$reportNull$$$0(7);
            }
            return jsStatement;
        }
        JsStatement jsStatement = statement2;
        if (jsStatement == null) {
            JsAstUtils.$$$reportNull$$$0(8);
        }
        return jsStatement;
    }

    @NotNull
    public static JsIf newJsIf(@NotNull JsExpression ifExpression, @NotNull JsStatement thenStatement, @Nullable JsStatement elseStatement) {
        if (ifExpression == null) {
            JsAstUtils.$$$reportNull$$$0(9);
        }
        if (thenStatement == null) {
            JsAstUtils.$$$reportNull$$$0(10);
        }
        elseStatement = elseStatement != null ? JsAstUtils.deBlockIfPossible(elseStatement) : null;
        JsIf jsIf = new JsIf(ifExpression, JsAstUtils.deBlockIfPossible(thenStatement), elseStatement);
        if (jsIf == null) {
            JsAstUtils.$$$reportNull$$$0(11);
        }
        return jsIf;
    }

    @NotNull
    public static JsIf newJsIf(@NotNull JsExpression ifExpression, @NotNull JsStatement thenStatement) {
        if (ifExpression == null) {
            JsAstUtils.$$$reportNull$$$0(12);
        }
        if (thenStatement == null) {
            JsAstUtils.$$$reportNull$$$0(13);
        }
        JsIf jsIf = JsAstUtils.newJsIf(ifExpression, thenStatement, null);
        if (jsIf == null) {
            JsAstUtils.$$$reportNull$$$0(14);
        }
        return jsIf;
    }

    @Nullable
    public static JsExpression extractExpressionFromStatement(@Nullable JsStatement statement2) {
        return statement2 instanceof JsExpressionStatement ? ((JsExpressionStatement)statement2).getExpression() : null;
    }

    @NotNull
    public static JsStatement mergeStatementInBlockIfNeeded(@NotNull JsStatement statement2, @NotNull JsBlock block) {
        if (statement2 == null) {
            JsAstUtils.$$$reportNull$$$0(15);
        }
        if (block == null) {
            JsAstUtils.$$$reportNull$$$0(16);
        }
        if (block.isEmpty()) {
            JsStatement jsStatement = statement2;
            if (jsStatement == null) {
                JsAstUtils.$$$reportNull$$$0(17);
            }
            return jsStatement;
        }
        if (JsAstUtils.isEmptyStatement(statement2)) {
            JsStatement jsStatement = JsAstUtils.deBlockIfPossible(block);
            if (jsStatement == null) {
                JsAstUtils.$$$reportNull$$$0(18);
            }
            return jsStatement;
        }
        block.getStatements().add(statement2);
        JsBlock jsBlock = block;
        if (jsBlock == null) {
            JsAstUtils.$$$reportNull$$$0(19);
        }
        return jsBlock;
    }

    public static boolean isEmptyStatement(@NotNull JsStatement statement2) {
        if (statement2 == null) {
            JsAstUtils.$$$reportNull$$$0(20);
        }
        return statement2 instanceof JsEmpty;
    }

    @NotNull
    public static JsInvocation invokeKotlinFunction(@NotNull String name, JsExpression ... argument) {
        if (name == null) {
            JsAstUtils.$$$reportNull$$$0(21);
        }
        if (argument == null) {
            JsAstUtils.$$$reportNull$$$0(22);
        }
        JsInvocation jsInvocation = JsAstUtils.invokeMethod(Namer.kotlinObject(), name, argument);
        if (jsInvocation == null) {
            JsAstUtils.$$$reportNull$$$0(23);
        }
        return jsInvocation;
    }

    @NotNull
    public static JsInvocation invokeMethod(@NotNull JsExpression thisObject, @NotNull String name, JsExpression ... arguments2) {
        if (thisObject == null) {
            JsAstUtils.$$$reportNull$$$0(24);
        }
        if (name == null) {
            JsAstUtils.$$$reportNull$$$0(25);
        }
        if (arguments2 == null) {
            JsAstUtils.$$$reportNull$$$0(26);
        }
        JsInvocation jsInvocation = new JsInvocation((JsExpression)JsAstUtils.pureFqn(name, thisObject), arguments2);
        if (jsInvocation == null) {
            JsAstUtils.$$$reportNull$$$0(27);
        }
        return jsInvocation;
    }

    @NotNull
    public static JsExpression toInt32(@NotNull JsExpression expression2) {
        if (expression2 == null) {
            JsAstUtils.$$$reportNull$$$0(28);
        }
        JsBinaryOperation jsBinaryOperation = new JsBinaryOperation(JsBinaryOperator.BIT_OR, expression2, new JsIntLiteral(0));
        if (jsBinaryOperation == null) {
            JsAstUtils.$$$reportNull$$$0(29);
        }
        return jsBinaryOperation;
    }

    @Nullable
    public static JsExpression extractToInt32Argument(@NotNull JsExpression expression2) {
        if (expression2 == null) {
            JsAstUtils.$$$reportNull$$$0(30);
        }
        if (!(expression2 instanceof JsBinaryOperation)) {
            return null;
        }
        JsBinaryOperation binary = (JsBinaryOperation)expression2;
        if (binary.getOperator() != JsBinaryOperator.BIT_OR) {
            return null;
        }
        if (!(binary.getArg2() instanceof JsIntLiteral)) {
            return null;
        }
        JsIntLiteral arg2 = (JsIntLiteral)binary.getArg2();
        return arg2.value == 0 ? binary.getArg1() : null;
    }

    @NotNull
    public static JsExpression charToInt(@NotNull JsExpression expression2) {
        if (expression2 == null) {
            JsAstUtils.$$$reportNull$$$0(31);
        }
        JsExpression jsExpression = JsAstUtils.toInt32(expression2);
        if (jsExpression == null) {
            JsAstUtils.$$$reportNull$$$0(32);
        }
        return jsExpression;
    }

    @NotNull
    public static JsExpression charToString(@NotNull JsExpression expression2) {
        if (expression2 == null) {
            JsAstUtils.$$$reportNull$$$0(33);
        }
        JsInvocation jsInvocation = new JsInvocation((JsExpression)new JsNameRef("fromCharCode", (JsExpression)new JsNameRef("String")), expression2);
        if (jsInvocation == null) {
            JsAstUtils.$$$reportNull$$$0(34);
        }
        return jsInvocation;
    }

    @NotNull
    public static JsExpression toShort(@NotNull JsExpression expression2) {
        if (expression2 == null) {
            JsAstUtils.$$$reportNull$$$0(35);
        }
        JsInvocation jsInvocation = JsAstUtils.invokeKotlinFunction(OperatorConventions.SHORT.getIdentifier(), expression2);
        if (jsInvocation == null) {
            JsAstUtils.$$$reportNull$$$0(36);
        }
        return jsInvocation;
    }

    @NotNull
    public static JsExpression toByte(@NotNull JsExpression expression2) {
        if (expression2 == null) {
            JsAstUtils.$$$reportNull$$$0(37);
        }
        JsInvocation jsInvocation = JsAstUtils.invokeKotlinFunction(OperatorConventions.BYTE.getIdentifier(), expression2);
        if (jsInvocation == null) {
            JsAstUtils.$$$reportNull$$$0(38);
        }
        return jsInvocation;
    }

    @NotNull
    public static JsExpression toLong(@NotNull JsExpression expression2) {
        if (expression2 == null) {
            JsAstUtils.$$$reportNull$$$0(39);
        }
        JsInvocation jsInvocation = JsAstUtils.invokeKotlinFunction(OperatorConventions.LONG.getIdentifier(), expression2);
        if (jsInvocation == null) {
            JsAstUtils.$$$reportNull$$$0(40);
        }
        return jsInvocation;
    }

    @NotNull
    public static JsExpression toChar(@NotNull JsExpression expression2) {
        if (expression2 == null) {
            JsAstUtils.$$$reportNull$$$0(41);
        }
        JsInvocation jsInvocation = JsAstUtils.invokeKotlinFunction(OperatorConventions.CHAR.getIdentifier(), expression2);
        if (jsInvocation == null) {
            JsAstUtils.$$$reportNull$$$0(42);
        }
        return jsInvocation;
    }

    @NotNull
    public static JsExpression compareTo(@NotNull JsExpression left, @NotNull JsExpression right) {
        if (left == null) {
            JsAstUtils.$$$reportNull$$$0(43);
        }
        if (right == null) {
            JsAstUtils.$$$reportNull$$$0(44);
        }
        JsInvocation jsInvocation = JsAstUtils.invokeKotlinFunction(OperatorNameConventions.COMPARE_TO.getIdentifier(), left, right);
        if (jsInvocation == null) {
            JsAstUtils.$$$reportNull$$$0(45);
        }
        return jsInvocation;
    }

    @NotNull
    public static JsExpression primitiveCompareTo(@NotNull JsExpression left, @NotNull JsExpression right) {
        if (left == null) {
            JsAstUtils.$$$reportNull$$$0(46);
        }
        if (right == null) {
            JsAstUtils.$$$reportNull$$$0(47);
        }
        JsInvocation jsInvocation = JsAstUtils.invokeKotlinFunction("primitiveCompareTo", left, right);
        if (jsInvocation == null) {
            JsAstUtils.$$$reportNull$$$0(48);
        }
        return jsInvocation;
    }

    public static JsExpression newLong(long value) {
        if (value < Integer.MIN_VALUE || value > Integer.MAX_VALUE) {
            int low = (int)value;
            int high = (int)(value >> 32);
            SmartList<JsIntLiteral> args = new SmartList<JsIntLiteral>();
            args.add(new JsIntLiteral(low));
            args.add(new JsIntLiteral(high));
            return new JsNew(Namer.kotlinLong(), args);
        }
        if (value == 0L) {
            return new JsNameRef("ZERO", (JsExpression)Namer.kotlinLong());
        }
        if (value == 1L) {
            return new JsNameRef("ONE", (JsExpression)Namer.kotlinLong());
        }
        if (value == -1L) {
            return new JsNameRef("NEG_ONE", (JsExpression)Namer.kotlinLong());
        }
        return JsAstUtils.longFromInt(new JsIntLiteral((int)value));
    }

    @NotNull
    public static JsExpression longFromInt(@NotNull JsExpression expression2) {
        if (expression2 == null) {
            JsAstUtils.$$$reportNull$$$0(49);
        }
        JsInvocation jsInvocation = JsAstUtils.invokeMethod(Namer.kotlinLong(), "fromInt", expression2);
        if (jsInvocation == null) {
            JsAstUtils.$$$reportNull$$$0(50);
        }
        return jsInvocation;
    }

    @NotNull
    public static JsExpression longFromNumber(@NotNull JsExpression expression2) {
        if (expression2 == null) {
            JsAstUtils.$$$reportNull$$$0(51);
        }
        JsInvocation jsInvocation = JsAstUtils.invokeMethod(Namer.kotlinLong(), "fromNumber", expression2);
        if (jsInvocation == null) {
            JsAstUtils.$$$reportNull$$$0(52);
        }
        return jsInvocation;
    }

    @NotNull
    public static JsExpression compareForObject(@NotNull JsExpression left, @NotNull JsExpression right) {
        if (left == null) {
            JsAstUtils.$$$reportNull$$$0(53);
        }
        if (right == null) {
            JsAstUtils.$$$reportNull$$$0(54);
        }
        JsInvocation jsInvocation = JsAstUtils.invokeMethod(left, Namer.COMPARE_TO_METHOD_NAME, right);
        if (jsInvocation == null) {
            JsAstUtils.$$$reportNull$$$0(55);
        }
        return jsInvocation;
    }

    @NotNull
    public static JsExpression notOptimized(@NotNull JsExpression expression2) {
        if (expression2 == null) {
            JsAstUtils.$$$reportNull$$$0(56);
        }
        if (expression2 instanceof JsUnaryOperation) {
            JsUnaryOperation unary = (JsUnaryOperation)expression2;
            if (unary.getOperator() == JsUnaryOperator.NOT) {
                JsExpression jsExpression = unary.getArg();
                if (jsExpression == null) {
                    JsAstUtils.$$$reportNull$$$0(57);
                }
                return jsExpression;
            }
        } else if (expression2 instanceof JsBinaryOperation) {
            JsBinaryOperation binary = (JsBinaryOperation)expression2;
            switch (binary.getOperator()) {
                case AND: {
                    JsBinaryOperation jsBinaryOperation = JsAstUtils.or(JsAstUtils.notOptimized(binary.getArg1()), JsAstUtils.notOptimized(binary.getArg2()));
                    if (jsBinaryOperation == null) {
                        JsAstUtils.$$$reportNull$$$0(58);
                    }
                    return jsBinaryOperation;
                }
                case OR: {
                    JsBinaryOperation jsBinaryOperation = JsAstUtils.and(JsAstUtils.notOptimized(binary.getArg1()), JsAstUtils.notOptimized(binary.getArg2()));
                    if (jsBinaryOperation == null) {
                        JsAstUtils.$$$reportNull$$$0(59);
                    }
                    return jsBinaryOperation;
                }
                case EQ: {
                    JsBinaryOperation jsBinaryOperation = new JsBinaryOperation(JsBinaryOperator.NEQ, binary.getArg1(), binary.getArg2());
                    if (jsBinaryOperation == null) {
                        JsAstUtils.$$$reportNull$$$0(60);
                    }
                    return jsBinaryOperation;
                }
                case NEQ: {
                    JsBinaryOperation jsBinaryOperation = new JsBinaryOperation(JsBinaryOperator.EQ, binary.getArg1(), binary.getArg2());
                    if (jsBinaryOperation == null) {
                        JsAstUtils.$$$reportNull$$$0(61);
                    }
                    return jsBinaryOperation;
                }
                case REF_EQ: {
                    JsBinaryOperation jsBinaryOperation = JsAstUtils.inequality(binary.getArg1(), binary.getArg2());
                    if (jsBinaryOperation == null) {
                        JsAstUtils.$$$reportNull$$$0(62);
                    }
                    return jsBinaryOperation;
                }
                case REF_NEQ: {
                    JsBinaryOperation jsBinaryOperation = JsAstUtils.equality(binary.getArg1(), binary.getArg2());
                    if (jsBinaryOperation == null) {
                        JsAstUtils.$$$reportNull$$$0(63);
                    }
                    return jsBinaryOperation;
                }
                case LT: {
                    JsBinaryOperation jsBinaryOperation = JsAstUtils.greaterThanEq(binary.getArg1(), binary.getArg2());
                    if (jsBinaryOperation == null) {
                        JsAstUtils.$$$reportNull$$$0(64);
                    }
                    return jsBinaryOperation;
                }
                case LTE: {
                    JsBinaryOperation jsBinaryOperation = JsAstUtils.greaterThan(binary.getArg1(), binary.getArg2());
                    if (jsBinaryOperation == null) {
                        JsAstUtils.$$$reportNull$$$0(65);
                    }
                    return jsBinaryOperation;
                }
                case GT: {
                    JsBinaryOperation jsBinaryOperation = JsAstUtils.lessThanEq(binary.getArg1(), binary.getArg2());
                    if (jsBinaryOperation == null) {
                        JsAstUtils.$$$reportNull$$$0(66);
                    }
                    return jsBinaryOperation;
                }
                case GTE: {
                    JsBinaryOperation jsBinaryOperation = JsAstUtils.lessThan(binary.getArg1(), binary.getArg2());
                    if (jsBinaryOperation == null) {
                        JsAstUtils.$$$reportNull$$$0(67);
                    }
                    return jsBinaryOperation;
                }
            }
        }
        JsPrefixOperation jsPrefixOperation = JsAstUtils.not(expression2);
        if (jsPrefixOperation == null) {
            JsAstUtils.$$$reportNull$$$0(68);
        }
        return jsPrefixOperation;
    }

    @NotNull
    public static JsBinaryOperation and(@NotNull JsExpression op1, @NotNull JsExpression op2) {
        if (op1 == null) {
            JsAstUtils.$$$reportNull$$$0(69);
        }
        if (op2 == null) {
            JsAstUtils.$$$reportNull$$$0(70);
        }
        JsBinaryOperation jsBinaryOperation = new JsBinaryOperation(JsBinaryOperator.AND, op1, op2);
        if (jsBinaryOperation == null) {
            JsAstUtils.$$$reportNull$$$0(71);
        }
        return jsBinaryOperation;
    }

    @NotNull
    public static JsBinaryOperation or(@NotNull JsExpression op1, @NotNull JsExpression op2) {
        if (op1 == null) {
            JsAstUtils.$$$reportNull$$$0(72);
        }
        if (op2 == null) {
            JsAstUtils.$$$reportNull$$$0(73);
        }
        JsBinaryOperation jsBinaryOperation = new JsBinaryOperation(JsBinaryOperator.OR, op1, op2);
        if (jsBinaryOperation == null) {
            JsAstUtils.$$$reportNull$$$0(74);
        }
        return jsBinaryOperation;
    }

    @NotNull
    public static JsBinaryOperation equality(@NotNull JsExpression arg1, @NotNull JsExpression arg2) {
        if (arg1 == null) {
            JsAstUtils.$$$reportNull$$$0(77);
        }
        if (arg2 == null) {
            JsAstUtils.$$$reportNull$$$0(78);
        }
        JsBinaryOperation jsBinaryOperation = new JsBinaryOperation(JsBinaryOperator.REF_EQ, arg1, arg2);
        if (jsBinaryOperation == null) {
            JsAstUtils.$$$reportNull$$$0(79);
        }
        return jsBinaryOperation;
    }

    @NotNull
    public static JsBinaryOperation inequality(@NotNull JsExpression arg1, @NotNull JsExpression arg2) {
        if (arg1 == null) {
            JsAstUtils.$$$reportNull$$$0(80);
        }
        if (arg2 == null) {
            JsAstUtils.$$$reportNull$$$0(81);
        }
        JsBinaryOperation jsBinaryOperation = new JsBinaryOperation(JsBinaryOperator.REF_NEQ, arg1, arg2);
        if (jsBinaryOperation == null) {
            JsAstUtils.$$$reportNull$$$0(82);
        }
        return jsBinaryOperation;
    }

    @NotNull
    public static JsBinaryOperation lessThanEq(@NotNull JsExpression arg1, @NotNull JsExpression arg2) {
        if (arg1 == null) {
            JsAstUtils.$$$reportNull$$$0(83);
        }
        if (arg2 == null) {
            JsAstUtils.$$$reportNull$$$0(84);
        }
        JsBinaryOperation jsBinaryOperation = new JsBinaryOperation(JsBinaryOperator.LTE, arg1, arg2);
        if (jsBinaryOperation == null) {
            JsAstUtils.$$$reportNull$$$0(85);
        }
        return jsBinaryOperation;
    }

    @NotNull
    public static JsBinaryOperation lessThan(@NotNull JsExpression arg1, @NotNull JsExpression arg2) {
        if (arg1 == null) {
            JsAstUtils.$$$reportNull$$$0(86);
        }
        if (arg2 == null) {
            JsAstUtils.$$$reportNull$$$0(87);
        }
        JsBinaryOperation jsBinaryOperation = new JsBinaryOperation(JsBinaryOperator.LT, arg1, arg2);
        if (jsBinaryOperation == null) {
            JsAstUtils.$$$reportNull$$$0(88);
        }
        return jsBinaryOperation;
    }

    @NotNull
    public static JsBinaryOperation greaterThan(@NotNull JsExpression arg1, @NotNull JsExpression arg2) {
        if (arg1 == null) {
            JsAstUtils.$$$reportNull$$$0(89);
        }
        if (arg2 == null) {
            JsAstUtils.$$$reportNull$$$0(90);
        }
        JsBinaryOperation jsBinaryOperation = new JsBinaryOperation(JsBinaryOperator.GT, arg1, arg2);
        if (jsBinaryOperation == null) {
            JsAstUtils.$$$reportNull$$$0(91);
        }
        return jsBinaryOperation;
    }

    @NotNull
    public static JsBinaryOperation greaterThanEq(@NotNull JsExpression arg1, @NotNull JsExpression arg2) {
        if (arg1 == null) {
            JsAstUtils.$$$reportNull$$$0(92);
        }
        if (arg2 == null) {
            JsAstUtils.$$$reportNull$$$0(93);
        }
        JsBinaryOperation jsBinaryOperation = new JsBinaryOperation(JsBinaryOperator.GTE, arg1, arg2);
        if (jsBinaryOperation == null) {
            JsAstUtils.$$$reportNull$$$0(94);
        }
        return jsBinaryOperation;
    }

    @NotNull
    public static JsBinaryOperation assignment(@NotNull JsExpression left, @NotNull JsExpression right) {
        if (left == null) {
            JsAstUtils.$$$reportNull$$$0(95);
        }
        if (right == null) {
            JsAstUtils.$$$reportNull$$$0(96);
        }
        JsBinaryOperation jsBinaryOperation = new JsBinaryOperation(JsBinaryOperator.ASG, left, right);
        if (jsBinaryOperation == null) {
            JsAstUtils.$$$reportNull$$$0(97);
        }
        return jsBinaryOperation;
    }

    @NotNull
    public static JsStatement assignmentToThisField(@NotNull String fieldName, @NotNull JsExpression right) {
        if (fieldName == null) {
            JsAstUtils.$$$reportNull$$$0(98);
        }
        if (right == null) {
            JsAstUtils.$$$reportNull$$$0(99);
        }
        JsStatement jsStatement = JsAstUtils.assignment(new JsNameRef(fieldName, (JsExpression)new JsThisRef()), right).source(right.getSource()).makeStmt();
        if (jsStatement == null) {
            JsAstUtils.$$$reportNull$$$0(100);
        }
        return jsStatement;
    }

    public static JsStatement asSyntheticStatement(@NotNull JsExpression expression2) {
        if (expression2 == null) {
            JsAstUtils.$$$reportNull$$$0(101);
        }
        JsExpressionStatement statement2 = new JsExpressionStatement(expression2);
        MetadataProperties.setSynthetic(statement2, true);
        return statement2;
    }

    @Nullable
    public static Pair<JsExpression, JsExpression> decomposeAssignment(@NotNull JsExpression expr) {
        if (expr == null) {
            JsAstUtils.$$$reportNull$$$0(102);
        }
        if (!(expr instanceof JsBinaryOperation)) {
            return null;
        }
        JsBinaryOperation binary = (JsBinaryOperation)expr;
        if (binary.getOperator() != JsBinaryOperator.ASG) {
            return null;
        }
        return new Pair<JsExpression, JsExpression>(binary.getArg1(), binary.getArg2());
    }

    @Nullable
    public static Pair<JsName, JsExpression> decomposeAssignmentToVariable(@NotNull JsExpression expr) {
        Pair<JsExpression, JsExpression> assignment;
        if (expr == null) {
            JsAstUtils.$$$reportNull$$$0(103);
        }
        if ((assignment = JsAstUtils.decomposeAssignment(expr)) == null || !(assignment.getFirst() instanceof JsNameRef)) {
            return null;
        }
        JsNameRef nameRef = (JsNameRef)assignment.getFirst();
        if (nameRef.getName() == null || nameRef.getQualifier() != null) {
            return null;
        }
        return new Pair<JsName, JsExpression>(nameRef.getName(), assignment.getSecond());
    }

    @NotNull
    public static JsBinaryOperation sum(@NotNull JsExpression left, @NotNull JsExpression right) {
        if (left == null) {
            JsAstUtils.$$$reportNull$$$0(104);
        }
        if (right == null) {
            JsAstUtils.$$$reportNull$$$0(105);
        }
        JsBinaryOperation jsBinaryOperation = new JsBinaryOperation(JsBinaryOperator.ADD, left, right);
        if (jsBinaryOperation == null) {
            JsAstUtils.$$$reportNull$$$0(106);
        }
        return jsBinaryOperation;
    }

    @NotNull
    public static JsBinaryOperation addAssign(@NotNull JsExpression left, @NotNull JsExpression right) {
        if (left == null) {
            JsAstUtils.$$$reportNull$$$0(107);
        }
        if (right == null) {
            JsAstUtils.$$$reportNull$$$0(108);
        }
        JsBinaryOperation jsBinaryOperation = new JsBinaryOperation(JsBinaryOperator.ASG_ADD, left, right);
        if (jsBinaryOperation == null) {
            JsAstUtils.$$$reportNull$$$0(109);
        }
        return jsBinaryOperation;
    }

    @NotNull
    public static JsBinaryOperation subtract(@NotNull JsExpression left, @NotNull JsExpression right) {
        if (left == null) {
            JsAstUtils.$$$reportNull$$$0(110);
        }
        if (right == null) {
            JsAstUtils.$$$reportNull$$$0(111);
        }
        JsBinaryOperation jsBinaryOperation = new JsBinaryOperation(JsBinaryOperator.SUB, left, right);
        if (jsBinaryOperation == null) {
            JsAstUtils.$$$reportNull$$$0(112);
        }
        return jsBinaryOperation;
    }

    @NotNull
    public static JsBinaryOperation mul(@NotNull JsExpression left, @NotNull JsExpression right) {
        if (left == null) {
            JsAstUtils.$$$reportNull$$$0(113);
        }
        if (right == null) {
            JsAstUtils.$$$reportNull$$$0(114);
        }
        JsBinaryOperation jsBinaryOperation = new JsBinaryOperation(JsBinaryOperator.MUL, left, right);
        if (jsBinaryOperation == null) {
            JsAstUtils.$$$reportNull$$$0(115);
        }
        return jsBinaryOperation;
    }

    @NotNull
    public static JsBinaryOperation div(@NotNull JsExpression left, @NotNull JsExpression right) {
        if (left == null) {
            JsAstUtils.$$$reportNull$$$0(116);
        }
        if (right == null) {
            JsAstUtils.$$$reportNull$$$0(117);
        }
        JsBinaryOperation jsBinaryOperation = new JsBinaryOperation(JsBinaryOperator.DIV, left, right);
        if (jsBinaryOperation == null) {
            JsAstUtils.$$$reportNull$$$0(118);
        }
        return jsBinaryOperation;
    }

    @NotNull
    public static JsBinaryOperation mod(@NotNull JsExpression left, @NotNull JsExpression right) {
        if (left == null) {
            JsAstUtils.$$$reportNull$$$0(119);
        }
        if (right == null) {
            JsAstUtils.$$$reportNull$$$0(120);
        }
        JsBinaryOperation jsBinaryOperation = new JsBinaryOperation(JsBinaryOperator.MOD, left, right);
        if (jsBinaryOperation == null) {
            JsAstUtils.$$$reportNull$$$0(121);
        }
        return jsBinaryOperation;
    }

    @NotNull
    public static JsPrefixOperation not(@NotNull JsExpression expression2) {
        if (expression2 == null) {
            JsAstUtils.$$$reportNull$$$0(122);
        }
        JsPrefixOperation jsPrefixOperation = new JsPrefixOperation(JsUnaryOperator.NOT, expression2);
        if (jsPrefixOperation == null) {
            JsAstUtils.$$$reportNull$$$0(123);
        }
        return jsPrefixOperation;
    }

    @NotNull
    public static JsBinaryOperation typeOfIs(@NotNull JsExpression expression2, @NotNull JsStringLiteral string) {
        if (expression2 == null) {
            JsAstUtils.$$$reportNull$$$0(124);
        }
        if (string == null) {
            JsAstUtils.$$$reportNull$$$0(125);
        }
        JsBinaryOperation jsBinaryOperation = JsAstUtils.equality(new JsPrefixOperation(JsUnaryOperator.TYPEOF, expression2), string);
        if (jsBinaryOperation == null) {
            JsAstUtils.$$$reportNull$$$0(126);
        }
        return jsBinaryOperation;
    }

    @NotNull
    public static JsVars newVar(@NotNull JsName name, @Nullable JsExpression expr) {
        if (name == null) {
            JsAstUtils.$$$reportNull$$$0(127);
        }
        JsVars jsVars = new JsVars(new JsVars.JsVar(name, expr));
        if (jsVars == null) {
            JsAstUtils.$$$reportNull$$$0(128);
        }
        return jsVars;
    }

    @NotNull
    public static JsExpression newSequence(@NotNull List<JsExpression> expressions) {
        if (expressions == null) {
            JsAstUtils.$$$reportNull$$$0(129);
        }
        assert (!expressions.isEmpty());
        if (expressions.size() == 1) {
            JsExpression jsExpression = expressions.get(0);
            if (jsExpression == null) {
                JsAstUtils.$$$reportNull$$$0(130);
            }
            return jsExpression;
        }
        JsExpression result2 = expressions.get(0);
        for (int i = 1; i < expressions.size(); ++i) {
            result2 = new JsBinaryOperation(JsBinaryOperator.COMMA, result2, expressions.get(i));
        }
        JsExpression jsExpression = result2;
        if (jsExpression == null) {
            JsAstUtils.$$$reportNull$$$0(131);
        }
        return jsExpression;
    }

    @NotNull
    public static JsFunction createFunctionWithEmptyBody(@NotNull JsScope parent2) {
        if (parent2 == null) {
            JsAstUtils.$$$reportNull$$$0(132);
        }
        JsFunction jsFunction = new JsFunction(parent2, new JsBlock(), "<anonymous>");
        if (jsFunction == null) {
            JsAstUtils.$$$reportNull$$$0(133);
        }
        return jsFunction;
    }

    @NotNull
    public static List<JsExpression> toStringLiteralList(@NotNull List<String> strings) {
        if (strings == null) {
            JsAstUtils.$$$reportNull$$$0(134);
        }
        if (strings.isEmpty()) {
            List<JsExpression> list2 = Collections.emptyList();
            if (list2 == null) {
                JsAstUtils.$$$reportNull$$$0(135);
            }
            return list2;
        }
        SmartList<JsExpression> result2 = new SmartList<JsExpression>();
        for (String str : strings) {
            result2.add(new JsStringLiteral(str));
        }
        SmartList<JsExpression> smartList = result2;
        if (smartList == null) {
            JsAstUtils.$$$reportNull$$$0(136);
        }
        return smartList;
    }

    @NotNull
    public static JsInvocation defineProperty(@NotNull JsExpression receiver, @NotNull String name, @NotNull JsExpression value) {
        if (receiver == null) {
            JsAstUtils.$$$reportNull$$$0(137);
        }
        if (name == null) {
            JsAstUtils.$$$reportNull$$$0(138);
        }
        if (value == null) {
            JsAstUtils.$$$reportNull$$$0(139);
        }
        JsInvocation jsInvocation = new JsInvocation((JsExpression)DEFINE_PROPERTY.deepCopy(), receiver, new JsStringLiteral(name), value);
        if (jsInvocation == null) {
            JsAstUtils.$$$reportNull$$$0(140);
        }
        return jsInvocation;
    }

    @NotNull
    public static JsStatement defineSimpleProperty(@NotNull JsName name, @NotNull JsExpression value, @Nullable SourceElement source) {
        if (name == null) {
            JsAstUtils.$$$reportNull$$$0(141);
        }
        if (value == null) {
            JsAstUtils.$$$reportNull$$$0(142);
        }
        JsBinaryOperation assignment = JsAstUtils.assignment(new JsNameRef(name, (JsExpression)new JsThisRef()), value);
        if (source != null) {
            assignment.setSource(KotlinSourceElementKt.getPsi(source));
        }
        JsStatement jsStatement = assignment.makeStmt();
        if (jsStatement == null) {
            JsAstUtils.$$$reportNull$$$0(143);
        }
        return jsStatement;
    }

    @NotNull
    public static JsObjectLiteral createDataDescriptor(@NotNull JsExpression value, boolean writable, boolean enumerable) {
        if (value == null) {
            JsAstUtils.$$$reportNull$$$0(144);
        }
        JsObjectLiteral dataDescriptor = new JsObjectLiteral();
        dataDescriptor.getPropertyInitializers().add(new JsPropertyInitializer(VALUE.deepCopy(), value));
        if (writable) {
            dataDescriptor.getPropertyInitializers().add(WRITABLE.deepCopy());
        }
        if (enumerable) {
            dataDescriptor.getPropertyInitializers().add(ENUMERABLE.deepCopy());
        }
        JsObjectLiteral jsObjectLiteral = dataDescriptor;
        if (jsObjectLiteral == null) {
            JsAstUtils.$$$reportNull$$$0(145);
        }
        return jsObjectLiteral;
    }

    @NotNull
    public static JsObjectLiteral wrapValue(@NotNull JsExpression label, @NotNull JsExpression value) {
        if (label == null) {
            JsAstUtils.$$$reportNull$$$0(146);
        }
        if (value == null) {
            JsAstUtils.$$$reportNull$$$0(147);
        }
        JsObjectLiteral jsObjectLiteral = new JsObjectLiteral(Collections.singletonList(new JsPropertyInitializer(label, value)));
        if (jsObjectLiteral == null) {
            JsAstUtils.$$$reportNull$$$0(148);
        }
        return jsObjectLiteral;
    }

    public static JsExpression replaceRootReference(@NotNull JsNameRef fullQualifier, @NotNull JsExpression newQualifier) {
        if (fullQualifier == null) {
            JsAstUtils.$$$reportNull$$$0(149);
        }
        if (newQualifier == null) {
            JsAstUtils.$$$reportNull$$$0(150);
        }
        if (fullQualifier.getQualifier() == null) {
            assert (Namer.getRootPackageName().equals(fullQualifier.getIdent())) : "Expected root package, but: " + fullQualifier.getIdent();
            return newQualifier;
        }
        JsNameRef qualifier = fullQualifier = fullQualifier.deepCopy();
        while (true) {
            JsExpression parent2 = qualifier.getQualifier();
            assert (parent2 instanceof JsNameRef) : "unexpected qualifier: " + parent2 + ", original: " + fullQualifier;
            if (((JsNameRef)parent2).getQualifier() == null) {
                assert (Namer.getRootPackageName().equals(((JsNameRef)parent2).getIdent()));
                qualifier.setQualifier(newQualifier);
                return fullQualifier;
            }
            qualifier = (JsNameRef)parent2;
        }
    }

    @NotNull
    public static List<JsStatement> flattenStatement(@NotNull JsStatement statement2) {
        if (statement2 == null) {
            JsAstUtils.$$$reportNull$$$0(151);
        }
        if (statement2 instanceof JsBlock) {
            List<JsStatement> list2 = ((JsBlock)statement2).getStatements();
            if (list2 == null) {
                JsAstUtils.$$$reportNull$$$0(152);
            }
            return list2;
        }
        SmartList<JsStatement> smartList = new SmartList<JsStatement>(statement2);
        if (smartList == null) {
            JsAstUtils.$$$reportNull$$$0(153);
        }
        return smartList;
    }

    @NotNull
    public static JsNameRef pureFqn(@NotNull String identifier, @Nullable JsExpression qualifier) {
        if (identifier == null) {
            JsAstUtils.$$$reportNull$$$0(154);
        }
        JsNameRef result2 = new JsNameRef(identifier, qualifier);
        MetadataProperties.setSideEffects(result2, SideEffectKind.PURE);
        JsNameRef jsNameRef = result2;
        if (jsNameRef == null) {
            JsAstUtils.$$$reportNull$$$0(155);
        }
        return jsNameRef;
    }

    @NotNull
    public static JsNameRef pureFqn(@NotNull JsName identifier, @Nullable JsExpression qualifier) {
        if (identifier == null) {
            JsAstUtils.$$$reportNull$$$0(156);
        }
        JsNameRef result2 = new JsNameRef(identifier, qualifier);
        MetadataProperties.setSideEffects(result2, SideEffectKind.PURE);
        JsNameRef jsNameRef = result2;
        if (jsNameRef == null) {
            JsAstUtils.$$$reportNull$$$0(157);
        }
        return jsNameRef;
    }

    @NotNull
    public static JsInvocation invokeBind(@NotNull JsExpression receiver, @NotNull JsExpression method) {
        if (receiver == null) {
            JsAstUtils.$$$reportNull$$$0(158);
        }
        if (method == null) {
            JsAstUtils.$$$reportNull$$$0(159);
        }
        JsInvocation jsInvocation = JsAstUtils.invokeMethod(method, "bind", receiver);
        if (jsInvocation == null) {
            JsAstUtils.$$$reportNull$$$0(160);
        }
        return jsInvocation;
    }

    public static boolean isUndefinedExpression(JsExpression expression2) {
        if (!(expression2 instanceof JsUnaryOperation)) {
            return false;
        }
        JsUnaryOperation unary = (JsUnaryOperation)expression2;
        return unary.getOperator() == JsUnaryOperator.VOID;
    }

    @NotNull
    public static JsExpression defineGetter(@NotNull JsExpression receiver, @NotNull String name, @NotNull JsExpression body) {
        if (receiver == null) {
            JsAstUtils.$$$reportNull$$$0(161);
        }
        if (name == null) {
            JsAstUtils.$$$reportNull$$$0(162);
        }
        if (body == null) {
            JsAstUtils.$$$reportNull$$$0(163);
        }
        JsObjectLiteral propertyLiteral = new JsObjectLiteral(true);
        propertyLiteral.getPropertyInitializers().add(new JsPropertyInitializer(new JsNameRef("get"), body));
        JsInvocation jsInvocation = JsAstUtils.defineProperty(receiver, name, propertyLiteral);
        if (jsInvocation == null) {
            JsAstUtils.$$$reportNull$$$0(164);
        }
        return jsInvocation;
    }

    @NotNull
    public static JsExpression prototypeOf(@NotNull JsExpression expression2) {
        if (expression2 == null) {
            JsAstUtils.$$$reportNull$$$0(165);
        }
        JsNameRef jsNameRef = JsAstUtils.pureFqn("prototype", expression2);
        if (jsNameRef == null) {
            JsAstUtils.$$$reportNull$$$0(166);
        }
        return jsNameRef;
    }

    @NotNull
    public static JsExpression stateMachineReceiver() {
        JsNameRef result2 = new JsNameRef("$this$");
        MetadataProperties.setCoroutineReceiver(result2, true);
        JsNameRef jsNameRef = result2;
        if (jsNameRef == null) {
            JsAstUtils.$$$reportNull$$$0(167);
        }
        return jsNameRef;
    }

    static {
        JsNameRef globalObjectReference = new JsNameRef("Object");
        DEFINE_PROPERTY.setQualifier(globalObjectReference);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 11: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 23: 
            case 27: 
            case 29: 
            case 32: 
            case 34: 
            case 36: 
            case 38: 
            case 40: 
            case 42: 
            case 45: 
            case 48: 
            case 50: 
            case 52: 
            case 55: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 71: 
            case 74: 
            case 79: 
            case 82: 
            case 85: 
            case 88: 
            case 91: 
            case 94: 
            case 97: 
            case 100: 
            case 106: 
            case 109: 
            case 112: 
            case 115: 
            case 118: 
            case 121: 
            case 123: 
            case 126: 
            case 128: 
            case 130: 
            case 131: 
            case 133: 
            case 135: 
            case 136: 
            case 140: 
            case 143: 
            case 145: 
            case 148: 
            case 152: 
            case 153: 
            case 155: 
            case 157: 
            case 160: 
            case 164: 
            case 166: 
            case 167: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 11: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 23: 
            case 27: 
            case 29: 
            case 32: 
            case 34: 
            case 36: 
            case 38: 
            case 40: 
            case 42: 
            case 45: 
            case 48: 
            case 50: 
            case 52: 
            case 55: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 71: 
            case 74: 
            case 79: 
            case 82: 
            case 85: 
            case 88: 
            case 91: 
            case 94: 
            case 97: 
            case 100: 
            case 106: 
            case 109: 
            case 112: 
            case 115: 
            case 118: 
            case 121: 
            case 123: 
            case 126: 
            case 128: 
            case 130: 
            case 131: 
            case 133: 
            case 135: 
            case 136: 
            case 140: 
            case 143: 
            case 145: 
            case 148: 
            case 152: 
            case 153: 
            case 155: 
            case 157: 
            case 160: 
            case 164: 
            case 166: 
            case 167: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsNode";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 11: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 23: 
            case 27: 
            case 29: 
            case 32: 
            case 34: 
            case 36: 
            case 38: 
            case 40: 
            case 42: 
            case 45: 
            case 48: 
            case 50: 
            case 52: 
            case 55: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 71: 
            case 74: 
            case 79: 
            case 82: 
            case 85: 
            case 88: 
            case 91: 
            case 94: 
            case 97: 
            case 100: 
            case 106: 
            case 109: 
            case 112: 
            case 115: 
            case 118: 
            case 121: 
            case 123: 
            case 126: 
            case 128: 
            case 130: 
            case 131: 
            case 133: 
            case 135: 
            case 136: 
            case 140: 
            case 143: 
            case 145: 
            case 148: 
            case 152: 
            case 153: 
            case 155: 
            case 157: 
            case 160: 
            case 164: 
            case 166: 
            case 167: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/js/translate/utils/JsAstUtils";
                break;
            }
            case 6: 
            case 15: 
            case 20: 
            case 151: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ifExpression";
                break;
            }
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thenStatement";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
            case 21: 
            case 25: 
            case 127: 
            case 138: 
            case 141: 
            case 162: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argument";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thisObject";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 28: 
            case 30: 
            case 31: 
            case 33: 
            case 35: 
            case 37: 
            case 39: 
            case 41: 
            case 49: 
            case 51: 
            case 56: 
            case 101: 
            case 122: 
            case 124: 
            case 165: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 43: 
            case 46: 
            case 53: 
            case 95: 
            case 104: 
            case 107: 
            case 110: 
            case 113: 
            case 116: 
            case 119: {
                objectArray2 = objectArray3;
                objectArray3[0] = "left";
                break;
            }
            case 44: 
            case 47: 
            case 54: 
            case 96: 
            case 99: 
            case 105: 
            case 108: 
            case 111: 
            case 114: 
            case 117: 
            case 120: {
                objectArray2 = objectArray3;
                objectArray3[0] = "right";
                break;
            }
            case 69: 
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "op1";
                break;
            }
            case 70: 
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "op2";
                break;
            }
            case 75: 
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selector";
                break;
            }
            case 77: 
            case 80: 
            case 83: 
            case 86: 
            case 89: 
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arg1";
                break;
            }
            case 78: 
            case 81: 
            case 84: 
            case 87: 
            case 90: 
            case 93: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arg2";
                break;
            }
            case 98: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldName";
                break;
            }
            case 102: 
            case 103: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 125: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
            case 129: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressions";
                break;
            }
            case 132: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 134: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strings";
                break;
            }
            case 137: 
            case 158: 
            case 161: {
                objectArray2 = objectArray3;
                objectArray3[0] = "receiver";
                break;
            }
            case 139: 
            case 142: 
            case 144: 
            case 147: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 146: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
            case 149: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fullQualifier";
                break;
            }
            case 150: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newQualifier";
                break;
            }
            case 154: 
            case 156: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 159: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 163: {
                objectArray2 = objectArray3;
                objectArray3[0] = "body";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/js/translate/utils/JsAstUtils";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "convertToStatement";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "convertToBlock";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "deBlockIfPossible";
                break;
            }
            case 11: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "newJsIf";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "mergeStatementInBlockIfNeeded";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "invokeKotlinFunction";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "invokeMethod";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "toInt32";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "charToInt";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "charToString";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "toShort";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "toByte";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "toLong";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "toChar";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "compareTo";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "primitiveCompareTo";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "longFromInt";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "longFromNumber";
                break;
            }
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "compareForObject";
                break;
            }
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: {
                objectArray = objectArray2;
                objectArray2[1] = "notOptimized";
                break;
            }
            case 71: {
                objectArray = objectArray2;
                objectArray2[1] = "and";
                break;
            }
            case 74: {
                objectArray = objectArray2;
                objectArray2[1] = "or";
                break;
            }
            case 79: {
                objectArray = objectArray2;
                objectArray2[1] = "equality";
                break;
            }
            case 82: {
                objectArray = objectArray2;
                objectArray2[1] = "inequality";
                break;
            }
            case 85: {
                objectArray = objectArray2;
                objectArray2[1] = "lessThanEq";
                break;
            }
            case 88: {
                objectArray = objectArray2;
                objectArray2[1] = "lessThan";
                break;
            }
            case 91: {
                objectArray = objectArray2;
                objectArray2[1] = "greaterThan";
                break;
            }
            case 94: {
                objectArray = objectArray2;
                objectArray2[1] = "greaterThanEq";
                break;
            }
            case 97: {
                objectArray = objectArray2;
                objectArray2[1] = "assignment";
                break;
            }
            case 100: {
                objectArray = objectArray2;
                objectArray2[1] = "assignmentToThisField";
                break;
            }
            case 106: {
                objectArray = objectArray2;
                objectArray2[1] = "sum";
                break;
            }
            case 109: {
                objectArray = objectArray2;
                objectArray2[1] = "addAssign";
                break;
            }
            case 112: {
                objectArray = objectArray2;
                objectArray2[1] = "subtract";
                break;
            }
            case 115: {
                objectArray = objectArray2;
                objectArray2[1] = "mul";
                break;
            }
            case 118: {
                objectArray = objectArray2;
                objectArray2[1] = "div";
                break;
            }
            case 121: {
                objectArray = objectArray2;
                objectArray2[1] = "mod";
                break;
            }
            case 123: {
                objectArray = objectArray2;
                objectArray2[1] = "not";
                break;
            }
            case 126: {
                objectArray = objectArray2;
                objectArray2[1] = "typeOfIs";
                break;
            }
            case 128: {
                objectArray = objectArray2;
                objectArray2[1] = "newVar";
                break;
            }
            case 130: 
            case 131: {
                objectArray = objectArray2;
                objectArray2[1] = "newSequence";
                break;
            }
            case 133: {
                objectArray = objectArray2;
                objectArray2[1] = "createFunctionWithEmptyBody";
                break;
            }
            case 135: 
            case 136: {
                objectArray = objectArray2;
                objectArray2[1] = "toStringLiteralList";
                break;
            }
            case 140: {
                objectArray = objectArray2;
                objectArray2[1] = "defineProperty";
                break;
            }
            case 143: {
                objectArray = objectArray2;
                objectArray2[1] = "defineSimpleProperty";
                break;
            }
            case 145: {
                objectArray = objectArray2;
                objectArray2[1] = "createDataDescriptor";
                break;
            }
            case 148: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapValue";
                break;
            }
            case 152: 
            case 153: {
                objectArray = objectArray2;
                objectArray2[1] = "flattenStatement";
                break;
            }
            case 155: 
            case 157: {
                objectArray = objectArray2;
                objectArray2[1] = "pureFqn";
                break;
            }
            case 160: {
                objectArray = objectArray2;
                objectArray2[1] = "invokeBind";
                break;
            }
            case 164: {
                objectArray = objectArray2;
                objectArray2[1] = "defineGetter";
                break;
            }
            case 166: {
                objectArray = objectArray2;
                objectArray2[1] = "prototypeOf";
                break;
            }
            case 167: {
                objectArray = objectArray2;
                objectArray2[1] = "stateMachineReceiver";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "convertToStatement";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 11: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 23: 
            case 27: 
            case 29: 
            case 32: 
            case 34: 
            case 36: 
            case 38: 
            case 40: 
            case 42: 
            case 45: 
            case 48: 
            case 50: 
            case 52: 
            case 55: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 71: 
            case 74: 
            case 79: 
            case 82: 
            case 85: 
            case 88: 
            case 91: 
            case 94: 
            case 97: 
            case 100: 
            case 106: 
            case 109: 
            case 112: 
            case 115: 
            case 118: 
            case 121: 
            case 123: 
            case 126: 
            case 128: 
            case 130: 
            case 131: 
            case 133: 
            case 135: 
            case 136: 
            case 140: 
            case 143: 
            case 145: 
            case 148: 
            case 152: 
            case 153: 
            case 155: 
            case 157: 
            case 160: 
            case 164: 
            case 166: 
            case 167: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "convertToBlock";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "deBlockIfPossible";
                break;
            }
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "newJsIf";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "mergeStatementInBlockIfNeeded";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isEmptyStatement";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "invokeKotlinFunction";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "invokeMethod";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "toInt32";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "extractToInt32Argument";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "charToInt";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "charToString";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "toShort";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "toByte";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "toLong";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "toChar";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "compareTo";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "primitiveCompareTo";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "longFromInt";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "longFromNumber";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "compareForObject";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "notOptimized";
                break;
            }
            case 69: 
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "and";
                break;
            }
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "or";
                break;
            }
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "setQualifier";
                break;
            }
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "setQualifierForNameRef";
                break;
            }
            case 77: 
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "equality";
                break;
            }
            case 80: 
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "inequality";
                break;
            }
            case 83: 
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "lessThanEq";
                break;
            }
            case 86: 
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "lessThan";
                break;
            }
            case 89: 
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "greaterThan";
                break;
            }
            case 92: 
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "greaterThanEq";
                break;
            }
            case 95: 
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "assignment";
                break;
            }
            case 98: 
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "assignmentToThisField";
                break;
            }
            case 101: {
                objectArray = objectArray;
                objectArray[2] = "asSyntheticStatement";
                break;
            }
            case 102: {
                objectArray = objectArray;
                objectArray[2] = "decomposeAssignment";
                break;
            }
            case 103: {
                objectArray = objectArray;
                objectArray[2] = "decomposeAssignmentToVariable";
                break;
            }
            case 104: 
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "sum";
                break;
            }
            case 107: 
            case 108: {
                objectArray = objectArray;
                objectArray[2] = "addAssign";
                break;
            }
            case 110: 
            case 111: {
                objectArray = objectArray;
                objectArray[2] = "subtract";
                break;
            }
            case 113: 
            case 114: {
                objectArray = objectArray;
                objectArray[2] = "mul";
                break;
            }
            case 116: 
            case 117: {
                objectArray = objectArray;
                objectArray[2] = "div";
                break;
            }
            case 119: 
            case 120: {
                objectArray = objectArray;
                objectArray[2] = "mod";
                break;
            }
            case 122: {
                objectArray = objectArray;
                objectArray[2] = "not";
                break;
            }
            case 124: 
            case 125: {
                objectArray = objectArray;
                objectArray[2] = "typeOfIs";
                break;
            }
            case 127: {
                objectArray = objectArray;
                objectArray[2] = "newVar";
                break;
            }
            case 129: {
                objectArray = objectArray;
                objectArray[2] = "newSequence";
                break;
            }
            case 132: {
                objectArray = objectArray;
                objectArray[2] = "createFunctionWithEmptyBody";
                break;
            }
            case 134: {
                objectArray = objectArray;
                objectArray[2] = "toStringLiteralList";
                break;
            }
            case 137: 
            case 138: 
            case 139: {
                objectArray = objectArray;
                objectArray[2] = "defineProperty";
                break;
            }
            case 141: 
            case 142: {
                objectArray = objectArray;
                objectArray[2] = "defineSimpleProperty";
                break;
            }
            case 144: {
                objectArray = objectArray;
                objectArray[2] = "createDataDescriptor";
                break;
            }
            case 146: 
            case 147: {
                objectArray = objectArray;
                objectArray[2] = "wrapValue";
                break;
            }
            case 149: 
            case 150: {
                objectArray = objectArray;
                objectArray[2] = "replaceRootReference";
                break;
            }
            case 151: {
                objectArray = objectArray;
                objectArray[2] = "flattenStatement";
                break;
            }
            case 154: 
            case 156: {
                objectArray = objectArray;
                objectArray[2] = "pureFqn";
                break;
            }
            case 158: 
            case 159: {
                objectArray = objectArray;
                objectArray[2] = "invokeBind";
                break;
            }
            case 161: 
            case 162: 
            case 163: {
                objectArray = objectArray;
                objectArray[2] = "defineGetter";
                break;
            }
            case 165: {
                objectArray = objectArray;
                objectArray[2] = "prototypeOf";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 11: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 23: 
            case 27: 
            case 29: 
            case 32: 
            case 34: 
            case 36: 
            case 38: 
            case 40: 
            case 42: 
            case 45: 
            case 48: 
            case 50: 
            case 52: 
            case 55: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 71: 
            case 74: 
            case 79: 
            case 82: 
            case 85: 
            case 88: 
            case 91: 
            case 94: 
            case 97: 
            case 100: 
            case 106: 
            case 109: 
            case 112: 
            case 115: 
            case 118: 
            case 121: 
            case 123: 
            case 126: 
            case 128: 
            case 130: 
            case 131: 
            case 133: 
            case 135: 
            case 136: 
            case 140: 
            case 143: 
            case 145: 
            case 148: 
            case 152: 
            case 153: 
            case 155: 
            case 157: 
            case 160: 
            case 164: 
            case 166: 
            case 167: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

