/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.utils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Interner<T> {
    private final Interner<T> parent;
    private final int firstIndex;
    private final Map<T, Integer> interned = new HashMap<T, Integer>();

    public Interner(Interner<T> parent2) {
        this.parent = parent2;
        this.firstIndex = parent2 != null ? parent2.interned.size() + parent2.firstIndex : 0;
    }

    public Interner() {
        this(null);
    }

    @Nullable
    private Integer find(@NotNull T obj) {
        Integer index2;
        if (obj == null) {
            Interner.$$$reportNull$$$0(0);
        }
        assert (this.parent == null || this.parent.interned.size() + this.parent.firstIndex == this.firstIndex) : "Parent changed in parallel with child: indexes will be wrong";
        if (this.parent != null && (index2 = super.find(obj)) != null) {
            return index2;
        }
        return this.interned.get(obj);
    }

    public int intern(@NotNull T obj) {
        Integer index2;
        if (obj == null) {
            Interner.$$$reportNull$$$0(1);
        }
        if ((index2 = this.find(obj)) != null) {
            return index2;
        }
        index2 = this.firstIndex + this.interned.size();
        this.interned.put(obj, index2);
        return index2;
    }

    @NotNull
    public List<T> getAllInternedObjects() {
        List<Object> list2 = CollectionsKt.sortedBy(this.interned.keySet(), this.interned::get);
        if (list2 == null) {
            Interner.$$$reportNull$$$0(2);
        }
        return list2;
    }

    public boolean isEmpty() {
        return this.interned.isEmpty() && (this.parent == null || this.parent.isEmpty());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "obj";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/utils/Interner";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/utils/Interner";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllInternedObjects";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "find";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "intern";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

