/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ModuleVersionSelector;
import org.gradle.api.internal.artifacts.ImmutableModuleIdentifierFactory;
import org.gradle.api.internal.artifacts.ResolvedConfigurationIdentifier;
import org.gradle.api.internal.artifacts.dsl.ModuleReplacementsData;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.ModuleExclusions;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ComponentState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.DeselectVersionAction;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ModuleResolveState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.NodeState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ReplaceSelectionWithConflictResultAction;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.RootNode;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.SelectorState;
import org.gradle.api.internal.attributes.AttributesSchemaInternal;
import org.gradle.api.specs.Spec;
import org.gradle.internal.component.model.ConfigurationMetadata;
import org.gradle.internal.component.model.DependencyMetadata;
import org.gradle.internal.id.IdGenerator;
import org.gradle.internal.resolve.resolver.ComponentMetaDataResolver;
import org.gradle.internal.resolve.resolver.DependencyToComponentIdResolver;
import org.gradle.internal.resolve.result.ComponentResolveResult;

class ResolveState {
    private final Spec<? super DependencyMetadata> edgeFilter;
    private final Map<ModuleIdentifier, ModuleResolveState> modules = new LinkedHashMap<ModuleIdentifier, ModuleResolveState>();
    private final Map<ResolvedConfigurationIdentifier, NodeState> nodes = new LinkedHashMap<ResolvedConfigurationIdentifier, NodeState>();
    private final Map<ModuleVersionSelector, SelectorState> selectors = new LinkedHashMap<ModuleVersionSelector, SelectorState>();
    private final RootNode root;
    private final IdGenerator<Long> idGenerator;
    private final DependencyToComponentIdResolver idResolver;
    private final ComponentMetaDataResolver metaDataResolver;
    private final Set<NodeState> queued = Sets.newHashSet();
    private final LinkedList<NodeState> queue = new LinkedList();
    private final AttributesSchemaInternal attributesSchema;
    private final ImmutableModuleIdentifierFactory moduleIdentifierFactory;
    private final ModuleExclusions moduleExclusions;
    private final DeselectVersionAction deselectVersionAction = new DeselectVersionAction(this);
    private final ReplaceSelectionWithConflictResultAction replaceSelectionWithConflictResultAction;
    private final ModuleReplacementsData moduleReplacementsData;

    public ResolveState(IdGenerator<Long> idGenerator, ComponentResolveResult rootResult, String rootConfigurationName, DependencyToComponentIdResolver idResolver, ComponentMetaDataResolver metaDataResolver, Spec<? super DependencyMetadata> edgeFilter, AttributesSchemaInternal attributesSchema, ImmutableModuleIdentifierFactory moduleIdentifierFactory, ModuleExclusions moduleExclusions, ModuleReplacementsData moduleReplacementsData) {
        this.idGenerator = idGenerator;
        this.idResolver = idResolver;
        this.metaDataResolver = metaDataResolver;
        this.edgeFilter = edgeFilter;
        this.attributesSchema = attributesSchema;
        this.moduleIdentifierFactory = moduleIdentifierFactory;
        this.moduleExclusions = moduleExclusions;
        this.moduleReplacementsData = moduleReplacementsData;
        ComponentState rootVersion = this.getRevision(rootResult.getId());
        rootVersion.setMetaData(rootResult.getMetaData());
        this.root = new RootNode((Long)idGenerator.generateId(), rootVersion, new ResolvedConfigurationIdentifier(rootVersion.getId(), rootConfigurationName), this);
        this.nodes.put(this.root.getResolvedConfigurationId(), this.root);
        this.root.getComponent().getModule().select(this.root.getComponent());
        this.replaceSelectionWithConflictResultAction = new ReplaceSelectionWithConflictResultAction(this);
    }

    public Collection<ModuleResolveState> getModules() {
        return this.modules.values();
    }

    Spec<? super DependencyMetadata> getEdgeFilter() {
        return this.edgeFilter;
    }

    RootNode getRoot() {
        return this.root;
    }

    public ModuleResolveState getModule(ModuleIdentifier id) {
        ModuleResolveState module = this.modules.get(id);
        if (module == null) {
            module = new ModuleResolveState(this.idGenerator, id, this.metaDataResolver);
            this.modules.put(id, module);
        }
        return module;
    }

    public ComponentState getRevision(ModuleVersionIdentifier id) {
        return this.getModule(id.getModule()).getVersion(id);
    }

    public Collection<NodeState> getNodes() {
        return this.nodes.values();
    }

    public NodeState getNode(ComponentState module, ConfigurationMetadata configurationMetadata) {
        ResolvedConfigurationIdentifier id = new ResolvedConfigurationIdentifier(module.getId(), configurationMetadata.getName());
        NodeState configuration = this.nodes.get(id);
        if (configuration == null) {
            configuration = new NodeState((Long)this.idGenerator.generateId(), id, module, this, configurationMetadata);
            this.nodes.put(id, configuration);
        }
        return configuration;
    }

    public Collection<SelectorState> getSelectors() {
        return this.selectors.values();
    }

    public SelectorState getSelector(DependencyMetadata dependencyMetadata) {
        ModuleVersionSelector requested = dependencyMetadata.getRequested();
        SelectorState resolveState = this.selectors.get(requested);
        if (resolveState == null) {
            resolveState = new SelectorState((Long)this.idGenerator.generateId(), dependencyMetadata, this.idResolver, this);
            this.selectors.put(requested, resolveState);
        }
        return resolveState;
    }

    public NodeState peek() {
        return this.queue.isEmpty() ? null : this.queue.getFirst();
    }

    public NodeState pop() {
        NodeState next = this.queue.removeFirst();
        this.queued.remove(next);
        return next;
    }

    public void onMoreSelected(NodeState node) {
        if (this.queued.add(node)) {
            this.queue.addLast(node);
        }
    }

    public void onFewerSelected(NodeState node) {
        if (this.queued.add(node)) {
            this.queue.addFirst(node);
        }
    }

    public AttributesSchemaInternal getAttributesSchema() {
        return this.attributesSchema;
    }

    public ImmutableModuleIdentifierFactory getModuleIdentifierFactory() {
        return this.moduleIdentifierFactory;
    }

    public ModuleExclusions getModuleExclusions() {
        return this.moduleExclusions;
    }

    public DeselectVersionAction getDeselectVersionAction() {
        return this.deselectVersionAction;
    }

    public ReplaceSelectionWithConflictResultAction getReplaceSelectionWithConflictResultAction() {
        return this.replaceSelectionWithConflictResultAction;
    }

    public ModuleReplacementsData getModuleReplacementsData() {
        return this.moduleReplacementsData;
    }
}

