/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks;

import org.gradle.api.internal.tasks.TaskValidationContext;
import org.gradle.api.internal.tasks.ValidatingValue;
import org.gradle.api.internal.tasks.ValidationAction;
import org.gradle.util.DeferredUtil;

public class StaticValue
implements ValidatingValue {
    private final Object value;

    public StaticValue(Object value) {
        this.value = value;
    }

    public Object call() {
        return this.value;
    }

    public void validate(String propertyName, boolean optional, ValidationAction valueValidator, TaskValidationContext context) {
        Object unpacked = DeferredUtil.unpack(this.value);
        if (unpacked == null) {
            if (!optional) {
                context.recordValidationMessage(TaskValidationContext.Severity.WARNING, String.format("No value has been specified for property '%s'.", propertyName));
            }
        } else {
            valueValidator.validate(propertyName, unpacked, context, TaskValidationContext.Severity.WARNING);
        }
    }
}

