/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.util;

import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.List;

public class Alignment<T> {
    private final T previousValue;
    private final T currentValue;
    private final Kind kind;

    private Alignment(T previous, T current) {
        this.previousValue = previous;
        this.currentValue = current;
        this.kind = Alignment.kindOf(previous, current);
    }

    public T getPreviousValue() {
        return this.previousValue;
    }

    public T getCurrentValue() {
        return this.currentValue;
    }

    public Kind getKind() {
        return this.kind;
    }

    private static <T> Kind kindOf(T previous, T current) {
        if (previous == current) {
            return Kind.identical;
        }
        if (previous == null) {
            return Kind.added;
        }
        if (current == null) {
            return Kind.removed;
        }
        if (current.equals(previous)) {
            return Kind.identical;
        }
        return Kind.transformed;
    }

    public String toString() {
        switch (this.kind) {
            case added: {
                return "+" + this.currentValue;
            }
            case removed: {
                return "-" + this.previousValue;
            }
            case transformed: {
                return this.previousValue + " -> " + this.currentValue;
            }
            case identical: {
                return this.previousValue.toString();
            }
        }
        throw new IllegalStateException();
    }

    public static <T> List<Alignment<T>> align(T[] current, T[] previous) {
        int currentLen = current.length;
        int previousLen = previous.length;
        int[][] costs = new int[currentLen + 1][previousLen + 1];
        for (int j = 0; j <= previousLen; ++j) {
            costs[0][j] = j;
        }
        for (int i = 1; i <= currentLen; ++i) {
            costs[i][0] = i;
            for (int j = 1; j <= previousLen; ++j) {
                costs[i][j] = Math.min(Math.min(costs[i - 1][j], costs[i][j - 1]) + 1, current[i - 1].equals(previous[j - 1]) ? costs[i - 1][j - 1] : costs[i - 1][j - 1] + 1);
            }
        }
        LinkedList result = Lists.newLinkedList();
        int i = currentLen;
        int j = previousLen;
        while (i > 0 || j > 0) {
            int cost = costs[i][j];
            if (i > 0 && j > 0 && cost == (current[i - 1].equals(previous[j - 1]) ? costs[i - 1][j - 1] : costs[i - 1][j - 1] + 1)) {
                T b;
                T a;
                if ((a = current[--i]).equals(b = previous[--j])) {
                    result.add(0, new Alignment<T>(b, a));
                    continue;
                }
                result.add(0, new Alignment<T>(b, a));
                continue;
            }
            if (i > 0 && cost == 1 + costs[i - 1][j]) {
                result.add(0, new Alignment<Object>(null, current[--i]));
                continue;
            }
            if (j > 0 && cost == 1 + costs[i][j - 1]) {
                result.add(0, new Alignment<Object>(previous[--j], null));
                continue;
            }
            throw new IllegalStateException("Unexpected cost matrix");
        }
        return result;
    }

    public static enum Kind {
        added,
        removed,
        transformed,
        identical;

    }
}

