/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.server;

import java.util.List;
import org.gradle.api.internal.specs.ExplainingSpec;
import org.gradle.api.specs.Spec;
import org.gradle.launcher.daemon.context.DaemonCompatibilitySpec;
import org.gradle.launcher.daemon.context.DaemonContext;
import org.gradle.launcher.daemon.registry.DaemonInfo;
import org.gradle.launcher.daemon.server.Daemon;
import org.gradle.launcher.daemon.server.expiry.DaemonExpirationResult;
import org.gradle.launcher.daemon.server.expiry.DaemonExpirationStatus;
import org.gradle.launcher.daemon.server.expiry.DaemonExpirationStrategy;
import org.gradle.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompatibleDaemonExpirationStrategy
implements DaemonExpirationStrategy {
    private final Daemon daemon;
    private final ExplainingSpec<DaemonContext> compatibilitySpec;
    public static final String EXPIRATION_REASON = "other compatible daemons were started";

    CompatibleDaemonExpirationStrategy(Daemon daemon, ExplainingSpec<DaemonContext> compatibilitySpec) {
        this.daemon = daemon;
        this.compatibilitySpec = compatibilitySpec;
    }

    CompatibleDaemonExpirationStrategy(Daemon daemon) {
        this(daemon, new DaemonCompatibilitySpec(daemon.getDaemonContext()));
    }

    @Override
    public DaemonExpirationResult checkExpiration() {
        Spec<DaemonInfo> spec = new Spec<DaemonInfo>(){

            @Override
            public boolean isSatisfiedBy(DaemonInfo daemonInfo) {
                return CompatibleDaemonExpirationStrategy.this.compatibilitySpec.isSatisfiedBy((Object)daemonInfo.getContext());
            }
        };
        List<DaemonInfo> compatibleIdleDaemons = CollectionUtils.filter(this.daemon.getDaemonRegistry().getIdle(), spec);
        if (compatibleIdleDaemons.size() > 1) {
            return new DaemonExpirationResult(DaemonExpirationStatus.GRACEFUL_EXPIRE, EXPIRATION_REASON);
        }
        return DaemonExpirationResult.NOT_TRIGGERED;
    }
}

