/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.swift.tasks;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Incubating;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.language.swift.internal.SwiftStdlibToolLocator;
import org.gradle.process.ExecSpec;

@Incubating
public class CreateSwiftBundle
extends DefaultTask {
    private final RegularFileProperty informationFile = this.newInputFile();
    private final RegularFileProperty executableFile = this.newInputFile();
    private final DirectoryProperty outputDir = this.newOutputDirectory();
    private final SwiftStdlibToolLocator swiftStdlibToolLocator;

    @Inject
    public CreateSwiftBundle(SwiftStdlibToolLocator swiftStdlibToolLocator) {
        this.swiftStdlibToolLocator = swiftStdlibToolLocator;
    }

    @TaskAction
    void createBundle() throws IOException {
        this.getProject().copy((Action)new Action<CopySpec>(){

            public void execute(CopySpec copySpec) {
                copySpec.from((Object)CreateSwiftBundle.this.getExecutableFile(), (Action)new Action<CopySpec>(){

                    public void execute(CopySpec copySpec) {
                        copySpec.into((Object)"Contents/MacOS");
                    }
                });
                copySpec.into((Object)CreateSwiftBundle.this.getOutputDir());
            }
        });
        File outputFile = ((RegularFile)this.getOutputDir().file("Contents/Info.plist").get()).getAsFile();
        if (!this.informationFile.isPresent() || !((RegularFile)this.informationFile.get()).getAsFile().exists()) {
            Files.write((CharSequence)"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE plist PUBLIC \"-//Apple//DTD PLIST 1.0//EN\" \"http://www.apple.com/DTDs/PropertyList-1.0.dtd\">\n<plist version=\"1.0\">\n<dict/>\n</plist>", (File)outputFile, (Charset)Charset.forName("UTF-8"));
        } else {
            Files.copy((File)((RegularFile)this.informationFile.get()).getAsFile(), (File)outputFile);
        }
        this.getProject().exec((Action)new Action<ExecSpec>(){

            public void execute(ExecSpec execSpec) {
                execSpec.executable((Object)CreateSwiftBundle.this.swiftStdlibToolLocator.find());
                execSpec.args(new Object[]{"--copy", "--scan-executable", ((File)CreateSwiftBundle.this.executableFile.getAsFile().get()).getAbsolutePath(), "--destination", ((Directory)CreateSwiftBundle.this.outputDir.dir("Contents/Frameworks").get()).getAsFile().getAbsolutePath(), "--platform", "macosx", "--resource-destination", ((Directory)CreateSwiftBundle.this.outputDir.dir("Contents/Resources").get()).getAsFile().getAbsolutePath(), "--scan-folder", ((Directory)CreateSwiftBundle.this.outputDir.dir("Contents/Frameworks").get()).getAsFile().getAbsolutePath()});
            }
        }).assertNormalExitValue();
    }

    @OutputDirectory
    public DirectoryProperty getOutputDir() {
        return this.outputDir;
    }

    @InputFile
    public RegularFileProperty getExecutableFile() {
        return this.executableFile;
    }

    @Optional
    @InputFiles
    public RegularFileProperty getInformationFile() {
        return this.informationFile;
    }
}

