/*
 * Decompiled with CFR 0.152.
 */
package naga.packetwriter;

import java.nio.ByteBuffer;
import naga.NIOUtils;
import naga.PacketWriter;

public class RegularPacketWriter
implements PacketWriter {
    private final boolean m_bigEndian;
    private final ByteBuffer m_header;

    public RegularPacketWriter(int n, boolean bl) {
        if (n < 1 || n > 4) {
            throw new IllegalArgumentException("Header must be between 1 and 4 bytes long.");
        }
        this.m_bigEndian = bl;
        this.m_header = ByteBuffer.allocate(n);
    }

    @Override
    public ByteBuffer[] write(ByteBuffer[] byteBufferArray) {
        this.m_header.clear();
        NIOUtils.setPacketSizeInByteBuffer(this.m_header, this.m_header.capacity(), (int)NIOUtils.remaining(byteBufferArray), this.m_bigEndian);
        this.m_header.flip();
        return NIOUtils.concat(this.m_header, byteBufferArray);
    }
}

