/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.tagging.presets;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MenuScroller;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPreset;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresetItem;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresetListener;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresetMenu;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresetReader;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresetSeparator;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresetType;
import org.openstreetmap.josm.gui.tagging.presets.items.CheckGroup;
import org.openstreetmap.josm.gui.tagging.presets.items.KeyedItem;
import org.openstreetmap.josm.gui.tagging.presets.items.Roles;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.MultiMap;
import org.openstreetmap.josm.tools.SubclassFilteredCollection;

public final class TaggingPresets {
    private static final Collection<TaggingPreset> taggingPresets = new ArrayList<TaggingPreset>();
    private static final MultiMap<String, String> PRESET_TAG_CACHE = new MultiMap();
    private static final Set<String> PRESET_ROLE_CACHE = new HashSet<String>();
    private static final Collection<TaggingPresetListener> listeners = new ArrayList<TaggingPresetListener>();

    private TaggingPresets() {
    }

    public static void readFromPreferences() {
        taggingPresets.clear();
        taggingPresets.addAll(TaggingPresetReader.readFromPreferences(false, false));
        TaggingPresets.cachePresets(taggingPresets);
    }

    public static void initialize() {
        TaggingPresets.readFromPreferences();
        for (TaggingPreset tp : taggingPresets) {
            if (tp instanceof TaggingPresetSeparator) continue;
            MainApplication.getToolbar().register(tp);
        }
        if (taggingPresets.isEmpty()) {
            MainApplication.getMenu().presetsMenu.setVisible(false);
        } else {
            HashMap<TaggingPresetMenu, JMenu> submenus = new HashMap<TaggingPresetMenu, JMenu>();
            for (TaggingPreset p : taggingPresets) {
                JMenu m;
                JMenu jMenu = m = p.group != null ? (JMenu)submenus.get(p.group) : MainApplication.getMenu().presetsMenu;
                if (m == null && p.group != null) {
                    Logging.error("No tagging preset submenu for " + p.group);
                    continue;
                }
                if (m == null) {
                    Logging.error("No tagging preset menu. Tagging preset " + p + " won't be available there");
                    continue;
                }
                if (p instanceof TaggingPresetSeparator) {
                    m.add(new JSeparator());
                    continue;
                }
                if (p instanceof TaggingPresetMenu) {
                    JMenu submenu = new JMenu(p);
                    submenu.setText(p.getLocaleName());
                    ((TaggingPresetMenu)p).menu = submenu;
                    submenus.put((TaggingPresetMenu)p, submenu);
                    m.add(submenu);
                    continue;
                }
                JMenuItem mi = new JMenuItem(p);
                mi.setText(p.getLocaleName());
                m.add(mi);
            }
            for (JMenu submenu : submenus.values()) {
                if (submenu.getItemCount() < Config.getPref().getInt("taggingpreset.min-elements-for-scroller", 15)) continue;
                MenuScroller.setScrollerFor(submenu);
            }
        }
        if (Config.getPref().getBoolean("taggingpreset.sortmenu")) {
            TaggingPresetMenu.sortMenu(MainApplication.getMenu().presetsMenu);
        }
    }

    public static void cachePresets(Collection<TaggingPreset> presets) {
        for (TaggingPreset p : presets) {
            for (TaggingPresetItem item : p.data) {
                TaggingPresets.cachePresetItem(p, item);
            }
        }
    }

    private static void cachePresetItem(TaggingPreset p, TaggingPresetItem item) {
        block6: {
            block5: {
                if (!(item instanceof KeyedItem)) break block5;
                KeyedItem ki = (KeyedItem)item;
                if (ki.key == null || ki.getValues() == null) break block6;
                PRESET_TAG_CACHE.putAll(ki.key, ki.getValues());
                break block6;
            }
            if (item instanceof Roles) {
                Roles r = (Roles)item;
                for (Roles.Role i : r.roles) {
                    if (i.key == null) continue;
                    PRESET_ROLE_CACHE.add(i.key);
                }
            } else if (item instanceof CheckGroup) {
                for (KeyedItem keyedItem : ((CheckGroup)item).checks) {
                    TaggingPresets.cachePresetItem(p, keyedItem);
                }
            }
        }
    }

    public static Collection<TaggingPreset> getTaggingPresets() {
        return Collections.unmodifiableCollection(taggingPresets);
    }

    public static Set<String> getPresetRoles() {
        return Collections.unmodifiableSet(PRESET_ROLE_CACHE);
    }

    public static Set<String> getPresetKeys() {
        return Collections.unmodifiableSet(PRESET_TAG_CACHE.keySet());
    }

    public static Set<String> getPresetValues(String key) {
        Set<String> values = PRESET_TAG_CACHE.get(key);
        if (values != null) {
            return Collections.unmodifiableSet(values);
        }
        return null;
    }

    public static Collection<TaggingPreset> getMatchingPresets(Collection<TaggingPresetType> t, Map<String, String> tags, boolean onlyShowable) {
        return SubclassFilteredCollection.filter(TaggingPresets.getTaggingPresets(), preset -> preset.matches(t, tags, onlyShowable));
    }

    public static Collection<TaggingPreset> getMatchingPresets(OsmPrimitive primitive) {
        return SubclassFilteredCollection.filter(TaggingPresets.getTaggingPresets(), preset -> preset.test(primitive));
    }

    public static void addTaggingPresets(Collection<TaggingPreset> presets) {
        if (presets != null && taggingPresets.addAll(presets)) {
            for (TaggingPresetListener listener : listeners) {
                listener.taggingPresetsModified();
            }
        }
    }

    public static void addListener(TaggingPresetListener listener) {
        if (listener != null) {
            listeners.add(listener);
        }
    }

    public static void removeListener(TaggingPresetListener listener) {
        if (listener != null) {
            listeners.remove(listener);
        }
    }
}

