/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.util;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.JosmRuntimeException;
import org.openstreetmap.josm.tools.Logging;

public class WindowGeometry {
    private Point topLeft;
    private Dimension extent;

    public WindowGeometry(Point topLeft, Dimension extent) {
        this.topLeft = topLeft;
        this.extent = extent;
    }

    public WindowGeometry(Rectangle rect) {
        this(rect.getLocation(), rect.getSize());
    }

    public WindowGeometry(Window window) {
        this(window.getLocationOnScreen(), window.getSize());
    }

    public WindowGeometry(String preferenceKey) throws WindowGeometryException {
        this.initFromPreferences(preferenceKey);
    }

    public WindowGeometry(String preferenceKey, WindowGeometry defaultGeometry) {
        try {
            this.initFromPreferences(preferenceKey);
        }
        catch (WindowGeometryException e) {
            Logging.debug(e);
            this.initFromWindowGeometry(defaultGeometry);
        }
    }

    public static WindowGeometry centerOnScreen(Dimension extent) {
        return WindowGeometry.centerOnScreen(extent, "gui.geometry");
    }

    public static WindowGeometry centerOnScreen(Dimension extent, String preferenceKey) {
        Rectangle size = preferenceKey != null ? WindowGeometry.getScreenInfo(preferenceKey) : WindowGeometry.getFullScreenInfo();
        Point topLeft = new Point(size.x + Math.max(0, (size.width - extent.width) / 2), size.y + Math.max(0, (size.height - extent.height) / 2));
        return new WindowGeometry(topLeft, extent);
    }

    public static WindowGeometry centerInWindow(Component reference, Dimension extent) {
        while (reference != null && !(reference instanceof Window)) {
            reference = reference.getParent();
        }
        if (reference == null) {
            return new WindowGeometry(new Point(0, 0), extent);
        }
        Window parentWindow = (Window)reference;
        Point topLeft = new Point(Math.max(0, (parentWindow.getSize().width - extent.width) / 2), Math.max(0, (parentWindow.getSize().height - extent.height) / 2));
        topLeft.x += parentWindow.getLocation().x;
        topLeft.y += parentWindow.getLocation().y;
        return new WindowGeometry(topLeft, extent);
    }

    public void fixScreen(Window window) {
        Rectangle oldScreen = WindowGeometry.getScreenInfo(this.getRectangle());
        Rectangle newScreen = WindowGeometry.getScreenInfo(new Rectangle(window.getLocationOnScreen(), window.getSize()));
        if (oldScreen.x != newScreen.x) {
            this.topLeft.x += newScreen.x - oldScreen.x;
        }
        if (oldScreen.y != newScreen.y) {
            this.topLeft.y += newScreen.y - oldScreen.y;
        }
    }

    protected int parseField(String preferenceKey, String preferenceValue, String field) throws WindowGeometryException {
        String v = "";
        try {
            Pattern p = Pattern.compile(field + "=(-?\\d+)", 2);
            Matcher m = p.matcher(preferenceValue);
            if (!m.find()) {
                throw new WindowGeometryException(I18n.tr("Preference with key ''{0}'' does not include ''{1}''. Cannot restore window geometry from preferences.", preferenceKey, field));
            }
            v = m.group(1);
            return Integer.parseInt(v);
        }
        catch (WindowGeometryException e) {
            throw e;
        }
        catch (NumberFormatException e) {
            throw new WindowGeometryException(I18n.tr("Preference with key ''{0}'' does not provide an int value for ''{1}''. Got {2}. Cannot restore window geometry from preferences.", preferenceKey, field, v), e);
        }
        catch (IllegalArgumentException | IllegalStateException | JosmRuntimeException e) {
            throw new WindowGeometryException(I18n.tr("Failed to parse field ''{1}'' in preference with key ''{0}''. Exception was: {2}. Cannot restore window geometry from preferences.", preferenceKey, field, e.toString()), e);
        }
    }

    protected final void initFromPreferences(String preferenceKey) throws WindowGeometryException {
        String value = Config.getPref().get(preferenceKey);
        if (value.isEmpty()) {
            throw new WindowGeometryException(I18n.tr("Preference with key ''{0}'' does not exist. Cannot restore window geometry from preferences.", preferenceKey));
        }
        this.topLeft = new Point();
        this.extent = new Dimension();
        this.topLeft.x = this.parseField(preferenceKey, value, "x");
        this.topLeft.y = this.parseField(preferenceKey, value, "y");
        this.extent.width = this.parseField(preferenceKey, value, "width");
        this.extent.height = this.parseField(preferenceKey, value, "height");
    }

    protected final void initFromWindowGeometry(WindowGeometry other) {
        this.topLeft = other.topLeft;
        this.extent = other.extent;
    }

    public static WindowGeometry mainWindow(String preferenceKey, String arg, boolean maximize) {
        WindowGeometry def;
        Rectangle screenDimension = WindowGeometry.getScreenInfo("gui.geometry");
        if (arg != null) {
            Matcher m = Pattern.compile("(\\d+)x(\\d+)(([+-])(\\d+)([+-])(\\d+))?").matcher(arg);
            if (m.matches()) {
                int w = Integer.parseInt(m.group(1));
                int h = Integer.parseInt(m.group(2));
                int x = screenDimension.x;
                int y = screenDimension.y;
                if (m.group(3) != null) {
                    x = Integer.parseInt(m.group(5));
                    y = Integer.parseInt(m.group(7));
                    if ("-".equals(m.group(4))) {
                        x = screenDimension.x + screenDimension.width - x - w;
                    }
                    if ("-".equals(m.group(6))) {
                        y = screenDimension.y + screenDimension.height - y - h;
                    }
                }
                return new WindowGeometry(new Point(x, y), new Dimension(w, h));
            }
            Logging.warn(I18n.tr("Ignoring malformed geometry: {0}", arg));
        }
        if (maximize) {
            def = new WindowGeometry(screenDimension);
        } else {
            Point p = screenDimension.getLocation();
            p.x += (screenDimension.width - 1000) / 2;
            p.y += (screenDimension.height - 740) / 2;
            def = new WindowGeometry(p, new Dimension(1000, 740));
        }
        return new WindowGeometry(preferenceKey, def);
    }

    public void remember(String preferenceKey) {
        StringBuilder value = new StringBuilder(32);
        value.append("x=").append(this.topLeft.x).append(",y=").append(this.topLeft.y).append(",width=").append(this.extent.width).append(",height=").append(this.extent.height);
        Config.getPref().put(preferenceKey, value.toString());
    }

    public Point getTopLeft() {
        return this.topLeft;
    }

    public Dimension getSize() {
        return this.extent;
    }

    private Rectangle getRectangle() {
        return new Rectangle(this.topLeft, this.extent);
    }

    public void applySafe(Window window) {
        Rectangle maxbounds;
        int deltay;
        Point p = new Point(this.topLeft);
        Dimension size = new Dimension(this.extent);
        Rectangle virtualBounds = WindowGeometry.getVirtualScreenBounds();
        if (p.x < virtualBounds.x) {
            p.x = virtualBounds.x;
        } else if (p.x > virtualBounds.x + virtualBounds.width - size.width) {
            p.x = virtualBounds.x + virtualBounds.width - size.width;
        }
        if (p.y < virtualBounds.y) {
            p.y = virtualBounds.y;
        } else if (p.y > virtualBounds.y + virtualBounds.height - size.height) {
            p.y = virtualBounds.y + virtualBounds.height - size.height;
        }
        int deltax = p.x + size.width - (virtualBounds.x + virtualBounds.width);
        if (deltax > 0) {
            size.width -= deltax;
        }
        if ((deltay = p.y + size.height - (virtualBounds.y + virtualBounds.height)) > 0) {
            size.height -= deltay;
        }
        if (!WindowGeometry.isBugInMaximumWindowBounds(maxbounds = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds())) {
            deltax = size.width - maxbounds.width;
            if (deltax > 0) {
                size.width -= deltax;
            }
            if ((deltay = size.height - maxbounds.height) > 0) {
                size.height -= deltay;
            }
        }
        window.setLocation(p);
        window.setSize(size);
    }

    protected static boolean isBugInMaximumWindowBounds(Rectangle maxbounds) {
        return maxbounds.width <= 0 || maxbounds.height <= 0;
    }

    public static Rectangle getVirtualScreenBounds() {
        Rectangle virtualBounds = new Rectangle();
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        if (!GraphicsEnvironment.isHeadless()) {
            for (GraphicsDevice gd : ge.getScreenDevices()) {
                if (gd.getType() != 0) continue;
                virtualBounds = virtualBounds.union(gd.getDefaultConfiguration().getBounds());
            }
        }
        return virtualBounds;
    }

    public static Dimension getMaxDimensionOnScreen(JComponent component) {
        CheckParameterUtil.ensureParameterNotNull(component, "component");
        Dimension result = new Dimension();
        GraphicsConfiguration gc = component.getGraphicsConfiguration();
        if (gc == null && Main.parent != null) {
            gc = Main.parent.getGraphicsConfiguration();
        }
        if (gc != null) {
            Rectangle bounds = gc.getBounds();
            Insets insets = component.getToolkit().getScreenInsets(gc);
            result.width = bounds.width - insets.left - insets.right;
            result.height = bounds.height - insets.top - insets.bottom;
        }
        return result;
    }

    public static Rectangle getScreenInfo(String preferenceKey) {
        Rectangle g = new WindowGeometry(preferenceKey, new WindowGeometry(new Point(0, 0), new Dimension(10, 10))).getRectangle();
        return WindowGeometry.getScreenInfo(g);
    }

    private static Rectangle getScreenInfo(Rectangle g) {
        Rectangle bounds = null;
        if (!GraphicsEnvironment.isHeadless()) {
            int intersect = 0;
            for (GraphicsDevice gd : GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices()) {
                int s;
                Rectangle is;
                if (gd.getType() != 0) continue;
                Rectangle b = gd.getDefaultConfiguration().getBounds();
                if (b.height > 0 && b.width / b.height >= 3) {
                    b.width /= 2;
                    is = b.intersection(g);
                    s = is.width * is.height;
                    if (bounds == null || intersect < s) {
                        intersect = s;
                        bounds = b;
                    }
                    b = new Rectangle(b);
                    b.x += b.width;
                    is = b.intersection(g);
                    s = is.width * is.height;
                    if (intersect >= s) continue;
                    intersect = s;
                    bounds = b;
                    continue;
                }
                is = b.intersection(g);
                s = is.width * is.height;
                if (bounds != null && intersect >= s) continue;
                intersect = s;
                bounds = b;
            }
        }
        return bounds != null ? bounds : g;
    }

    public static Rectangle getFullScreenInfo() {
        return new Rectangle(new Point(0, 0), GuiHelper.getScreenSize());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.extent == null ? 0 : this.extent.hashCode());
        result = 31 * result + (this.topLeft == null ? 0 : this.topLeft.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        WindowGeometry other = (WindowGeometry)obj;
        if (this.extent == null ? other.extent != null : !this.extent.equals(other.extent)) {
            return false;
        }
        return !(this.topLeft == null ? other.topLeft != null : !this.topLeft.equals(other.topLeft));
    }

    public String toString() {
        return "WindowGeometry{topLeft=" + this.topLeft + ",extent=" + this.extent + '}';
    }

    public static class WindowGeometryException
    extends Exception {
        WindowGeometryException(String message, Throwable cause) {
            super(message, cause);
        }

        WindowGeometryException(String message) {
            super(message);
        }
    }
}

