/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.widgets;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.text.MessageFormat;
import java.util.Optional;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.text.html.StyleSheet;
import org.openstreetmap.josm.gui.widgets.JosmEditorPane;
import org.openstreetmap.josm.gui.widgets.JosmHTMLEditorKit;

public class HtmlPanel
extends JPanel {
    private JosmEditorPane jepMessage;

    protected final void build() {
        this.setLayout(new BorderLayout());
        this.jepMessage = new JosmEditorPane("text/html", "");
        this.jepMessage.setOpaque(false);
        this.jepMessage.setEditable(false);
        Font f = UIManager.getFont("Label.font");
        StyleSheet ss = new StyleSheet();
        ss.addRule("body {" + MessageFormat.format("font-family: ''{0}'';font-size: {1,number}pt; font-weight: {2}; font-style: {3}", f.getName(), f.getSize(), f.isBold() ? "bold" : "normal", f.isItalic() ? "italic" : "normal") + '}');
        ss.addRule("strong {" + MessageFormat.format("font-family: ''{0}'';font-size: {1,number}pt; font-weight: {2}; font-style: {3}", f.getName(), f.getSize(), "bold", f.isItalic() ? "italic" : "normal") + '}');
        ss.addRule("a {text-decoration: underline; color: blue}");
        ss.addRule("ul {margin-left: 1cm; list-style-type: disc}");
        JosmHTMLEditorKit kit = new JosmHTMLEditorKit();
        kit.setStyleSheet(ss);
        this.jepMessage.setEditorKit(kit);
        this.add((Component)this.jepMessage, "Center");
    }

    public HtmlPanel() {
        this.build();
    }

    public HtmlPanel(String text) {
        this();
        this.setText(text);
    }

    public JEditorPane getEditorPane() {
        return this.jepMessage;
    }

    public final void setText(String text) {
        this.jepMessage.setText(Optional.ofNullable(text).orElse(""));
    }
}

